/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.util;

import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.MappedTableColumn;
import ghidra.docking.settings.Settings;
import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.table.MappedProgramLocationTableColumn;
import ghidra.util.table.ProgramLocationTableRowMapper;
import ghidra.util.table.field.ProgramLocationTableColumn;

public class VTMarkupItemDestinationAddressToProgramLocationTableRowMapper
extends ProgramLocationTableRowMapper<VTMarkupItem, ProgramLocation> {
    public <COLUMN_TYPE> DynamicTableColumn<VTMarkupItem, COLUMN_TYPE, Program> createMappedTableColumn(DynamicTableColumn<ProgramLocation, COLUMN_TYPE, Program> destinationColumn) {
        if (destinationColumn instanceof ProgramLocationTableColumn) {
            ProgramLocationTableColumn programColumn = (ProgramLocationTableColumn)destinationColumn;
            return new VTMarkupItemDestinationWrappedMappedProgramLocationTableColumn(this, this, programColumn);
        }
        return new VTMarkupItemDestinationWrappedMappedTableColumn<COLUMN_TYPE>(this, this, destinationColumn);
    }

    public ProgramLocation map(VTMarkupItem rowObject, Program program, ServiceProvider serviceProvider) {
        Address address = rowObject.getDestinationAddress();
        if (address != null) {
            return new ProgramLocation(program, address);
        }
        return null;
    }

    private class VTMarkupItemDestinationWrappedMappedProgramLocationTableColumn<COLUMN_TYPE>
    extends MappedProgramLocationTableColumn<VTMarkupItem, ProgramLocation, COLUMN_TYPE> {
        public VTMarkupItemDestinationWrappedMappedProgramLocationTableColumn(VTMarkupItemDestinationAddressToProgramLocationTableRowMapper vTMarkupItemDestinationAddressToProgramLocationTableRowMapper, ProgramLocationTableRowMapper<VTMarkupItem, ProgramLocation> mapper, ProgramLocationTableColumn<ProgramLocation, COLUMN_TYPE> tableColumn) {
            super(mapper, tableColumn, "VTMarkupItemDestination." + tableColumn.getUniqueIdentifier());
        }

        public String getColumnDisplayName(Settings settings) {
            return "Dest " + super.getColumnDisplayName(settings);
        }

        public String getColumnDescription() {
            return super.getColumnName() + " (for a markup items's destination address)";
        }

        public String getColumnName() {
            return "Dest " + super.getColumnName();
        }
    }

    private class VTMarkupItemDestinationWrappedMappedTableColumn<COLUMN_TYPE>
    extends MappedTableColumn<VTMarkupItem, ProgramLocation, COLUMN_TYPE, Program> {
        public VTMarkupItemDestinationWrappedMappedTableColumn(VTMarkupItemDestinationAddressToProgramLocationTableRowMapper vTMarkupItemDestinationAddressToProgramLocationTableRowMapper, ProgramLocationTableRowMapper<VTMarkupItem, ProgramLocation> mapper, DynamicTableColumn<ProgramLocation, COLUMN_TYPE, Program> tableColumn) {
            super(mapper, tableColumn, "VTMarkupItemDestination." + tableColumn.getUniqueIdentifier());
        }

        public String getColumnDisplayName(Settings settings) {
            return "Dest " + super.getColumnDisplayName(settings);
        }

        public String getColumnDescription() {
            return super.getColumnName() + " (for a markup items's destination address)";
        }

        public String getColumnName() {
            return "Dest " + super.getColumnName();
        }
    }
}

