/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.programtree;

import docking.dnd.DragSrcAdapter;
import docking.dnd.Draggable;
import generic.theme.GIcon;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.dnd.DragSource;

class TreeDragSrcAdapter
extends DragSrcAdapter {
    private static final String MOVE_CURSOR_ID = "icon.plugin.programtree.drag.move";
    private static final String COPY_CURSOR_ID = "icon.plugin.programtree.drag.copy";
    private static final String MOVE_NAME = "MoveCursor";
    private static final String COPY_NAME = "CopyCursor";
    private Cursor feedbackCursor;
    private Cursor copyCursor;
    private Cursor moveCursor;

    public TreeDragSrcAdapter(Draggable dragComponent) {
        super(dragComponent);
    }

    protected Cursor getDropOkCursor(int action) {
        if (this.feedbackCursor != null) {
            return this.feedbackCursor;
        }
        return super.getDropOkCursor(action);
    }

    Cursor getCursor(int action, int relativeMousePos) {
        Cursor c = null;
        if ((action & 0x40000000) == 0x40000000) {
            return super.getDropOkCursor(action);
        }
        if ((action & 2) == 2) {
            c = DragSource.DefaultMoveDrop;
            if (relativeMousePos != 0) {
                c = this.getMoveCursor();
            }
        } else {
            c = DragSource.DefaultCopyDrop;
            if (relativeMousePos != 0) {
                c = this.getCopyCursor();
            }
        }
        return c;
    }

    void setFeedbackCursor(Cursor c) {
        this.feedbackCursor = c;
    }

    private Cursor getMoveCursor() {
        if (this.moveCursor == null) {
            this.moveCursor = TreeDragSrcAdapter.createCursor(MOVE_CURSOR_ID, MOVE_NAME, new Point(0, 16));
        }
        return this.moveCursor;
    }

    private Cursor getCopyCursor() {
        if (this.copyCursor == null) {
            this.copyCursor = TreeDragSrcAdapter.createCursor(COPY_CURSOR_ID, COPY_NAME, new Point(0, 24));
        }
        return this.copyCursor;
    }

    private static Cursor createCursor(String id, String cursorName, Point hotSpot) {
        GIcon icon = new GIcon(id);
        Image image = icon.getImageIcon().getImage();
        Toolkit tk = Toolkit.getDefaultToolkit();
        return tk.createCustomCursor(image, hotSpot, cursorName);
    }
}

