/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.fsbrowser.filehandlers;

import docking.action.DockingAction;
import docking.action.builder.ActionBuilder;
import docking.widgets.OptionDialog;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import docking.widgets.tree.GTree;
import ghidra.app.util.bin.ByteProvider;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.plugins.fsbrowser.FSBActionContext;
import ghidra.plugins.fsbrowser.FSBFileHandler;
import ghidra.plugins.fsbrowser.FSBFileHandlerContext;
import ghidra.plugins.fsbrowser.FSBIcons;
import ghidra.plugins.fsbrowser.FSBNode;
import ghidra.plugins.fsbrowser.tasks.GFileSystemExtractAllTask;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class ExportFSBFileHandler
implements FSBFileHandler {
    public static final String FSB_EXPORT_ALL = "FSB Export All";
    public static final String FSB_EXPORT = "FSB Export";
    private FSBFileHandlerContext context;

    @Override
    public void init(FSBFileHandlerContext context) {
        this.context = context;
    }

    @Override
    public List<DockingAction> createActions() {
        return List.of((DockingAction)new ActionBuilder(FSB_EXPORT, this.context.plugin().getName()).withContext(FSBActionContext.class).enabledWhen(ac -> ac.notBusy() && ac.getFileFSRL() != null).popupMenuIcon(FSBIcons.EXTRACT).popupMenuPath(new String[]{"Export..."}).popupMenuGroup("F", "C").onAction(ac -> {
            int answer;
            FSRL fsrl = ac.getFileFSRL();
            if (fsrl == null) {
                return;
            }
            GTree tree = ac.getTree();
            GhidraFileChooser chooser = new GhidraFileChooser((Component)tree);
            chooser.setFileSelectionMode(GhidraFileChooserMode.FILES_ONLY);
            chooser.setTitle("Select Where To Export File");
            chooser.setApproveButtonText("Export");
            chooser.setSelectedFile(new File(this.context.plugin().getLastExportDirectory(), fsrl.getName()));
            File selectedFile = chooser.getSelectedFile();
            chooser.dispose();
            if (selectedFile == null) {
                return;
            }
            if (selectedFile.exists() && (answer = OptionDialog.showYesNoDialog((Component)tree, (String)"Confirm Overwrite", (String)"%s\nThe file already exists.\nDo you want to overwrite it?".formatted(selectedFile.getAbsolutePath()))) == 2) {
                return;
            }
            this.context.plugin().setLastExportDirectory(selectedFile.getParentFile());
            tree.runTask(monitor -> this.doExtractFile(fsrl, selectedFile, ac.getSelectedNode(), monitor));
        }).build(), (DockingAction)new ActionBuilder(FSB_EXPORT_ALL, this.context.plugin().getName()).withContext(FSBActionContext.class).enabledWhen(ac -> ac.notBusy() && ac.isSelectedAllDirs()).popupMenuIcon(FSBIcons.EXTRACT).popupMenuPath(new String[]{"Export All..."}).popupMenuGroup("F", "C").onAction(ac -> {
            FSRL fsrl = ac.getFSRL(true);
            if (fsrl == null) {
                return;
            }
            GTree tree = ac.getTree();
            if (fsrl instanceof FSRLRoot) {
                fsrl = fsrl.appendPath("/");
            }
            GhidraFileChooser chooser = new GhidraFileChooser((Component)tree);
            chooser.setFileSelectionMode(GhidraFileChooserMode.DIRECTORIES_ONLY);
            chooser.setTitle("Select Export Directory");
            chooser.setApproveButtonText("Export All");
            chooser.setCurrentDirectory(this.context.plugin().getLastExportDirectory());
            File selectedFile = chooser.getSelectedFile();
            chooser.dispose();
            if (selectedFile == null) {
                return;
            }
            if (!selectedFile.isDirectory()) {
                Msg.showInfo((Object)this, (Component)tree, (String)"Export All", (Object)"Selected file is not a directory.");
                return;
            }
            this.context.plugin().setLastExportDirectory(selectedFile);
            TaskLauncher.launch((Task)new GFileSystemExtractAllTask(fsrl, selectedFile, (Component)tree));
        }).build());
    }

    private void doExtractFile(FSRL fsrl, File outputFile, FSBNode node, TaskMonitor monitor) {
        if (!this.context.fsbComponent().ensureFileAccessable(fsrl, node, monitor)) {
            return;
        }
        monitor.setMessage("Exporting...");
        try (ByteProvider fileBP = this.context.fsService().getByteProvider(fsrl, false, monitor);){
            monitor.initialize(fileBP.length(), "Exporting %s".formatted(fsrl.getName()));
            long bytesCopied = FSUtilities.copyByteProviderToFile(fileBP, outputFile, monitor);
            String msg = "Exported %s to %s, %d bytes copied.".formatted(fsrl.getName(), outputFile, bytesCopied);
            this.context.fsbComponent().getTool().setStatusInfo(msg);
            Msg.info((Object)this, (Object)msg);
        }
        catch (CancelledException | IOException | UnsupportedOperationException e) {
            FSUtilities.displayException(this, this.context.plugin().getTool().getActiveWindow(), "Error Exporting File", e.getMessage(), e);
        }
    }
}

