/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;

public class BuildInformationMsSymbol
extends AbstractMsSymbol {
    public static final int PDB_ID = 4428;
    private RecordNumber itemRecordNumber;

    public BuildInformationMsSymbol(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        this.itemRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.ITEM, 32);
    }

    @Override
    public int getPdbId() {
        return 4428;
    }

    public RecordNumber getItemRecordNumber() {
        return this.itemRecordNumber;
    }

    public String getItemString() {
        return this.pdb.getTypeRecord(this.itemRecordNumber).toString();
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append(String.format("%s: %s\n", this.getSymbolTypeName(), this.pdb.getTypeRecord(this.itemRecordNumber)));
    }

    @Override
    protected String getSymbolTypeName() {
        return "BUILDINFO";
    }
}

