/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import java.util.HashMap;
import java.util.Map;

public enum LanguageName {
    INVALID("???", -1),
    C("C", 0),
    CPP("C++", 1),
    FORTRAN("FORTRAN", 2),
    MASM("MASM", 3),
    PASCAL("Pascal", 4),
    BASIC("Basic", 5),
    COBOL("COBOL", 6),
    LINK("LINK", 7),
    CVTRES("CVTRES", 8),
    CVTPGD("CVTPGD", 9),
    CSHARP("C#", 10),
    VISUALBASIC("VisualBasic", 11),
    ILASM("ILASM", 12),
    JAVA("Java", 13),
    JSCRIPT("JScript", 14),
    MSIL("MSIL", 15),
    HLSL("HLSL", 16);

    private static final Map<Integer, LanguageName> BY_VALUE;
    public final String label;
    public final int value;

    public String toString() {
        return this.label;
    }

    public static LanguageName fromValue(int val) {
        return BY_VALUE.getOrDefault(val, INVALID);
    }

    private LanguageName(String label, int value) {
        this.label = label;
        this.value = value;
    }

    static {
        BY_VALUE = new HashMap<Integer, LanguageName>();
        for (LanguageName val : LanguageName.values()) {
            BY_VALUE.put(val.value, val);
        }
    }
}

