/*
 * Decompiled with CFR 0.152.
 */
package mdemangler.naming;

import mdemangler.MDException;
import mdemangler.MDMang;
import mdemangler.MDParsableItem;
import mdemangler.naming.MDFragmentName;
import mdemangler.template.MDTemplateNameAndArguments;

public class MDReusableName
extends MDParsableItem {
    MDFragmentName fragment;
    MDTemplateNameAndArguments templateName;
    String specialName;

    public MDReusableName(MDMang dmang) {
        super(dmang);
    }

    public String getName() {
        if (this.specialName != null) {
            return this.specialName;
        }
        if (this.fragment != null) {
            return this.fragment.getName();
        }
        if (this.templateName != null) {
            return this.templateName.getName();
        }
        return "";
    }

    public void setName(String name) {
        if (this.fragment != null) {
            this.fragment.setName(name);
        } else if (this.templateName != null) {
            this.templateName.setName(name);
        }
    }

    @Override
    public void insert(StringBuilder builder) {
        if (this.specialName != null) {
            this.dmang.insertString(builder, this.specialName);
        } else if (this.fragment != null) {
            this.fragment.insert(builder);
        } else {
            this.templateName.insert(builder);
        }
    }

    @Override
    protected void parseInternal() throws MDException {
        char code = this.dmang.peek();
        switch (code) {
            case '?': {
                this.templateName = new MDTemplateNameAndArguments(this.dmang);
                this.templateName.parse();
                this.dmang.addBackrefName(this.templateName.toString());
                break;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.dmang.increment();
                int index = code - 48;
                this.fragment = new MDFragmentName(this.dmang);
                this.fragment.setName(this.dmang.getBackreferenceName(index));
                break;
            }
            default: {
                this.fragment = new MDFragmentName(this.dmang);
                int loc = this.dmang.getIndex();
                this.fragment.parse();
                if (loc == 1) {
                    this.processSpecialName(this.fragment.getName());
                }
                this.dmang.addBackrefName(this.fragment.getName());
            }
        }
    }

    public void processSpecialName(String inputName) throws MDException {
        if (inputName.startsWith("$TSS")) {
            String guardNumberString = inputName.substring("$TSS".length());
            this.validateNumberString(guardNumberString);
            this.specialName = "`thread safe static guard{" + guardNumberString + "}'";
        } else if (inputName.equals("$S1")) {
            this.specialName = "`nonvisible static guard{1}'";
        } else if (inputName.startsWith("$RT")) {
            String manglingNumberString = inputName.substring("$RT".length());
            this.validateNumberString(manglingNumberString);
            this.specialName = "`reference temporary{" + manglingNumberString + "}'";
        }
    }

    private void validateNumberString(String numberString) throws MDException {
        numberString.getBytes();
        for (byte c : numberString.getBytes()) {
            if (Character.isDigit(c)) continue;
            throw new MDException("Illegal character in Number: " + c);
        }
    }
}

