/*
 * Decompiled with CFR 0.152.
 */
package generic.theme;

import generic.theme.JavaPropertyValue;
import ghidra.util.Msg;

public class BooleanPropertyValue
extends JavaPropertyValue {
    private static final String EXTERNAL_LAF_ID_PREFIX = "[laf.boolean]";

    public BooleanPropertyValue(String id, boolean value) {
        this(id, (String)null, value);
    }

    public BooleanPropertyValue(String id, String refId, Boolean value) {
        super(id, refId, value);
    }

    public static boolean isBooleanKey(String key) {
        return key.toLowerCase().startsWith(EXTERNAL_LAF_ID_PREFIX);
    }

    public static BooleanPropertyValue parse(String key, String value) {
        String id = BooleanPropertyValue.fromExternalId(key);
        if (BooleanPropertyValue.isBooleanKey(value)) {
            String refId = BooleanPropertyValue.fromExternalId(value);
            return new BooleanPropertyValue(key, refId, null);
        }
        boolean b = Boolean.parseBoolean(value);
        return new BooleanPropertyValue(id, b);
    }

    private static String fromExternalId(String externalId) {
        if (!externalId.toLowerCase().startsWith(EXTERNAL_LAF_ID_PREFIX)) {
            return externalId;
        }
        return externalId.substring(EXTERNAL_LAF_ID_PREFIX.length());
    }

    @Override
    protected Object getUnresolvedReferenceValue(String primaryId, String unresolvedId) {
        Msg.warn((Object)this, (Object)("Could not resolve indirect property for \"" + unresolvedId + "\" for primary id \"" + primaryId + "\", using last resort default"));
        return false;
    }

    @Override
    protected String toExternalId(String internalId) {
        return EXTERNAL_LAF_ID_PREFIX + internalId;
    }

    @Override
    protected String getSerializedValue() {
        return Boolean.toString((Boolean)this.value);
    }
}

