/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool;

import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.plugintool.ServiceProviderStub;
import ghidra.framework.plugintool.util.ServiceListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ServiceProviderDecorator
implements ServiceProvider {
    private ServiceProvider delegate;
    private Map<Class<?>, Object> overriddenServices = new HashMap();

    public static ServiceProviderDecorator decorate(ServiceProvider delegate) {
        return new ServiceProviderDecorator(delegate);
    }

    public static ServiceProviderDecorator createEmptyDecorator() {
        return new ServiceProviderDecorator(new ServiceProviderStub());
    }

    private ServiceProviderDecorator(ServiceProvider delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    public <T> void overrideService(Class<T> serviceClass, Object service) {
        this.overriddenServices.put(serviceClass, service);
    }

    @Override
    public <T> T getService(Class<T> serviceClass) {
        Object service = this.overriddenServices.get(serviceClass);
        if (service != null) {
            return serviceClass.cast(service);
        }
        return this.delegate.getService(serviceClass);
    }

    @Override
    public void addServiceListener(ServiceListener listener) {
        this.delegate.addServiceListener(listener);
    }

    @Override
    public void removeServiceListener(ServiceListener listener) {
        this.delegate.removeServiceListener(listener);
    }
}

