/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api;

import ghidra.feature.vt.api.FunctionNode;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class FunctionNodeContainer {
    private Program program;
    private Map<Address, FunctionNode> addrToNode;

    public FunctionNodeContainer(Program program, List<FunctionNode> nodeList) {
        this.program = program;
        this.addrToNode = new TreeMap<Address, FunctionNode>();
        for (FunctionNode node : nodeList) {
            this.addrToNode.put(node.getAddress(), node);
        }
        this.generateCallGraph();
    }

    public Program getProgram() {
        return this.program;
    }

    public FunctionNode get(Address addr) {
        return this.addrToNode.get(addr);
    }

    public int size() {
        return this.addrToNode.size();
    }

    public Iterator<FunctionNode> iterator() {
        return this.addrToNode.values().iterator();
    }

    private void generateCallGraph() {
        FunctionManager mgr = this.program.getFunctionManager();
        for (FunctionNode node : this.addrToNode.values()) {
            if (node == null) continue;
            List<Address> callAddresses = node.releaseCallAddresses();
            for (Address addr : callAddresses) {
                Function f;
                FunctionNode kid;
                while ((kid = this.addrToNode.get(addr)) == null && (f = mgr.getFunctionAt(addr)) != null && f.isThunk()) {
                    addr = f.getThunkedFunction(false).getEntryPoint();
                }
                if (kid == null) continue;
                node.getChildren().add(kid);
                kid.getParents().add(node);
            }
        }
    }
}

