/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.tools.api;

import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.gradle.internal.tools.api.ApiClassExtractionException;
import org.gradle.internal.tools.api.ApiMemberWriterAdapter;
import org.gradle.internal.tools.api.ApiMemberWriterFactory;
import org.gradle.internal.tools.api.impl.ApiMemberSelector;
import org.gradle.internal.tools.api.impl.MethodStubbingApiMemberAdapter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class ApiClassExtractor {
    private static final Pattern LOCAL_CLASS_PATTERN = Pattern.compile(".+\\$[0-9]+(?:[\\p{Alnum}_$]+)?$");
    private final Predicate<String> packageNameFilter;
    private final boolean apiIncludesPackagePrivateMembers;
    private final ApiMemberWriterFactory apiMemberWriterFactory;

    public static Builder withWriter(ApiMemberWriterAdapter writerCreator) {
        return new Builder(classWriter -> writerCreator.createWriter(new MethodStubbingApiMemberAdapter(classWriter)));
    }

    private ApiClassExtractor(Predicate<String> packageNameFilter, boolean includePackagePrivateMembers, ApiMemberWriterFactory apiMemberWriterFactory) {
        this.packageNameFilter = packageNameFilter;
        this.apiIncludesPackagePrivateMembers = includePackagePrivateMembers;
        this.apiMemberWriterFactory = apiMemberWriterFactory;
    }

    public Optional<byte[]> extractApiClassFrom(byte[] originalClassBytes) {
        ClassReader originalClassReader = new ClassReader(originalClassBytes);
        return this.extractApiClassFromReader(originalClassReader).map(ClassWriter::toByteArray);
    }

    protected Optional<ClassWriter> extractApiClassFromReader(ClassReader originalClassReader) {
        ApiMemberSelector visitor;
        if (!this.shouldExtractApiClassFrom(originalClassReader)) {
            return Optional.empty();
        }
        ClassWriter apiClassWriter = new ClassWriter(1);
        try {
            visitor = new ApiMemberSelector(originalClassReader.getClassName(), this.apiMemberWriterFactory.makeApiMemberWriter(apiClassWriter), this.apiIncludesPackagePrivateMembers);
            originalClassReader.accept((ClassVisitor)visitor, 6);
        }
        catch (ApiClassExtractionException e) {
            throw e.withClass(originalClassReader.getClassName());
        }
        if (visitor.isPrivateInnerClass()) {
            return Optional.empty();
        }
        return Optional.of(apiClassWriter);
    }

    private boolean shouldExtractApiClassFrom(ClassReader originalClassReader) {
        if (!ApiMemberSelector.isCandidateApiMember(originalClassReader.getAccess(), this.apiIncludesPackagePrivateMembers)) {
            return false;
        }
        String originalClassName = originalClassReader.getClassName();
        if (ApiClassExtractor.isLocalClass(originalClassName)) {
            return false;
        }
        return this.packageNameFilter.test(ApiClassExtractor.packageNameOf(originalClassName));
    }

    private static String packageNameOf(String internalClassName) {
        int packageSeparatorIndex = internalClassName.lastIndexOf(47);
        return packageSeparatorIndex > 0 ? internalClassName.substring(0, packageSeparatorIndex).replace('/', '.') : "";
    }

    private static boolean isLocalClass(String className) {
        return LOCAL_CLASS_PATTERN.matcher(className).matches();
    }

    public static class Builder {
        private final ApiMemberWriterFactory apiMemberWriterFactory;
        private boolean includePackagePrivateMembers;
        private Predicate<String> packageNameFilter = name -> true;

        Builder(ApiMemberWriterFactory apiMemberWriterFactory) {
            this.apiMemberWriterFactory = apiMemberWriterFactory;
        }

        public Builder includePackagesMatching(Predicate<String> packageNameFilter) {
            this.packageNameFilter = packageNameFilter;
            return this;
        }

        public Builder includePackagePrivateMembers() {
            this.includePackagePrivateMembers = true;
            return this;
        }

        public ApiClassExtractor build() {
            return new ApiClassExtractor(this.packageNameFilter, this.includePackagePrivateMembers, this.apiMemberWriterFactory);
        }
    }
}

