/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing;

import java.io.IOException;
import java.nio.file.Path;
import javax.inject.Inject;
import org.gradle.api.file.Directory;
import org.gradle.api.internal.tasks.testing.DefaultRootTestEventReporter;
import org.gradle.api.internal.tasks.testing.LifecycleTrackingGroupTestEventReporter;
import org.gradle.api.internal.tasks.testing.logging.SimpleTestEventLogger;
import org.gradle.api.internal.tasks.testing.logging.TestEventProgressListener;
import org.gradle.api.internal.tasks.testing.results.HtmlTestReportGenerator;
import org.gradle.api.internal.tasks.testing.results.TestExecutionResultsListener;
import org.gradle.api.internal.tasks.testing.results.TestListenerInternal;
import org.gradle.api.internal.tasks.testing.results.serializable.SerializableTestResultStore;
import org.gradle.api.tasks.testing.GroupTestEventReporter;
import org.gradle.api.tasks.testing.TestEventReporterFactory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.event.AnonymousListenerBroadcast;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.id.LongIdGenerator;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class DefaultTestEventReporterFactory
implements TestEventReporterFactory {
    private final ListenerManager listenerManager;
    private final StyledTextOutputFactory textOutputFactory;
    private final ProgressLoggerFactory progressLoggerFactory;
    private final HtmlTestReportGenerator htmlTestReportGenerator;

    @Inject
    public DefaultTestEventReporterFactory(ListenerManager listenerManager, StyledTextOutputFactory textOutputFactory, ProgressLoggerFactory progressLoggerFactory, HtmlTestReportGenerator htmlTestReportGenerator) {
        this.listenerManager = listenerManager;
        this.textOutputFactory = textOutputFactory;
        this.progressLoggerFactory = progressLoggerFactory;
        this.htmlTestReportGenerator = htmlTestReportGenerator;
    }

    @Override
    public GroupTestEventReporter createTestEventReporter(String rootName, Directory binaryResultsDirectory, Directory htmlReportDirectory) {
        AnonymousListenerBroadcast testListenerInternalBroadcaster = this.listenerManager.createAnonymousBroadcaster(TestListenerInternal.class);
        testListenerInternalBroadcaster.add((Object)new SimpleTestEventLogger(this.textOutputFactory));
        testListenerInternalBroadcaster.add((Object)new TestEventProgressListener(this.progressLoggerFactory));
        Path binaryResultsDir = binaryResultsDirectory.getAsFile().toPath();
        SerializableTestResultStore.Writer resultsSerializingListener = this.newResultsSerializingListener(binaryResultsDir);
        testListenerInternalBroadcaster.add((Object)resultsSerializingListener);
        return new LifecycleTrackingGroupTestEventReporter(new DefaultRootTestEventReporter(rootName, (TestListenerInternal)testListenerInternalBroadcaster.getSource(), (IdGenerator<?>)new LongIdGenerator(), htmlReportDirectory.getAsFile().toPath(), binaryResultsDir, resultsSerializingListener, this.htmlTestReportGenerator, (TestExecutionResultsListener)this.listenerManager.getBroadcaster(TestExecutionResultsListener.class)));
    }

    private SerializableTestResultStore.Writer newResultsSerializingListener(Path binaryResultsDir) {
        try {
            return new SerializableTestResultStore(binaryResultsDir).openWriter();
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }
}

