/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot;

import java.util.List;

public abstract class SearchUtil {
    public static <T> int binarySearch(List<T> sortedElements, Comparable<T> key) {
        int size = sortedElements.size();
        switch (size) {
            case 0: {
                return -1;
            }
            case 1: {
                T onlyElement = sortedElements.get(0);
                int comparedToSearch = key.compareTo(onlyElement);
                return comparedToSearch == 0 ? 0 : (comparedToSearch < 0 ? -1 : -2);
            }
        }
        int low = 0;
        int high = size - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            T midVal = sortedElements.get(mid);
            int cmp = key.compareTo(midVal);
            if (cmp > 0) {
                low = mid + 1;
                continue;
            }
            if (cmp < 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }
}

