/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classloader;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.jar.JarFile;
import org.gradle.api.JavaVersion;

abstract class JarCompat
implements Closeable {
    public static final boolean JAVA_9_COMPATIBLE = JavaVersion.current().isJava9Compatible();
    protected final JarFile jarFile;

    private JarCompat(JarFile jarFile) {
        this.jarFile = jarFile;
    }

    public final JarFile getJarFile() {
        return this.jarFile;
    }

    public abstract boolean isMultiRelease();

    public abstract int javaRuntimeVersionUsed();

    @Override
    public final void close() throws IOException {
        this.jarFile.close();
    }

    public static JarCompat open(File jarFile) throws IOException {
        if (JAVA_9_COMPATIBLE) {
            return new MultiReleaseSupportingJar(jarFile);
        }
        return new LegacyJar(jarFile);
    }

    private static class MultiReleaseSupportingJar
    extends JarCompat {
        MultiReleaseSupportingJar(File jarFile) throws IOException {
            super(new JarFile(jarFile, true, 1, JarFile.runtimeVersion()));
        }

        @Override
        public boolean isMultiRelease() {
            return this.jarFile.isMultiRelease();
        }

        @Override
        public int javaRuntimeVersionUsed() {
            return JarFile.runtimeVersion().major();
        }
    }

    private static class LegacyJar
    extends JarCompat {
        public LegacyJar(File jarFile) throws IOException {
            super(new JarFile(jarFile));
        }

        @Override
        public boolean isMultiRelease() {
            return false;
        }

        @Override
        public int javaRuntimeVersionUsed() {
            throw new UnsupportedOperationException("Cannot get runtime version used when running on Java <9");
        }
    }
}

