/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.internal.catalog.DefaultVersionCatalogBuilder;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class VersionCatalogDependencyRegistry {
    private static final Pattern RESERVED_LIBRARY_PREFIX = Pattern.compile("^(" + String.join((CharSequence)"|", DefaultVersionCatalogBuilder.FORBIDDEN_LIBRARY_ALIAS_PREFIX) + ")[- ]");
    private static final Pattern RESERVED_ALIAS_COMPONENT = Pattern.compile("(^|-)(" + String.join((CharSequence)"|", (Iterable<? extends CharSequence>)Sets.union((Set)DefaultVersionCatalogBuilder.RESERVED_ALIAS_NAMES, (Set)DefaultVersionCatalogBuilder.RESERVED_JAVA_NAMES)) + ")($|[- ])");
    private final Map<String, VersionEntry> versions = new TreeMap<String, VersionEntry>();
    private final Map<String, LibraryEntry> libraries = new TreeMap<String, LibraryEntry>();
    private final Map<String, PluginEntry> plugins = new TreeMap<String, PluginEntry>();
    private final boolean fullyQualifiedAliases;

    public VersionCatalogDependencyRegistry(boolean fullyQualifiedAliases) {
        this.fullyQualifiedAliases = fullyQualifiedAliases;
    }

    public Collection<VersionEntry> getVersions() {
        return this.versions.values();
    }

    public Collection<LibraryEntry> getLibraries() {
        return this.libraries.values();
    }

    public Collection<PluginEntry> getPlugins() {
        return this.plugins.values();
    }

    public String registerLibrary(String module, String version) {
        String alias = this.fullyQualifiedAliases ? VersionCatalogDependencyRegistry.coordinatesToAlias(module) : VersionCatalogDependencyRegistry.moduleToAlias(module);
        VersionEntry versionEntry = this.findOrCreateVersionEntry(alias, module, version);
        LibraryEntry libraryEntry = this.findOrCreateLibraryEntry(alias, module, versionEntry);
        return "libs." + libraryEntry.alias.replaceAll("-", ".");
    }

    public String registerPlugin(String pluginId, String version, @Nullable String pluginAlias) {
        String alias = this.pluginAliasOf(pluginId, pluginAlias);
        PluginEntry pluginEntry = this.findOrCreatePluginEntry(alias, pluginId, version);
        return "libs.plugins." + pluginEntry.alias.replaceAll("-", ".");
    }

    private String pluginAliasOf(String pluginId, @Nullable String pluginAlias) {
        if (this.fullyQualifiedAliases) {
            return VersionCatalogDependencyRegistry.coordinatesToAlias(pluginId);
        }
        return pluginAlias != null ? pluginAlias : VersionCatalogDependencyRegistry.pluginIdToAlias(pluginId);
    }

    private VersionEntry findOrCreateVersionEntry(String alias, String module, String version) {
        for (VersionEntry v : this.versions.values()) {
            if (!v.module.equals(module) || !v.version.equals(version)) continue;
            return v;
        }
        VersionEntry v = new VersionEntry();
        v.alias = VersionCatalogDependencyRegistry.findFreeAlias(this.versions.keySet(), alias);
        v.module = module;
        v.version = version;
        this.versions.put(v.alias, v);
        return v;
    }

    private LibraryEntry findOrCreateLibraryEntry(String alias, String module, VersionEntry versionEntry) {
        for (LibraryEntry l : this.libraries.values()) {
            if (!l.module.equals(module) || !l.version.equals(versionEntry.version)) continue;
            return l;
        }
        LibraryEntry l = new LibraryEntry();
        if (RESERVED_LIBRARY_PREFIX.matcher(alias).find()) {
            alias = "my" + alias;
        }
        l.alias = VersionCatalogDependencyRegistry.findFreeAlias(this.libraries.keySet(), alias);
        l.module = module;
        l.version = versionEntry.version;
        l.versionRef = versionEntry.alias;
        this.libraries.put(l.alias, l);
        return l;
    }

    private PluginEntry findOrCreatePluginEntry(String alias, String pluginId, String version) {
        for (PluginEntry p : this.plugins.values()) {
            if (!p.pluginId.equals(pluginId) || !p.version.equals(version)) continue;
            return p;
        }
        PluginEntry p = new PluginEntry();
        p.alias = VersionCatalogDependencyRegistry.findFreeAlias(this.plugins.keySet(), alias);
        p.pluginId = pluginId;
        p.version = version;
        this.plugins.put(p.alias, p);
        return p;
    }

    private static String pluginIdToAlias(String pluginId) {
        String[] pluginIdComponents = pluginId.split("\\.");
        String pluginIdLastComponent = pluginIdComponents[pluginIdComponents.length - 1];
        return VersionCatalogDependencyRegistry.coordinatesToAlias(pluginIdLastComponent);
    }

    private static String moduleToAlias(String module) {
        return VersionCatalogDependencyRegistry.coordinatesToAlias(module.split(":")[1]);
    }

    private static String coordinatesToAlias(String coordinates) {
        String alias = coordinates.replaceAll("[.:_]", "-").replaceAll("-(\\d)", "-v$1").toLowerCase(Locale.ENGLISH);
        StringBuffer resultingAlias = new StringBuffer();
        Matcher reservedComponentsMatcher = RESERVED_ALIAS_COMPONENT.matcher(alias);
        while (reservedComponentsMatcher.find()) {
            reservedComponentsMatcher.appendReplacement(resultingAlias, "$1my" + reservedComponentsMatcher.group(2) + "$3");
        }
        reservedComponentsMatcher.appendTail(resultingAlias);
        return resultingAlias.toString();
    }

    private static String findFreeAlias(Set<String> reservedKeys, String key) {
        String nextKey = key;
        int collisionCount = 0;
        while (reservedKeys.contains(nextKey)) {
            nextKey = key + "-x" + ++collisionCount;
        }
        return nextKey;
    }

    @NullMarked
    public static class VersionEntry {
        String alias;
        String module;
        String version;
    }

    @NullMarked
    public static class LibraryEntry {
        String alias;
        String module;
        String version;
        String versionRef;
    }

    @NullMarked
    public static class PluginEntry {
        String alias;
        String pluginId;
        String version;
    }
}

