/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.classpath;

import java.net.URL;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import org.gradle.api.internal.classpath.Module;
import org.gradle.api.internal.classpath.ModuleRegistry;
import org.gradle.api.internal.classpath.PluginModuleRegistry;
import org.gradle.api.internal.classpath.UnknownModuleException;
import org.gradle.util.internal.GUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPluginModuleRegistry
implements PluginModuleRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPluginModuleRegistry.class);
    private final ModuleRegistry moduleRegistry;

    public DefaultPluginModuleRegistry(ModuleRegistry moduleRegistry) {
        this.moduleRegistry = moduleRegistry;
    }

    @Override
    public Set<Module> getApiModules() {
        Properties properties = this.loadPluginProperties("/gradle-plugins.properties");
        return this.loadModules(properties);
    }

    @Override
    public Set<Module> getImplementationModules() {
        Properties properties = this.loadPluginProperties("/gradle-implementation-plugins.properties");
        return this.loadModules(properties);
    }

    private Set<Module> loadModules(Properties properties) {
        LinkedHashSet<Module> modules = new LinkedHashSet<Module>();
        for (String pluginModule : properties.getProperty("plugins").split(",")) {
            try {
                modules.add(this.moduleRegistry.getModule(pluginModule));
            }
            catch (UnknownModuleException e) {
                LOGGER.debug("Cannot find module for plugin {}. Ignoring.", (Object)pluginModule);
            }
        }
        return modules;
    }

    private Properties loadPluginProperties(String resource) {
        return GUtil.loadProperties((URL)this.getClass().getResource(resource));
    }
}

