/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain;

import com.google.common.base.MoreObjects;
import org.gradle.api.Describable;
import org.gradle.api.Incubating;
import org.gradle.api.provider.Property;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JvmImplementation;
import org.gradle.jvm.toolchain.JvmVendorSpec;

public interface JavaToolchainSpec
extends Describable {
    public Property<JavaLanguageVersion> getLanguageVersion();

    public Property<JvmVendorSpec> getVendor();

    public Property<JvmImplementation> getImplementation();

    @Incubating
    public Property<Boolean> getNativeImageCapable();

    default public String getDisplayName() {
        MoreObjects.ToStringHelper builder = MoreObjects.toStringHelper((String)"");
        builder.omitNullValues();
        builder.add("languageVersion", this.getLanguageVersion().map(JavaLanguageVersion::toString).getOrElse((Object)"unspecified"));
        builder.add("vendor", this.getVendor().map(Object::toString).getOrNull());
        builder.add("implementation", this.getImplementation().map(JvmImplementation::toString).getOrNull());
        builder.add("nativeImageCapable", this.getNativeImageCapable().getOrElse((Object)false));
        return builder.toString();
    }
}

