/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.jvm;

import org.gradle.api.internal.jvm.JavaVersionParser;

public class UnsupportedJavaRuntimeException
extends RuntimeException {
    public UnsupportedJavaRuntimeException(String message) {
        super(message);
    }

    public static void assertCurrentProcessSupportsDaemonJavaVersion() throws UnsupportedJavaRuntimeException {
        int currentVersion = JavaVersionParser.parseCurrentMajorVersion();
        if (currentVersion < 17) {
            String message = String.format("Gradle requires JVM %d or later to run. You are currently using JVM %d.", 17, currentVersion);
            throw new UnsupportedJavaRuntimeException(message);
        }
    }

    public static void assertIsSupportedDaemonJvmVersion(int majorVersion) {
        if (majorVersion < 17) {
            throw new UnsupportedJavaRuntimeException(String.format("Gradle requires JVM %d or later to run. Your build is currently configured to use JVM %d.", 17, majorVersion));
        }
    }
}

