/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.jvm.inspection;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.jvm.inspection.ConditionalInvalidation;
import org.gradle.internal.jvm.inspection.JvmInstallationMetadata;
import org.gradle.internal.jvm.inspection.JvmMetadataDetector;
import org.gradle.jvm.toolchain.internal.InstallationLocation;

public class CachingJvmMetadataDetector
implements JvmMetadataDetector,
ConditionalInvalidation<JvmInstallationMetadata> {
    private final Map<File, JvmInstallationMetadata> javaMetadata = Collections.synchronizedMap(new HashMap());
    private final JvmMetadataDetector delegate;

    public CachingJvmMetadataDetector(JvmMetadataDetector delegate) {
        this.delegate = delegate;
        this.getMetadata(InstallationLocation.autoDetected(Jvm.current().getJavaHome(), "current Java home"));
    }

    @Override
    public JvmInstallationMetadata getMetadata(InstallationLocation javaInstallationLocation) {
        File javaHome = this.resolveSymlink(javaInstallationLocation.getLocation());
        return this.javaMetadata.computeIfAbsent(javaHome, file -> this.delegate.getMetadata(javaInstallationLocation));
    }

    private File resolveSymlink(File jdkPath) {
        try {
            return jdkPath.getCanonicalFile();
        }
        catch (IOException e) {
            return jdkPath;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateItemsMatching(Predicate<JvmInstallationMetadata> predicate) {
        Map<File, JvmInstallationMetadata> map = this.javaMetadata;
        synchronized (map) {
            this.javaMetadata.entrySet().removeIf(it -> predicate.test((JvmInstallationMetadata)it.getValue()));
        }
    }
}

