/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.visualstudio.tasks.internal;

import groovy.util.Node;
import java.io.File;
import java.util.Collections;
import java.util.Objects;
import org.gradle.api.Transformer;
import org.gradle.internal.xml.XmlTransformer;
import org.gradle.plugins.ide.internal.generator.XmlPersistableConfigurationObject;

public class VisualStudioFiltersFile
extends XmlPersistableConfigurationObject {
    private final Transformer<String, File> fileLocationResolver;

    public VisualStudioFiltersFile(XmlTransformer xmlTransformer, Transformer<String, File> fileLocationResolver) {
        super(xmlTransformer);
        this.fileLocationResolver = fileLocationResolver;
    }

    protected String getDefaultResourceName() {
        return "default.vcxproj.filters";
    }

    public void addSource(File sourceFile) {
        this.getItemGroupForLabel("Sources").appendNode((Object)"ClCompile", Collections.singletonMap("Include", this.toPath(sourceFile))).appendNode((Object)"Filter", (Object)"Source Files");
    }

    public void addHeader(File headerFile) {
        this.getItemGroupForLabel("Headers").appendNode((Object)"ClInclude", Collections.singletonMap("Include", this.toPath(headerFile))).appendNode((Object)"Filter", (Object)"Header Files");
    }

    private Node getItemGroupForLabel(String label) {
        return Objects.requireNonNull(VisualStudioFiltersFile.findFirstChildWithAttributeValue((Node)this.getXml(), (String)"ItemGroup", (String)"Label", (String)label), "No 'ItemGroup' with attribute 'Label = " + label + "' found");
    }

    private String toPath(File file) {
        return (String)this.fileLocationResolver.transform((Object)file);
    }
}

