/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Optional;
import org.gradle.cache.Cache;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.internal.Deferrable;
import org.gradle.internal.Try;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.WorkValidationContext;
import org.gradle.internal.execution.caching.CachingState;
import org.gradle.internal.execution.history.ExecutionOutputState;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.jspecify.annotations.Nullable;

@ServiceScope(value={Scope.Build.class})
public interface ExecutionEngine {
    public Request createRequest(UnitOfWork var1);

    public static enum ExecutionOutcome {
        UP_TO_DATE,
        FROM_CACHE,
        SHORT_CIRCUITED,
        EXECUTED_INCREMENTALLY,
        EXECUTED_NON_INCREMENTALLY;

    }

    public static interface Execution {
        public ExecutionOutcome getOutcome();

        public @Nullable Object getOutput(File var1);

        default public boolean canStoreOutputsInCache() {
            return true;
        }

        public static Execution skipped(final ExecutionOutcome outcome, final UnitOfWork work) {
            return new Execution(){

                @Override
                public ExecutionOutcome getOutcome() {
                    return outcome;
                }

                @Override
                public @Nullable Object getOutput(File workspace) {
                    return work.loadAlreadyProducedOutput(workspace);
                }
            };
        }
    }

    public static interface IdentityCacheResult<T> {
        public Try<T> getResult();

        public Optional<OriginMetadata> getOriginMetadata();
    }

    public static interface Result {
        public Try<Execution> getExecution();

        public CachingState getCachingState();

        public <T> Try<T> getOutputAs(Class<T> var1);

        public ImmutableList<String> getExecutionReasons();

        public Optional<OriginMetadata> getReusedOutputOriginMetadata();

        @VisibleForTesting
        public Optional<ExecutionOutputState> getAfterExecutionOutputState();
    }

    public static interface Request {
        public void forceNonIncremental(String var1);

        public void withValidationContext(WorkValidationContext var1);

        public Result execute();

        public <T> Deferrable<Try<T>> executeDeferred(Cache<UnitOfWork.Identity, IdentityCacheResult<T>> var1);
    }
}

