import { jsxs, Fragment, jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { useTheme2, Button } from '@grafana/ui';
import { DataLinkBuiltInVars, VariableOrigin } from '@grafana/data';
import { DataLink } from './DataLink.js';

const getStyles = (theme) => ({
  infoText: css`
    padding-bottom: ${theme.v1.spacing.md};
    color: ${theme.v1.colors.textWeak};
  `,
  dataLink: css`
    margin-bottom: ${theme.v1.spacing.sm};
  `
});
const DataLinks = (props) => {
  const { value, onChange } = props;
  const theme = useTheme2();
  const styles = getStyles(theme);
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx("h3", { className: "page-heading", children: "Data links" }),
    /* @__PURE__ */ jsx("div", { className: styles.infoText, children: "Add links to existing fields. Links will be shown in log row details next to the field value." }),
    /* @__PURE__ */ jsxs("div", { className: "gf-form-group", children: [
      value && value.map((field, index) => {
        return /* @__PURE__ */ jsx(
          DataLink,
          {
            className: styles.dataLink,
            value: field,
            onChange: (newField) => {
              const newDataLinks = [...value];
              newDataLinks.splice(index, 1, newField);
              onChange(newDataLinks);
            },
            onDelete: () => {
              const newDataLinks = [...value];
              newDataLinks.splice(index, 1);
              onChange(newDataLinks);
            },
            suggestions: [
              {
                value: DataLinkBuiltInVars.valueRaw,
                label: "Raw value",
                documentation: "Raw value of the field",
                origin: VariableOrigin.Value
              }
            ]
          },
          index
        );
      }),
      /* @__PURE__ */ jsx("div", { children: /* @__PURE__ */ jsx(
        Button,
        {
          variant: "secondary",
          className: css`
              margin-right: 10px;
            `,
          icon: "plus",
          onClick: (event) => {
            event.preventDefault();
            const newDataLinks = [...value || [], { field: "", label: "", matcherRegex: "", url: "" }];
            onChange(newDataLinks);
          },
          children: "Add"
        }
      ) })
    ] })
  ] });
};

export { DataLinks };
//# sourceMappingURL=DataLinks.js.map
