/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml;

import java.util.List;
import org.testng.collections.CollectionUtils;
import org.testng.collections.Lists;
import org.testng.reporters.XMLStringBuffer;

public class XmlDefine {
    private String m_name;
    private List<String> m_includes = Lists.newArrayList();

    public void setName(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public String toXml(String indent) {
        XMLStringBuffer xsb = new XMLStringBuffer(indent);
        boolean hasElements = CollectionUtils.hasElements(this.m_includes);
        if (hasElements) {
            xsb.push("define", "name", this.m_name);
        }
        for (String s : this.m_includes) {
            xsb.addEmptyElement("include", "name", s);
        }
        if (hasElements) {
            xsb.pop("define");
        }
        return xsb.toXML();
    }

    public void onElement(String name) {
        this.m_includes.add(name);
    }

    public List<String> getIncludes() {
        return this.m_includes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XmlDefine define = (XmlDefine)o;
        if (this.m_name != null ? !this.m_name.equals(define.m_name) : define.m_name != null) {
            return false;
        }
        return this.m_includes != null ? this.m_includes.equals(define.m_includes) : define.m_includes == null;
    }

    public int hashCode() {
        int result = this.m_name != null ? this.m_name.hashCode() : 0;
        result = 31 * result + (this.m_includes != null ? this.m_includes.hashCode() : 0);
        return result;
    }
}

