/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime;

import groovy.lang.Closure;
import groovy.lang.MetaMethod;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import org.codehaus.groovy.reflection.CachedConstructor;
import org.codehaus.groovy.reflection.ReflectionCache;
import org.codehaus.groovy.runtime.ArrayTypeUtils;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.groovy.runtime.wrappers.Wrapper;

public class MethodClosure
extends Closure {
    public static boolean ALLOW_RESOLVE;
    public static final String ANY_INSTANCE_METHOD_EXISTS = "anyInstanceMethodExists";
    public static final String NEW = "new";
    private static final long serialVersionUID = -2491254866810955844L;
    private boolean anyInstanceMethodExists;
    private final String method;

    public MethodClosure(Object owner, String method) {
        super(owner);
        this.method = method;
        this.maximumNumberOfParameters = 0;
        this.parameterTypes = MetaClassHelper.EMPTY_TYPE_ARRAY;
        Class<?> ownerClass = this.getOwnerClass();
        if (method.equals(NEW)) {
            if (ownerClass.isArray()) {
                Object[] sizeTypes = new Class[ArrayTypeUtils.dimension(ownerClass)];
                Arrays.fill(sizeTypes, Integer.TYPE);
                this.setParameterTypesAndNumber((Class[])sizeTypes);
            } else {
                for (CachedConstructor c : ReflectionCache.getCachedClass(ownerClass).getConstructors()) {
                    this.setParameterTypesAndNumber(c.getNativeParameterTypes());
                }
            }
        } else {
            for (MetaMethod m : InvokerHelper.getMetaClass(ownerClass).respondsTo(this.getOwner(), method)) {
                this.setParameterTypesAndNumber(MethodClosure.makeParameterTypes(this.getOwner(), m));
                if (m.isStatic()) continue;
                this.anyInstanceMethodExists = true;
            }
        }
    }

    private void setParameterTypesAndNumber(Class[] parameterTypes) {
        if (parameterTypes.length > this.maximumNumberOfParameters) {
            this.maximumNumberOfParameters = parameterTypes.length;
            this.parameterTypes = parameterTypes;
        }
    }

    private static Class[] makeParameterTypes(Object owner, MetaMethod m) {
        Class[] newParameterTypes;
        if (owner instanceof Class && !m.isStatic()) {
            Class[] nativeParameterTypes = m.getNativeParameterTypes();
            newParameterTypes = new Class[nativeParameterTypes.length + 1];
            System.arraycopy(nativeParameterTypes, 0, newParameterTypes, 1, nativeParameterTypes.length);
            newParameterTypes[0] = (Class)owner;
        } else {
            newParameterTypes = m.getNativeParameterTypes();
        }
        return newParameterTypes;
    }

    public String getMethod() {
        return this.method;
    }

    @Override
    public Object getOwner() {
        Object owner = super.getOwner();
        if (owner instanceof Wrapper) {
            owner = ((Wrapper)owner).unwrap();
        }
        return owner;
    }

    public Class<?> getOwnerClass() {
        Object owner = super.getOwner();
        if (owner instanceof Wrapper) {
            return ((Wrapper)owner).getType();
        }
        Class theClass = owner.getClass();
        return theClass == Class.class ? (Class)owner : theClass;
    }

    @Override
    public Object getProperty(String property) {
        switch (property) {
            case "method": {
                return this.getMethod();
            }
            case "anyInstanceMethodExists": {
                return this.anyInstanceMethodExists;
            }
        }
        return super.getProperty(property);
    }

    protected Object doCall(Object arguments) {
        return InvokerHelper.invokeMethod(this.getOwner(), this.getMethod(), arguments);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        if (ALLOW_RESOLVE) {
            stream.defaultReadObject();
        }
        throw new UnsupportedOperationException();
    }

    private Object readResolve() {
        if (ALLOW_RESOLVE) {
            return this;
        }
        throw new UnsupportedOperationException();
    }
}

