/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.remote.netty;

import groovyx.gpars.remote.RemoteConnection;
import groovyx.gpars.remote.netty.NettyRemoteConnection;
import groovyx.gpars.remote.netty.NettyTransportProvider;
import groovyx.gpars.remote.netty.RemoteObjectDecoder;
import groovyx.gpars.remote.netty.RemoteObjectEncoder;
import groovyx.gpars.serial.SerialMsg;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;

@ChannelHandler.Sharable
public class NettyHandler
extends SimpleChannelHandler {
    private Channel channel;
    private final RemoteConnection connection;

    public NettyHandler(NettyTransportProvider provider) {
        this.connection = new NettyRemoteConnection(provider, this);
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.channel = e.getChannel();
        this.channel.getPipeline().addFirst("encoder", (ChannelHandler)new RemoteObjectEncoder(this.connection));
        this.channel.getPipeline().addFirst("decoder", (ChannelHandler)new RemoteObjectDecoder(this.connection));
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.connection.onConnect();
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.connection.onDisconnect();
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
        SerialMsg msg = (SerialMsg)e.getMessage();
        msg.execute(this.connection);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
        this.connection.onException(e.getCause());
        e.getCause().printStackTrace();
    }

    public Channel getChannel() {
        return this.channel;
    }
}

