#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hOpenPGP
version:              2.10.1
visibility:           public
id:                   hOpenPGP-2.10.1-2ATr1c6NfXGIJpAzyGI1Uz
key:                  hOpenPGP-2.10.1-2ATr1c6NfXGIJpAzyGI1Uz
license:              MIT
copyright:            2012-2025  Clint Adams
maintainer:           Clint Adams <clint@debian.org>
author:               Clint Adams
homepage:             https://salsa.debian.org/clint/hOpenPGP
synopsis:             native Haskell implementation of OpenPGP (RFC4880)
description:
    native Haskell implementation of OpenPGP (RFC4880), plus Camellia (RFC5581), plus ECC (RFC6637)

category:             Codec, Data
abi:                  e185a8c625895591b207b3a5f6c27524
exposed:              True
exposed-modules:
    Codec.Encryption.OpenPGP.CFB Codec.Encryption.OpenPGP.Compression
    Codec.Encryption.OpenPGP.Expirations
    Codec.Encryption.OpenPGP.Fingerprint
    Codec.Encryption.OpenPGP.KeyInfo
    Codec.Encryption.OpenPGP.KeySelection
    Codec.Encryption.OpenPGP.KeyringParser
    Codec.Encryption.OpenPGP.Ontology Codec.Encryption.OpenPGP.S2K
    Codec.Encryption.OpenPGP.SecretKey
    Codec.Encryption.OpenPGP.Serialize
    Codec.Encryption.OpenPGP.SignatureQualities
    Codec.Encryption.OpenPGP.Signatures Codec.Encryption.OpenPGP.Types
    Codec.Encryption.OpenPGP.Version Data.Conduit.OpenPGP.Compression
    Data.Conduit.OpenPGP.Decrypt Data.Conduit.OpenPGP.Filter
    Data.Conduit.OpenPGP.Keyring Data.Conduit.OpenPGP.Keyring.Instances
    Data.Conduit.OpenPGP.Verify

hidden-modules:
    Codec.Encryption.OpenPGP.Internal
    Codec.Encryption.OpenPGP.Internal.CryptoCipherTypes
    Codec.Encryption.OpenPGP.Internal.Crypton
    Codec.Encryption.OpenPGP.Internal.HOBlockCipher
    Codec.Encryption.OpenPGP.Types.Internal.Base
    Codec.Encryption.OpenPGP.Types.Internal.CryptonNewtypes
    Codec.Encryption.OpenPGP.Types.Internal.PKITypes
    Codec.Encryption.OpenPGP.Types.Internal.PacketClass
    Codec.Encryption.OpenPGP.Types.Internal.Pkt
    Codec.Encryption.OpenPGP.Types.Internal.PrettyUtils
    Codec.Encryption.OpenPGP.Types.Internal.TK
    Codec.Encryption.OpenPGP.BlockCipher
    Codec.Encryption.OpenPGP.SerializeForSigs Paths_hOpenPGP

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hopenpgp
hs-libraries:         HShOpenPGP-2.10.1-2ATr1c6NfXGIJpAzyGI1Uz
depends:
    aeson-2.1.2.1-KHwyqlRT8uq4KliO3neHti
    asn1-encoding-0.9.6-ITmAj0W7qANyri9p6iMMq
    attoparsec-0.14.4-1LkqTl6pHdPB5xyeiPPJjY base-4.17.2.1
    base16-bytestring-1.0.2.0-KKJHyXdd0JLBsnAOn3nNgN
    bifunctors-5.6.2-CnW8QhOdnhQ7eFthNEafYi binary-0.8.9.1
    binary-conduit-1.3.1-1W1Qmn7HCCUBEGD49YlK59 bytestring-0.11.5.3
    bz2-1.0.1.1-6qjOalsG2Rl3UQmtHGJDKN
    conduit-1.3.6.1-AhGLvUg5hIU6LsM4QL1rg6
    conduit-extra-1.3.8-JYWbaceofIoEWZCrj7lr7T containers-0.6.7
    crypto-cipher-types-0.0.9-56ZYVGDFxwtG8TJEc7UjH2
    crypton-1.0.4-f5Bh4dVSze7rFNt2Un5uG
    errors-2.3.0-GmTedIR8o0W4FQaGroiyBK
    hashable-1.4.7.0-DYciMpMadITBAfaAGwGb6s
    incremental-parser-0.5.1-4Y9gLKZLsfT830EtsQFwX0
    ixset-typed-0.5.1.0-4tynsvlHIsX4ZGj4y6rkl1
    lens-5.3.3-9P3St5wWJF5HjKYbI9rQQ
    memory-0.18.0-1oHOZXUPjWrG0kImkORGvt
    monad-loops-0.4.3-KaRiS5mJjkQ1zBkxxbNC2Z
    nettle-0.3.1.1-1YbDn5AJWxHLXr6DClLuRr
    network-uri-2.6.4.2-H8OxlLs11Qp5PfJGWOmWWd
    openpgp-asciiarmor-0.1.2-CYHOkBPGidqLXHV2GBDvay
    prettyprinter-1.7.1-GwS3UeH7b6F3CEpqTxdU0y
    resourcet-1.2.6-FfOnpJHT35xCMtTjhtEACj
    split-0.2.5-7pUrG9PApSj8XvuAHaIoHq text-2.0.2 time-1.12.2
    time-locale-compat-0.1.1.5-1zJhxgkP2bvGiOhYof1wNA
    transformers-0.5.6.2 unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20.1-L9h8TvnOBH1Ihya3LZF9bU
    zlib-0.7.0.0-9LTVaTQCVSRLjipNGe0Z99

haddock-interfaces:   /usr/share/doc/haskell-hopenpgp/html/hOpenPGP.haddock
haddock-html:         /usr/share/doc/haskell-hopenpgp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

