/*
 * Decompiled with CFR 0.152.
 */
package io.github.smiley4.schemakenerator.serialization.analyzer;

import io.github.smiley4.schemakenerator.core.data.AnnotationData;
import io.github.smiley4.schemakenerator.core.data.CollectionData;
import io.github.smiley4.schemakenerator.core.data.EnumData;
import io.github.smiley4.schemakenerator.core.data.MapData;
import io.github.smiley4.schemakenerator.core.data.MemberData;
import io.github.smiley4.schemakenerator.core.data.MemberKind;
import io.github.smiley4.schemakenerator.core.data.TypeData;
import io.github.smiley4.schemakenerator.core.data.TypeDataUtils;
import io.github.smiley4.schemakenerator.core.data.TypeId;
import io.github.smiley4.schemakenerator.core.data.TypeName;
import io.github.smiley4.schemakenerator.core.data.TypeParameterData;
import io.github.smiley4.schemakenerator.core.data.Visibility;
import io.github.smiley4.schemakenerator.core.data.WrappedTypeData;
import io.github.smiley4.schemakenerator.serialization.analyzer.AnnotationAnalyzer;
import io.github.smiley4.schemakenerator.serialization.analyzer.SerialDescriptorUtilsKt;
import io.github.smiley4.schemakenerator.serialization.analyzer.SerializationTypeAnalyzerModule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorKt;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u001b\u001a\u00020\u0014*\u0006\u0012\u0002\b\u00030\u001cH\u0002J\f\u0010\u001b\u001a\u00020\u0014*\u00020\fH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/github/smiley4/schemakenerator/serialization/analyzer/DefaultSerializationTypeAnalyzerModule;", "Lio/github/smiley4/schemakenerator/serialization/analyzer/SerializationTypeAnalyzerModule;", "knownNotParameterized", "", "", "<init>", "(Ljava/util/Set;)V", "annotationAnalyzer", "Lio/github/smiley4/schemakenerator/serialization/analyzer/AnnotationAnalyzer;", "applies", "", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "analyze", "Lio/github/smiley4/schemakenerator/core/data/WrappedTypeData;", "context", "Lio/github/smiley4/schemakenerator/serialization/analyzer/SerializationTypeAnalyzerModule$Context;", "analyzePrimitive", "Lio/github/smiley4/schemakenerator/core/data/TypeData;", "identifyingName", "Lio/github/smiley4/schemakenerator/core/data/TypeName;", "analyzeList", "analyzeMap", "analyzeClass", "analyzeSealed", "analyzeObject", "analyzeEnum", "toTypeName", "Lkotlin/reflect/KClass;", "schema-kenerator-serialization"})
@SourceDebugExtension(value={"SMAP\nDefaultSerializationTypeAnalyzerModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultSerializationTypeAnalyzerModule.kt\nio/github/smiley4/schemakenerator/serialization/analyzer/DefaultSerializationTypeAnalyzerModule\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,458:1\n1#2:459\n1563#3:460\n1634#3,3:461\n*S KotlinDebug\n*F\n+ 1 DefaultSerializationTypeAnalyzerModule.kt\nio/github/smiley4/schemakenerator/serialization/analyzer/DefaultSerializationTypeAnalyzerModule\n*L\n341#1:460\n341#1:461,3\n*E\n"})
public final class DefaultSerializationTypeAnalyzerModule
implements SerializationTypeAnalyzerModule {
    @NotNull
    private final Set<String> knownNotParameterized;
    @NotNull
    private final AnnotationAnalyzer annotationAnalyzer;

    public DefaultSerializationTypeAnalyzerModule(@NotNull Set<String> knownNotParameterized) {
        Intrinsics.checkNotNullParameter(knownNotParameterized, (String)"knownNotParameterized");
        this.knownNotParameterized = knownNotParameterized;
        this.annotationAnalyzer = new AnnotationAnalyzer();
    }

    public /* synthetic */ DefaultSerializationTypeAnalyzerModule(Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            set = SetsKt.emptySet();
        }
        this(set);
    }

    @Override
    public boolean applies(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return true;
    }

    @Override
    @NotNull
    public WrappedTypeData analyze(@NotNull SerializationTypeAnalyzerModule.Context context) {
        TypeData typeData;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = SerialDescriptorUtilsKt.fullName(context.getDescriptor());
        if (Intrinsics.areEqual((Object)string, (Object)Reflection.getOrCreateKotlinClass(Unit.class).getQualifiedName())) {
            typeData = this.analyzePrimitive(context, this.toTypeName(Reflection.getOrCreateKotlinClass(Unit.class)));
        } else if (Intrinsics.areEqual((Object)string, (Object)Reflection.getOrCreateKotlinClass(UByte.class).getQualifiedName())) {
            typeData = this.analyzePrimitive(context, this.toTypeName(Reflection.getOrCreateKotlinClass(UByte.class)));
        } else if (Intrinsics.areEqual((Object)string, (Object)Reflection.getOrCreateKotlinClass(UShort.class).getQualifiedName())) {
            typeData = this.analyzePrimitive(context, this.toTypeName(Reflection.getOrCreateKotlinClass(UShort.class)));
        } else if (Intrinsics.areEqual((Object)string, (Object)Reflection.getOrCreateKotlinClass(UInt.class).getQualifiedName())) {
            typeData = this.analyzePrimitive(context, this.toTypeName(Reflection.getOrCreateKotlinClass(UInt.class)));
        } else if (Intrinsics.areEqual((Object)string, (Object)Reflection.getOrCreateKotlinClass(ULong.class).getQualifiedName())) {
            typeData = this.analyzePrimitive(context, this.toTypeName(Reflection.getOrCreateKotlinClass(ULong.class)));
        } else {
            SerialKind serialKind = context.getDescriptor().getKind();
            if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.LIST.INSTANCE)) {
                typeData = this.analyzeList(context);
            } else if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.MAP.INSTANCE)) {
                typeData = this.analyzeMap(context);
            } else if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.CLASS.INSTANCE)) {
                typeData = this.analyzeClass(context);
            } else if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.OBJECT.INSTANCE)) {
                typeData = this.analyzeObject(context);
            } else if (Intrinsics.areEqual((Object)serialKind, (Object)PolymorphicKind.OPEN.INSTANCE)) {
                typeData = this.analyzeSealed(context);
            } else if (Intrinsics.areEqual((Object)serialKind, (Object)PolymorphicKind.SEALED.INSTANCE)) {
                typeData = this.analyzeSealed(context);
            } else if (Intrinsics.areEqual((Object)serialKind, (Object)PrimitiveKind.BOOLEAN.INSTANCE)) {
                typeData = this.analyzePrimitive(context, this.toTypeName(Reflection.getOrCreateKotlinClass(Boolean.TYPE)));
            } else if (Intrinsics.areEqual((Object)serialKind, (Object)PrimitiveKind.BYTE.INSTANCE)) {
                typeData = this.analyzePrimitive(context, this.toTypeName(Reflection.getOrCreateKotlinClass(Byte.TYPE)));
            } else if (Intrinsics.areEqual((Object)serialKind, (Object)PrimitiveKind.CHAR.INSTANCE)) {
                typeData = this.analyzePrimitive(context, this.toTypeName(Reflection.getOrCreateKotlinClass(Character.TYPE)));
            } else if (Intrinsics.areEqual((Object)serialKind, (Object)PrimitiveKind.DOUBLE.INSTANCE)) {
                typeData = this.analyzePrimitive(context, this.toTypeName(Reflection.getOrCreateKotlinClass(Double.TYPE)));
            } else if (Intrinsics.areEqual((Object)serialKind, (Object)PrimitiveKind.FLOAT.INSTANCE)) {
                typeData = this.analyzePrimitive(context, this.toTypeName(Reflection.getOrCreateKotlinClass(Float.TYPE)));
            } else if (Intrinsics.areEqual((Object)serialKind, (Object)PrimitiveKind.INT.INSTANCE)) {
                typeData = this.analyzePrimitive(context, this.toTypeName(Reflection.getOrCreateKotlinClass(Integer.TYPE)));
            } else if (Intrinsics.areEqual((Object)serialKind, (Object)PrimitiveKind.LONG.INSTANCE)) {
                typeData = this.analyzePrimitive(context, this.toTypeName(Reflection.getOrCreateKotlinClass(Long.TYPE)));
            } else if (Intrinsics.areEqual((Object)serialKind, (Object)PrimitiveKind.SHORT.INSTANCE)) {
                typeData = this.analyzePrimitive(context, this.toTypeName(Reflection.getOrCreateKotlinClass(Short.TYPE)));
            } else if (Intrinsics.areEqual((Object)serialKind, (Object)PrimitiveKind.STRING.INSTANCE)) {
                typeData = this.analyzePrimitive(context, this.toTypeName(Reflection.getOrCreateKotlinClass(String.class)));
            } else if (Intrinsics.areEqual((Object)serialKind, (Object)SerialKind.ENUM.INSTANCE)) {
                typeData = this.analyzeEnum(context);
            } else if (Intrinsics.areEqual((Object)serialKind, (Object)SerialKind.CONTEXTUAL.INSTANCE)) {
                typeData = this.analyzeClass(context);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        TypeData it = typeData;
        boolean bl = false;
        return new WrappedTypeData(it, context.getDescriptor().isNullable());
    }

    private final TypeData analyzePrimitive(SerializationTypeAnalyzerModule.Context context, TypeName identifyingName) {
        Object v0;
        TypeName descriptiveName;
        block2: {
            descriptiveName = this.toTypeName(context.getDescriptor());
            Iterable iterable = context.getKnownTypeData();
            for (Object t : iterable) {
                TypeData known = (TypeData)t;
                boolean bl = false;
                if (!TypeDataUtils.INSTANCE.matches(known, identifyingName, descriptiveName, CollectionsKt.emptyList())) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        TypeData existing = v0;
        if (existing != null) {
            return existing;
        }
        List<AnnotationData> annotations = this.annotationAnalyzer.analyzeAnnotations(context.getDescriptor());
        return new TypeData(context.getId(), identifyingName, descriptiveName, (List)new ArrayList(), annotations, (List)new ArrayList(), (List)new ArrayList(), (List)new ArrayList(), false, null, null, null);
    }

    private final TypeData analyzeList(SerializationTypeAnalyzerModule.Context context) {
        Object v0;
        Object object2;
        TypeParameterData itemParameter;
        TypeName identifyingName;
        TypeName descriptiveName;
        block2: {
            descriptiveName = this.toTypeName(context.getDescriptor());
            identifyingName = this.toTypeName(context.getDescriptor());
            SerialDescriptor itemDescriptor = context.getDescriptor().getElementDescriptor(0);
            String itemName = context.getDescriptor().getElementName(0);
            WrappedTypeData itemType = context.analyze(itemDescriptor);
            itemParameter = new TypeParameterData(itemName, itemType.getTypeData().getId(), itemDescriptor.isNullable() || itemType.getNullable());
            Iterable iterable = context.getKnownTypeData();
            for (Object object2 : iterable) {
                TypeData known = (TypeData)object2;
                boolean bl = false;
                if (!TypeDataUtils.INSTANCE.matches(known, identifyingName, descriptiveName, CollectionsKt.listOf((Object)itemParameter))) continue;
                v0 = object2;
                break block2;
            }
            v0 = null;
        }
        TypeData existing = v0;
        if (existing != null) {
            return existing;
        }
        List<AnnotationData> annotations = this.annotationAnalyzer.analyzeAnnotations(context.getDescriptor());
        boolean uniqueItems = Intrinsics.areEqual((Object)context.getDescriptor().getClass().getName(), (Object)"kotlinx.serialization.internal.LinkedHashSetClassDesc") || Intrinsics.areEqual((Object)context.getDescriptor().getClass().getName(), (Object)"kotlinx.serialization.internal.HashSetClassDesc");
        TypeParameterData[] typeParameterDataArray = new TypeParameterData[]{itemParameter};
        List list = CollectionsKt.mutableListOf((Object[])typeParameterDataArray);
        object2 = itemParameter.getType();
        boolean bl = itemParameter.getNullable();
        MemberKind memberKind = MemberKind.PROPERTY;
        Visibility visibility = Visibility.PUBLIC;
        List list2 = new ArrayList();
        typeParameterDataArray = new MemberData("item", object2, bl, false, visibility, memberKind, list2);
        return new TypeData(context.getId(), identifyingName, descriptiveName, list, annotations, (List)new ArrayList(), (List)new ArrayList(), (List)new ArrayList(), false, null, new CollectionData((MemberData)typeParameterDataArray, uniqueItems), null);
    }

    private final TypeData analyzeMap(SerializationTypeAnalyzerModule.Context context) {
        Object v0;
        TypeParameterData[] typeParameterDataArray;
        TypeParameterData valueParameter;
        TypeParameterData keyParameter;
        TypeName identifyingName;
        TypeName descriptiveName;
        block2: {
            descriptiveName = this.toTypeName(context.getDescriptor());
            identifyingName = this.toTypeName(context.getDescriptor());
            SerialDescriptor keyDescriptor = context.getDescriptor().getElementDescriptor(0);
            String keyName = context.getDescriptor().getElementName(0);
            WrappedTypeData keyType = context.analyze(keyDescriptor);
            keyParameter = new TypeParameterData(keyName, keyType.getTypeData().getId(), keyDescriptor.isNullable() || keyType.getNullable());
            SerialDescriptor valueDescriptor = context.getDescriptor().getElementDescriptor(1);
            String valueName = context.getDescriptor().getElementName(1);
            WrappedTypeData valueType = context.analyze(valueDescriptor);
            valueParameter = new TypeParameterData(valueName, valueType.getTypeData().getId(), valueDescriptor.isNullable() || valueType.getNullable());
            typeParameterDataArray = (TypeParameterData[])context.getKnownTypeData();
            for (Object object2 : typeParameterDataArray) {
                TypeData known = (TypeData)object2;
                boolean bl = false;
                Object[] objectArray = new TypeParameterData[]{keyParameter, valueParameter};
                if (!TypeDataUtils.INSTANCE.matches(known, identifyingName, descriptiveName, CollectionsKt.listOf((Object[])objectArray))) continue;
                v0 = object2;
                break block2;
            }
            v0 = null;
        }
        TypeData existing = v0;
        if (existing != null) {
            return existing;
        }
        List<AnnotationData> annotations = this.annotationAnalyzer.analyzeAnnotations(context.getDescriptor());
        typeParameterDataArray = new TypeParameterData[]{keyParameter, valueParameter};
        List list = CollectionsKt.mutableListOf((Object[])typeParameterDataArray);
        typeParameterDataArray = keyParameter.getType();
        boolean bl = keyParameter.getNullable();
        MemberKind memberKind = MemberKind.PROPERTY;
        Visibility visibility = Visibility.PUBLIC;
        List list2 = new ArrayList();
        MemberData memberData = new MemberData("key", (TypeId)typeParameterDataArray, bl, false, visibility, memberKind, list2);
        typeParameterDataArray = valueParameter.getType();
        bl = valueParameter.getNullable();
        MemberKind memberKind2 = MemberKind.PROPERTY;
        visibility = Visibility.PUBLIC;
        list2 = new ArrayList();
        return new TypeData(context.getId(), identifyingName, descriptiveName, list, annotations, (List)new ArrayList(), (List)new ArrayList(), (List)new ArrayList(), false, null, null, new MapData(memberData, new MemberData("value", (TypeId)typeParameterDataArray, bl, false, visibility, memberKind2, list2)));
    }

    private final TypeData analyzeClass(SerializationTypeAnalyzerModule.Context context) {
        Iterable iterable;
        TypeName descriptiveName = this.toTypeName(context.getDescriptor());
        TypeName identifyingName = this.toTypeName(context.getDescriptor());
        if (this.knownNotParameterized.contains(descriptiveName.getFull())) {
            Object v0;
            block4: {
                iterable = context.getKnownTypeData();
                for (Object t : iterable) {
                    TypeData known = (TypeData)t;
                    boolean bl = false;
                    if (!TypeDataUtils.INSTANCE.matches(known, identifyingName, descriptiveName, CollectionsKt.emptyList())) continue;
                    v0 = t;
                    break block4;
                }
                v0 = null;
            }
            TypeData existing = v0;
            if (existing != null) {
                return existing;
            }
        }
        List<AnnotationData> annotations = this.annotationAnalyzer.analyzeAnnotations(context.getDescriptor());
        Iterable $this$analyzeClass_u24lambda_u245 = iterable = CollectionsKt.createListBuilder();
        boolean bl = false;
        int n = context.getDescriptor().getElementsCount();
        for (int i = 0; i < n; ++i) {
            String fieldName = context.getDescriptor().getElementName(i);
            SerialDescriptor fieldDescriptor = context.getDescriptor().getElementDescriptor(i);
            WrappedTypeData fieldType = context.analyze(fieldDescriptor);
            TypeId typeId = fieldType.getTypeData().getId();
            boolean bl2 = fieldDescriptor.isNullable() || fieldType.getNullable();
            boolean bl3 = context.getDescriptor().isElementOptional(i);
            MemberKind memberKind = MemberKind.PROPERTY;
            Visibility visibility = Visibility.PUBLIC;
            List<AnnotationData> list = this.annotationAnalyzer.analyzeAnnotations(context.getDescriptor().getElementAnnotations(i));
            $this$analyzeClass_u24lambda_u245.add(new MemberData(fieldName, typeId, bl2, bl3, visibility, memberKind, list));
        }
        List members = CollectionsKt.build((List)iterable);
        boolean isInline = context.getDescriptor().isInline();
        return new TypeData(context.getId(), identifyingName, descriptiveName, (List)new ArrayList(), annotations, (List)new ArrayList(), (List)new ArrayList(), CollectionsKt.toMutableList((Collection)members), isInline, null, null, null);
    }

    /*
     * WARNING - void declaration
     */
    private final TypeData analyzeSealed(SerializationTypeAnalyzerModule.Context context) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object t2;
        Iterable iterable;
        TypeName descriptiveName = this.toTypeName(context.getDescriptor());
        TypeName identifyingName = this.toTypeName(context.getDescriptor());
        if (this.knownNotParameterized.contains(descriptiveName.getFull())) {
            Object v0;
            block4: {
                iterable = context.getKnownTypeData();
                for (Object t2 : iterable) {
                    TypeData known = (TypeData)t2;
                    boolean bl = false;
                    if (!TypeDataUtils.INSTANCE.matches(known, identifyingName, descriptiveName, CollectionsKt.emptyList())) continue;
                    v0 = t2;
                    break block4;
                }
                v0 = null;
            }
            TypeData existing = v0;
            if (existing != null) {
                return existing;
            }
        }
        List<AnnotationData> annotations = this.annotationAnalyzer.analyzeAnnotations(context.getDescriptor());
        iterable = SerialDescriptorKt.getElementDescriptors((SerialDescriptor)((SerialDescriptor)CollectionsKt.toList((Iterable)SerialDescriptorKt.getElementDescriptors((SerialDescriptor)context.getDescriptor())).get(1)));
        boolean $i$f$map = false;
        t2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SerialDescriptor serialDescriptor = (SerialDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(context.analyze((SerialDescriptor)it).getTypeData().getId());
        }
        List subtypes = (List)destination$iv$iv;
        return new TypeData(context.getId(), identifyingName, descriptiveName, (List)new ArrayList(), annotations, CollectionsKt.toMutableList((Collection)subtypes), (List)new ArrayList(), (List)new ArrayList(), false, null, null, null);
    }

    private final TypeData analyzeObject(SerializationTypeAnalyzerModule.Context context) {
        Object v0;
        TypeName identifyingName;
        TypeName descriptiveName;
        block2: {
            descriptiveName = this.toTypeName(context.getDescriptor());
            identifyingName = this.toTypeName(context.getDescriptor());
            Iterable iterable = context.getKnownTypeData();
            for (Object t : iterable) {
                TypeData known = (TypeData)t;
                boolean bl = false;
                if (!TypeDataUtils.INSTANCE.matches(known, identifyingName, descriptiveName, CollectionsKt.emptyList())) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        TypeData existing = v0;
        if (existing != null) {
            return existing;
        }
        List<AnnotationData> annotations = this.annotationAnalyzer.analyzeAnnotations(context.getDescriptor());
        return new TypeData(context.getId(), identifyingName, descriptiveName, (List)new ArrayList(), annotations, (List)new ArrayList(), (List)new ArrayList(), (List)new ArrayList(), false, null, null, null);
    }

    private final TypeData analyzeEnum(SerializationTypeAnalyzerModule.Context context) {
        Object v0;
        TypeName identifyingName;
        TypeName descriptiveName;
        block2: {
            descriptiveName = this.toTypeName(context.getDescriptor());
            identifyingName = this.toTypeName(context.getDescriptor());
            Iterable iterable = context.getKnownTypeData();
            for (Object t : iterable) {
                TypeData known = (TypeData)t;
                boolean bl = false;
                if (!TypeDataUtils.INSTANCE.matches(known, identifyingName, descriptiveName, CollectionsKt.emptyList())) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        TypeData existing = v0;
        if (existing != null) {
            return existing;
        }
        List<AnnotationData> annotations = this.annotationAnalyzer.analyzeAnnotations(context.getDescriptor());
        Iterable constants = SerialDescriptorKt.getElementNames((SerialDescriptor)context.getDescriptor());
        return new TypeData(TypeId.Companion.create(), identifyingName, descriptiveName, (List)new ArrayList(), annotations, (List)new ArrayList(), (List)new ArrayList(), (List)new ArrayList(), false, new EnumData(CollectionsKt.toMutableList((Iterable)constants)), null, null);
    }

    private final TypeName toTypeName(KClass<?> $this$toTypeName) {
        String string = $this$toTypeName.getQualifiedName();
        if (string == null) {
            string = JvmClassMappingKt.getJavaClass($this$toTypeName).getName();
        }
        String string2 = string;
        Intrinsics.checkNotNull((Object)string2);
        String string3 = string2;
        String string4 = $this$toTypeName.getSimpleName();
        if (string4 == null) {
            string4 = JvmClassMappingKt.getJavaClass($this$toTypeName).getName();
        }
        string2 = string4;
        Intrinsics.checkNotNull((Object)string2);
        return new TypeName(string3, string2);
    }

    private final TypeName toTypeName(SerialDescriptor $this$toTypeName) {
        String[] stringArray = new String[]{"."};
        return new TypeName(SerialDescriptorUtilsKt.fullName($this$toTypeName), StringsKt.replace$default((String)((String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)$this$toTypeName.getSerialName(), (String[])stringArray, (boolean)false, (int)0, (int)6, null))), (String)"?", (String)"", (boolean)false, (int)4, null));
    }

    public DefaultSerializationTypeAnalyzerModule() {
        this(null, 1, null);
    }
}

