/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.trace.dsl.impl.java;

import com.intellij.debugger.streams.core.trace.dsl.ArrayVariable;
import com.intellij.debugger.streams.core.trace.dsl.CodeBlock;
import com.intellij.debugger.streams.core.trace.dsl.CompositeCodeBlock;
import com.intellij.debugger.streams.core.trace.dsl.Convertable;
import com.intellij.debugger.streams.core.trace.dsl.Expression;
import com.intellij.debugger.streams.core.trace.dsl.ForLoopBody;
import com.intellij.debugger.streams.core.trace.dsl.IfBranch;
import com.intellij.debugger.streams.core.trace.dsl.Lambda;
import com.intellij.debugger.streams.core.trace.dsl.LambdaBody;
import com.intellij.debugger.streams.core.trace.dsl.ListVariable;
import com.intellij.debugger.streams.core.trace.dsl.MapVariable;
import com.intellij.debugger.streams.core.trace.dsl.StatementFactory;
import com.intellij.debugger.streams.core.trace.dsl.TryBlock;
import com.intellij.debugger.streams.core.trace.dsl.Types;
import com.intellij.debugger.streams.core.trace.dsl.Variable;
import com.intellij.debugger.streams.core.trace.dsl.VariableDeclaration;
import com.intellij.debugger.streams.core.trace.dsl.impl.AssignmentStatement;
import com.intellij.debugger.streams.core.trace.dsl.impl.TextExpression;
import com.intellij.debugger.streams.core.trace.dsl.impl.VariableImpl;
import com.intellij.debugger.streams.core.trace.impl.handler.type.GenericType;
import com.intellij.debugger.streams.core.wrapper.IntermediateStreamCall;
import com.intellij.debugger.streams.trace.dsl.impl.java.JavaArrayVariable;
import com.intellij.debugger.streams.trace.dsl.impl.java.JavaAssignmentStatement;
import com.intellij.debugger.streams.trace.dsl.impl.java.JavaCodeBlock;
import com.intellij.debugger.streams.trace.dsl.impl.java.JavaForEachLoop;
import com.intellij.debugger.streams.trace.dsl.impl.java.JavaForLoop;
import com.intellij.debugger.streams.trace.dsl.impl.java.JavaForLoopBody;
import com.intellij.debugger.streams.trace.dsl.impl.java.JavaIfBranch;
import com.intellij.debugger.streams.trace.dsl.impl.java.JavaLambda;
import com.intellij.debugger.streams.trace.dsl.impl.java.JavaLambdaBody;
import com.intellij.debugger.streams.trace.dsl.impl.java.JavaListVariable;
import com.intellij.debugger.streams.trace.dsl.impl.java.JavaMapVariable;
import com.intellij.debugger.streams.trace.dsl.impl.java.JavaTryBlock;
import com.intellij.debugger.streams.trace.dsl.impl.java.JavaTypes;
import com.intellij.debugger.streams.trace.dsl.impl.java.JavaVariableDeclaration;
import com.intellij.debugger.streams.trace.impl.handler.PeekCall;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000fH\u0016J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0015H\u0016J(\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0015H\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010#\u001a\u00020$2\u0006\u0010!\u001a\u00020\"2\u0006\u0010%\u001a\u00020 H\u0016J\u0018\u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\"H\u0016J\u0018\u0010*\u001a\u00020\u00132\u0006\u0010+\u001a\u00020\u00132\u0006\u0010,\u001a\u00020\u0013H\u0016J\u0018\u0010-\u001a\u00020\u00132\u0006\u0010+\u001a\u00020\u00132\u0006\u0010,\u001a\u00020\u0013H\u0016J\u0018\u0010.\u001a\u00020\u00132\u0006\u0010+\u001a\u00020\u00132\u0006\u0010,\u001a\u00020\u0013H\u0016J\u0018\u0010/\u001a\u0002002\u0006\u0010\u001d\u001a\u00020\u00132\u0006\u00101\u001a\u00020\u000bH\u0016J\u0018\u00102\u001a\u0002032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u00104\u001a\u00020\u0013H\u0016J=\u00105\u001a\u0002062\u0006\u00107\u001a\u00020(2\u0006\u00108\u001a\u00020(2\u0006\u0010)\u001a\u00020\"2\u0006\u00109\u001a\u00020\u00112\u000e\u0010:\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130;H\u0016\u00a2\u0006\u0002\u0010<J\u0018\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020(2\u0006\u0010)\u001a\u00020\"H\u0016J\u0010\u0010@\u001a\u00020\u00182\u0006\u0010A\u001a\u00020\u000bH\u0016J\u0010\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020\u000bH\u0016J\b\u0010E\u001a\u00020\rH\u0016J\b\u0010F\u001a\u00020\u0013H\u0016J\b\u0010G\u001a\u00020\u0013H\u0016J\b\u0010H\u001a\u00020\u0013H\u0016J)\u0010I\u001a\u00020\u00132\u0006\u0010?\u001a\u00020(2\u0012\u0010:\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130;\"\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010JJ\u0018\u0010K\u001a\u00020\u00132\u0006\u0010?\u001a\u00020(2\u0006\u0010L\u001a\u00020\u0013H\u0016J)\u0010M\u001a\u00020\u00132\u0006\u0010?\u001a\u00020(2\u0012\u0010:\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130;\"\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010JJ\u0018\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020(2\u0006\u0010Q\u001a\u00020\"H\u0016J\u0018\u0010R\u001a\u00020S2\u0006\u0010?\u001a\u00020(2\u0006\u0010)\u001a\u00020\"H\u0016J\u0010\u0010T\u001a\u00020\u00132\u0006\u00104\u001a\u00020\u0013H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006U"}, d2={"Lcom/intellij/debugger/streams/trace/dsl/impl/java/JavaStatementFactory;", "Lcom/intellij/debugger/streams/core/trace/dsl/StatementFactory;", "<init>", "()V", "types", "Lcom/intellij/debugger/streams/core/trace/dsl/Types;", "getTypes", "()Lcom/intellij/debugger/streams/core/trace/dsl/Types;", "createEmptyCompositeCodeBlock", "Lcom/intellij/debugger/streams/core/trace/dsl/CompositeCodeBlock;", "createEmptyCodeBlock", "Lcom/intellij/debugger/streams/core/trace/dsl/CodeBlock;", "createVariableDeclaration", "Lcom/intellij/debugger/streams/core/trace/dsl/VariableDeclaration;", "variable", "Lcom/intellij/debugger/streams/core/trace/dsl/Variable;", "isMutable", "", "init", "Lcom/intellij/debugger/streams/core/trace/dsl/Expression;", "createEmptyForLoopBody", "Lcom/intellij/debugger/streams/core/trace/dsl/ForLoopBody;", "iterateVariable", "createForEachLoop", "Lcom/intellij/debugger/streams/core/trace/dsl/Convertable;", "collection", "loopBody", "createForLoop", "initialization", "condition", "afterThought", "createEmptyLambdaBody", "Lcom/intellij/debugger/streams/core/trace/dsl/LambdaBody;", "argName", "", "createLambda", "Lcom/intellij/debugger/streams/core/trace/dsl/Lambda;", "lambdaBody", "createVariable", "type", "Lcom/intellij/debugger/streams/core/trace/impl/handler/type/GenericType;", "name", "and", "left", "right", "equals", "same", "createIfBranch", "Lcom/intellij/debugger/streams/core/trace/dsl/IfBranch;", "thenBlock", "createAssignmentStatement", "Lcom/intellij/debugger/streams/core/trace/dsl/impl/AssignmentStatement;", "expression", "createMapVariable", "Lcom/intellij/debugger/streams/core/trace/dsl/MapVariable;", "keyType", "valueType", "linked", "args", "", "(Lcom/intellij/debugger/streams/core/trace/impl/handler/type/GenericType;Lcom/intellij/debugger/streams/core/trace/impl/handler/type/GenericType;Ljava/lang/String;Z[Lcom/intellij/debugger/streams/core/trace/dsl/Expression;)Lcom/intellij/debugger/streams/core/trace/dsl/MapVariable;", "createArrayVariable", "Lcom/intellij/debugger/streams/core/trace/dsl/ArrayVariable;", "elementType", "createScope", "codeBlock", "createTryBlock", "Lcom/intellij/debugger/streams/core/trace/dsl/TryBlock;", "block", "createTimeVariableDeclaration", "currentTimeExpression", "updateCurrentTimeExpression", "currentNanosecondsExpression", "createNewArrayExpression", "(Lcom/intellij/debugger/streams/core/trace/impl/handler/type/GenericType;[Lcom/intellij/debugger/streams/core/trace/dsl/Expression;)Lcom/intellij/debugger/streams/core/trace/dsl/Expression;", "createNewSizedArray", "size", "createNewListExpression", "createPeekCall", "Lcom/intellij/debugger/streams/core/wrapper/IntermediateStreamCall;", "elementsType", "lambda", "createListVariable", "Lcom/intellij/debugger/streams/core/trace/dsl/ListVariable;", "not", "intellij.java.debugger.streams"})
public class JavaStatementFactory
implements StatementFactory {
    @NotNull
    private final Types types = JavaTypes.INSTANCE;

    @NotNull
    public Types getTypes() {
        return this.types;
    }

    @NotNull
    public CompositeCodeBlock createEmptyCompositeCodeBlock() {
        return (CompositeCodeBlock)new JavaCodeBlock(this);
    }

    @NotNull
    public CodeBlock createEmptyCodeBlock() {
        return (CodeBlock)new JavaCodeBlock(this);
    }

    @NotNull
    public VariableDeclaration createVariableDeclaration(@NotNull Variable variable, boolean isMutable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        return new JavaVariableDeclaration(variable, isMutable, null, 4, null);
    }

    @NotNull
    public VariableDeclaration createVariableDeclaration(@NotNull Variable variable, @NotNull Expression init, boolean isMutable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)init, (String)"init");
        return new JavaVariableDeclaration(variable, isMutable, Convertable.toCode$default((Convertable)((Convertable)init), (int)0, (int)1, null));
    }

    @NotNull
    public ForLoopBody createEmptyForLoopBody(@NotNull Variable iterateVariable) {
        Intrinsics.checkNotNullParameter((Object)iterateVariable, (String)"iterateVariable");
        return new JavaForLoopBody(this, iterateVariable);
    }

    @NotNull
    public Convertable createForEachLoop(@NotNull Variable iterateVariable, @NotNull Expression collection, @NotNull ForLoopBody loopBody) {
        Intrinsics.checkNotNullParameter((Object)iterateVariable, (String)"iterateVariable");
        Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
        Intrinsics.checkNotNullParameter((Object)loopBody, (String)"loopBody");
        return new JavaForEachLoop(iterateVariable, collection, loopBody);
    }

    @NotNull
    public Convertable createForLoop(@NotNull VariableDeclaration initialization, @NotNull Expression condition, @NotNull Expression afterThought, @NotNull ForLoopBody loopBody) {
        Intrinsics.checkNotNullParameter((Object)initialization, (String)"initialization");
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Intrinsics.checkNotNullParameter((Object)afterThought, (String)"afterThought");
        Intrinsics.checkNotNullParameter((Object)loopBody, (String)"loopBody");
        return new JavaForLoop(initialization, condition, afterThought, loopBody);
    }

    @NotNull
    public LambdaBody createEmptyLambdaBody(@NotNull String argName) {
        Intrinsics.checkNotNullParameter((Object)argName, (String)"argName");
        return new JavaLambdaBody(this, (Expression)new TextExpression(argName));
    }

    @NotNull
    public Lambda createLambda(@NotNull String argName, @NotNull LambdaBody lambdaBody) {
        Intrinsics.checkNotNullParameter((Object)argName, (String)"argName");
        Intrinsics.checkNotNullParameter((Object)lambdaBody, (String)"lambdaBody");
        boolean bl = lambdaBody instanceof JavaLambdaBody;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        return new JavaLambda(argName, (JavaLambdaBody)lambdaBody);
    }

    @NotNull
    public Variable createVariable(@NotNull GenericType type, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (Variable)new VariableImpl(type, name);
    }

    @NotNull
    public Expression and(@NotNull Expression left, @NotNull Expression right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        return (Expression)new TextExpression(Convertable.toCode$default((Convertable)((Convertable)left), (int)0, (int)1, null) + " && " + Convertable.toCode$default((Convertable)((Convertable)right), (int)0, (int)1, null));
    }

    @NotNull
    public Expression equals(@NotNull Expression left, @NotNull Expression right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        return (Expression)new TextExpression("java.util.Objects.equals(" + Convertable.toCode$default((Convertable)((Convertable)left), (int)0, (int)1, null) + ", " + Convertable.toCode$default((Convertable)((Convertable)right), (int)0, (int)1, null) + ")");
    }

    @NotNull
    public Expression same(@NotNull Expression left, @NotNull Expression right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        return (Expression)new TextExpression(Convertable.toCode$default((Convertable)((Convertable)left), (int)0, (int)1, null) + " == " + Convertable.toCode$default((Convertable)((Convertable)right), (int)0, (int)1, null));
    }

    @NotNull
    public IfBranch createIfBranch(@NotNull Expression condition, @NotNull CodeBlock thenBlock) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Intrinsics.checkNotNullParameter((Object)thenBlock, (String)"thenBlock");
        return (IfBranch)new JavaIfBranch(condition, thenBlock, this);
    }

    @NotNull
    public AssignmentStatement createAssignmentStatement(@NotNull Variable variable, @NotNull Expression expression) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        return new JavaAssignmentStatement(variable, expression);
    }

    @NotNull
    public MapVariable createMapVariable(@NotNull GenericType keyType, @NotNull GenericType valueType, @NotNull String name, boolean linked, @NotNull Expression[] args) {
        Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
        Intrinsics.checkNotNullParameter((Object)valueType, (String)"valueType");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return (MapVariable)new JavaMapVariable(linked ? this.getTypes().linkedMap(keyType, valueType) : this.getTypes().map(keyType, valueType), name);
    }

    @NotNull
    public ArrayVariable createArrayVariable(@NotNull GenericType elementType, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new JavaArrayVariable(this.getTypes().array(elementType), name);
    }

    @NotNull
    public Convertable createScope(@NotNull CodeBlock codeBlock) {
        Intrinsics.checkNotNullParameter((Object)codeBlock, (String)"codeBlock");
        return new Convertable(codeBlock){
            final /* synthetic */ CodeBlock $codeBlock;
            {
                this.$codeBlock = $codeBlock;
            }

            public String toCode(int indent) {
                return this.withIndent("{\n", indent) + this.$codeBlock.toCode(indent + 1) + this.withIndent("}", indent);
            }
        };
    }

    @NotNull
    public TryBlock createTryBlock(@NotNull CodeBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return (TryBlock)new JavaTryBlock(block, this);
    }

    @NotNull
    public VariableDeclaration createTimeVariableDeclaration() {
        return new JavaVariableDeclaration(this.createVariable(this.getTypes().getTIME(), "time"), false, this.getTypes().getTIME().getDefaultValue());
    }

    @NotNull
    public Expression currentTimeExpression() {
        return new TextExpression("time").call("get", new Expression[0]);
    }

    @NotNull
    public Expression updateCurrentTimeExpression() {
        return new TextExpression("time").call("incrementAndGet", new Expression[0]);
    }

    @NotNull
    public Expression currentNanosecondsExpression() {
        return (Expression)new TextExpression("java.lang.System.nanoTime()");
    }

    @NotNull
    public Expression createNewArrayExpression(@NotNull GenericType elementType, Expression ... args) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        String elements = ArraysKt.joinToString$default((Object[])args, (CharSequence)", ", null, null, (int)0, null, JavaStatementFactory::createNewArrayExpression$lambda$0, (int)30, null);
        return (Expression)new TextExpression("new " + elementType.getVariableTypeName() + "[] { " + elements + " }");
    }

    @NotNull
    public Expression createNewSizedArray(@NotNull GenericType elementType, @NotNull Expression size) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        return (Expression)new TextExpression("new " + elementType.getVariableTypeName() + "[" + Convertable.toCode$default((Convertable)((Convertable)size), (int)0, (int)1, null) + "]");
    }

    @NotNull
    public Expression createNewListExpression(@NotNull GenericType elementType, Expression ... args) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (args.length == 0) {
            return (Expression)new TextExpression(this.getTypes().list(elementType).getDefaultValue());
        }
        return (Expression)new TextExpression("java.util.Arrays.asList(" + ArraysKt.joinToString$default((Object[])args, (CharSequence)", ", null, null, (int)0, null, JavaStatementFactory::createNewListExpression$lambda$1, (int)30, null) + ")");
    }

    @NotNull
    public IntermediateStreamCall createPeekCall(@NotNull GenericType elementsType, @NotNull String lambda) {
        Intrinsics.checkNotNullParameter((Object)elementsType, (String)"elementsType");
        Intrinsics.checkNotNullParameter((Object)lambda, (String)"lambda");
        return new PeekCall(lambda, elementsType);
    }

    @NotNull
    public ListVariable createListVariable(@NotNull GenericType elementType, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new JavaListVariable(this.getTypes().list(elementType), name);
    }

    @NotNull
    public Expression not(@NotNull Expression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        return (Expression)new TextExpression("!" + Convertable.toCode$default((Convertable)((Convertable)expression), (int)0, (int)1, null));
    }

    private static final CharSequence createNewArrayExpression$lambda$0(Expression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Convertable.toCode$default((Convertable)((Convertable)it), (int)0, (int)1, null);
    }

    private static final CharSequence createNewListExpression$lambda$1(Expression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Convertable.toCode$default((Convertable)((Convertable)it), (int)0, (int)1, null);
    }
}

