/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.dvcs.commit.DvcsCommitModeProvider;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RemoteDifferenceStrategy;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsOutgoingChangesProvider;
import com.intellij.openapi.vcs.VcsType;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeBuilder;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.AppJavaExecutorUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.VcsSynchronousProgressWrapper;
import com.intellij.vcs.AnnotationProviderEx;
import com.intellij.vcs.commit.CommitMode;
import com.intellij.vcs.git.shared.GitDisplayName;
import com.intellij.vcs.log.VcsUserRegistry;
import git4idea.GitDisposable;
import git4idea.GitRevisionNumber;
import git4idea.GitUserRegistry;
import git4idea.GitUtil;
import git4idea.GitVcsDirtyScope;
import git4idea.annotate.GitAdvancedSettingsListener;
import git4idea.annotate.GitAnnotationProvider;
import git4idea.annotate.GitAnnotationsListener;
import git4idea.branch.GitBranchIncomingOutgoingManager;
import git4idea.changes.GitCommittedChangeListProvider;
import git4idea.changes.GitOutgoingChangesProvider;
import git4idea.checkin.GitCheckinEnvironment;
import git4idea.checkin.GitCommitAndPushExecutor;
import git4idea.commit.GitStagingAreaCommitMode;
import git4idea.config.GitExecutableManager;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.config.GitVersion;
import git4idea.diff.GitDiffProvider;
import git4idea.history.GitHistoryProvider;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitMergeProvider;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.rollback.GitRollbackEnvironment;
import git4idea.roots.GitIntegrationEnabler;
import git4idea.stash.ui.GitStashContentProviderKt;
import git4idea.status.GitChangeProvider;
import git4idea.update.GitUpdateEnvironment;
import git4idea.vfs.GitVFSListener;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class GitVcs
extends AbstractVcs {
    @NonNls
    public static final String NAME = "Git";
    @NonNls
    public static final String ID = "git";
    private static final Logger LOG = Logger.getInstance((String)GitVcs.class.getName());
    private static final VcsKey ourKey = GitVcs.createKey((String)"Git");
    private final AtomicReference<CoroutineScope> myActiveScope;
    private GitVFSListener myVFSListener;
    private final ReadWriteLock myCommandLock;

    @NotNull
    public static GitVcs getInstance(@NotNull Project project) {
        if (project == null) {
            GitVcs.$$$reportNull$$$0(0);
        }
        GitVcs gitVcs = (GitVcs)ProjectLevelVcsManager.getInstance((Project)project).findVcsByName(NAME);
        GitVcs gitVcs2 = Objects.requireNonNull(gitVcs);
        if (gitVcs2 == null) {
            GitVcs.$$$reportNull$$$0(1);
        }
        return gitVcs2;
    }

    public GitVcs(@NotNull Project project) {
        if (project == null) {
            GitVcs.$$$reportNull$$$0(2);
        }
        super(project, NAME);
        this.myActiveScope = new AtomicReference();
        this.myCommandLock = new ReentrantReadWriteLock(true);
    }

    public ReadWriteLock getCommandLock() {
        return this.myCommandLock;
    }

    public static void runInBackground(Task.Backgroundable task) {
        task.queue();
    }

    public CommittedChangesProvider getCommittedChangesProvider() {
        return (CommittedChangesProvider)this.myProject.getService(GitCommittedChangeListProvider.class);
    }

    public String getRevisionPattern() {
        return "[0-9a-fA-F]+";
    }

    @Nullable
    public CheckinEnvironment getCheckinEnvironment() {
        if (this.myProject.isDefault()) {
            return null;
        }
        return (CheckinEnvironment)this.myProject.getService(GitCheckinEnvironment.class);
    }

    @NotNull
    public MergeProvider getMergeProvider() {
        MergeProvider mergeProvider = GitMergeProvider.detect(this.myProject);
        if (mergeProvider == null) {
            GitVcs.$$$reportNull$$$0(3);
        }
        return mergeProvider;
    }

    @NotNull
    public RollbackEnvironment getRollbackEnvironment() {
        RollbackEnvironment rollbackEnvironment = (RollbackEnvironment)this.myProject.getService(GitRollbackEnvironment.class);
        if (rollbackEnvironment == null) {
            GitVcs.$$$reportNull$$$0(4);
        }
        return rollbackEnvironment;
    }

    @NotNull
    public GitHistoryProvider getVcsHistoryProvider() {
        GitHistoryProvider gitHistoryProvider = (GitHistoryProvider)this.myProject.getService(GitHistoryProvider.class);
        if (gitHistoryProvider == null) {
            GitVcs.$$$reportNull$$$0(5);
        }
        return gitHistoryProvider;
    }

    public GitHistoryProvider getVcsBlockHistoryProvider() {
        return (GitHistoryProvider)this.myProject.getService(GitHistoryProvider.class);
    }

    @NotNull
    public String getDisplayName() {
        String string = GitDisplayName.NAME;
        if (string == null) {
            GitVcs.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getShortNameWithMnemonic() {
        String string = GitBundle.message("git4idea.vcs.name.with.mnemonic", new Object[0]);
        if (string == null) {
            GitVcs.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    public UpdateEnvironment getUpdateEnvironment() {
        return (UpdateEnvironment)this.myProject.getService(GitUpdateEnvironment.class);
    }

    @NotNull
    public AnnotationProviderEx getAnnotationProvider() {
        AnnotationProviderEx annotationProviderEx = (AnnotationProviderEx)this.myProject.getService(GitAnnotationProvider.class);
        if (annotationProviderEx == null) {
            GitVcs.$$$reportNull$$$0(8);
        }
        return annotationProviderEx;
    }

    @NotNull
    public DiffProvider getDiffProvider() {
        DiffProvider diffProvider = (DiffProvider)this.myProject.getService(GitDiffProvider.class);
        if (diffProvider == null) {
            GitVcs.$$$reportNull$$$0(9);
        }
        return diffProvider;
    }

    @Nullable
    public VcsRevisionNumber parseRevisionNumber(@Nullable String revision, @Nullable FilePath path) throws VcsException {
        if (revision == null || revision.isEmpty()) {
            return null;
        }
        if (revision.length() > 40) {
            String dateString = revision.substring(0, revision.indexOf("["));
            String rev = revision.substring(revision.indexOf("[") + 1, 40);
            Date d = new Date(Date.parse(dateString));
            return new GitRevisionNumber(rev, d);
        }
        if (path != null) {
            try {
                VirtualFile root = GitUtil.getRootForFile(this.myProject, path);
                return GitRevisionNumber.resolve(this.myProject, root, revision);
            }
            catch (VcsException e) {
                LOG.warn("Unexpected problem with resolving the git revision number: ", (Throwable)e);
            }
        }
        return new GitRevisionNumber(revision);
    }

    @Nullable
    public VcsRevisionNumber parseRevisionNumber(@Nullable String revision) throws VcsException {
        return this.parseRevisionNumber(revision, null);
    }

    public boolean isVersionedDirectory(VirtualFile dir) {
        return dir.isDirectory() && GitUtil.isUnderGit(dir);
    }

    protected void activate() {
        CoroutineScope activeScope = GitDisposable.getInstance(this.myProject).childScope("GitVcs");
        CoroutineScope oldScope = this.myActiveScope.getAndSet(activeScope);
        if (oldScope != null) {
            CoroutineScopeKt.cancel((CoroutineScope)oldScope, null);
        }
        AppJavaExecutorUtil.executeOnPooledIoThread((CoroutineScope)activeScope, () -> GitExecutableManager.getInstance().testGitExecutableVersionValid(this.myProject));
        this.myVFSListener = GitVFSListener.createInstance(this, activeScope);
        this.myProject.getService(VcsUserRegistry.class);
        GitAnnotationsListener.registerListener(this.myProject, activeScope);
        GitAdvancedSettingsListener.registerListener(this.myProject, activeScope);
        GitUserRegistry.getInstance(this.myProject).activate();
        GitBranchIncomingOutgoingManager.getInstance(this.myProject).activate();
    }

    protected void deactivate() {
        this.myVFSListener = null;
        CoroutineScope oldScope = this.myActiveScope.getAndSet(null);
        if (oldScope != null) {
            CoroutineScopeKt.cancel((CoroutineScope)oldScope, null);
        }
    }

    @Nullable
    public GitChangeProvider getChangeProvider() {
        if (this.myProject.isDefault()) {
            return null;
        }
        return (GitChangeProvider)this.myProject.getService(GitChangeProvider.class);
    }

    public void showErrors(@NotNull List<? extends VcsException> list, @NotNull @Nls String action) {
        if (list == null) {
            GitVcs.$$$reportNull$$$0(10);
        }
        if (action == null) {
            GitVcs.$$$reportNull$$$0(11);
        }
        if (!list.isEmpty()) {
            @Nls StringBuilder buffer = new StringBuilder();
            buffer.append("\n");
            buffer.append(GitBundle.message("error.list.title", action));
            for (VcsException vcsException : list) {
                buffer.append("\n");
                buffer.append(vcsException.getMessage());
            }
            String msg = buffer.toString();
            UIUtil.invokeLaterIfNeeded(() -> Messages.showErrorDialog((Project)this.myProject, (String)msg, (String)GitBundle.message("error.dialog.title", new Object[0])));
        }
    }

    @NotNull
    public GitVersion getVersion() {
        GitVersion gitVersion = GitExecutableManager.getInstance().getVersion(this.myProject);
        if (gitVersion == null) {
            GitVcs.$$$reportNull$$$0(12);
        }
        return gitVersion;
    }

    public boolean allowsNestedRoots() {
        return true;
    }

    public static VcsKey getKey() {
        return ourKey;
    }

    public VcsType getType() {
        return VcsType.distributed;
    }

    protected VcsOutgoingChangesProvider<CommittedChangeList> getOutgoingProviderImpl() {
        return (VcsOutgoingChangesProvider)this.myProject.getService(GitOutgoingChangesProvider.class);
    }

    public RemoteDifferenceStrategy getRemoteDifferenceStrategy() {
        return RemoteDifferenceStrategy.ASK_TREE_PROVIDER;
    }

    public List<CommitExecutor> getCommitExecutors() {
        if (this.myProject.isDefault()) {
            return Collections.emptyList();
        }
        return Collections.singletonList((CommitExecutor)this.myProject.getService(GitCommitAndPushExecutor.class));
    }

    public boolean fileListenerIsSynchronous() {
        return false;
    }

    @RequiresEdt
    public void enableIntegration(final @Nullable VirtualFile targetDirectory) {
        new Task.Backgroundable(this.myProject, GitBundle.message("progress.title.enabling.git", new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                new GitIntegrationEnabler(GitVcs.this, targetDirectory).detectAndEnable();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/GitVcs$1", "run"));
            }
        }.queue();
    }

    @Nullable
    public CommittedChangeList loadRevisions(@NotNull VirtualFile vf, @NotNull VcsRevisionNumber number) {
        GitRepository repository2;
        if (vf == null) {
            GitVcs.$$$reportNull$$$0(13);
        }
        if (number == null) {
            GitVcs.$$$reportNull$$$0(14);
        }
        if ((repository2 = (GitRepository)GitRepositoryManager.getInstance(this.myProject).getRepositoryForFile(vf)) == null) {
            return null;
        }
        return (CommittedChangeList)VcsSynchronousProgressWrapper.compute(() -> GitCommittedChangeListProvider.getCommittedChangeList(this.myProject, repository2.getRoot(), (GitRevisionNumber)number), (Project)this.getProject(), (String)GitBundle.message("revision.load.contents", new Object[0]));
    }

    public boolean arePartialChangelistsSupported() {
        return true;
    }

    @TestOnly
    public GitVFSListener getVFSListener() {
        return this.myVFSListener;
    }

    public boolean needsCaseSensitiveDirtyScope() {
        return true;
    }

    @NotNull
    public VcsDirtyScopeBuilder createDirtyScope() {
        return new GitVcsDirtyScope(this.myProject);
    }

    public boolean isWithCustomMenu() {
        return true;
    }

    @Nullable
    public CommitMode getForcedCommitMode() {
        if (GitVcsApplicationSettings.getInstance().isStagingAreaEnabled()) {
            return GitStagingAreaCommitMode.INSTANCE;
        }
        return DvcsCommitModeProvider.compute();
    }

    public boolean isWithCustomShelves() {
        return GitVcsApplicationSettings.getInstance().isCombinedStashesAndShelvesTabEnabled() && GitStashContentProviderKt.stashToolWindowRegistryOption().asBoolean();
    }

    @Nullable
    public String getCompareWithTheSameVersionActionName() {
        return ActionsBundle.message((String)"action.Diff.ShowDiff.text", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 5, 6, 7, 8, 9, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/GitVcs";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vf";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "number";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/GitVcs";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMergeProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRollbackEnvironment";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcsHistoryProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortNameWithMnemonic";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationProvider";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffProvider";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "showErrors";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "loadRevisions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 5, 6, 7, 8, 9, 12 -> new IllegalStateException(string);
        };
    }
}

