/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.ide.trustedProjects.TrustedProjects;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.PotemkinProgress;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProcessEventListener;
import com.intellij.openapi.vcs.VcsEnvCustomizer;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ThrowableConsumer;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.GitVcs;
import git4idea.commands.GitCommand;
import git4idea.commands.GitImplBase;
import git4idea.config.GitExecutable;
import git4idea.config.GitExecutableContext;
import git4idea.config.GitExecutableManager;
import git4idea.config.GitVersionSpecialty;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GitHandler {
    protected static final Logger LOG = Logger.getInstance(GitHandler.class);
    protected static final Logger OUTPUT_LOG = Logger.getInstance((String)("#output." + GitHandler.class.getName()));
    protected static final Logger TIME_LOG = Logger.getInstance((String)("#time." + GitHandler.class.getName()));
    protected static final Logger CALL_TRACE_LOG = Logger.getInstance((String)("#call_trace." + GitHandler.class.getName()));
    private final Project myProject;
    @NotNull
    protected final GitExecutable myExecutable;
    private final GitCommand myCommand;
    private boolean myPreValidateExecutable;
    private boolean myEnableInteractiveCallbacks;
    protected final GeneralCommandLine myCommandLine;
    private final Map<String, String> myCustomEnv;
    protected Process myProcess;
    private boolean myStdoutSuppressed;
    private boolean myStderrSuppressed;
    @Nullable
    private ThrowableConsumer<? super OutputStream, IOException> myInputProcessor;
    private final EventDispatcher<ProcessEventListener> myListeners;
    protected boolean mySilent;
    private final GitExecutableContext myExecutableContext;
    private long myStartTime;
    private static final long LONG_TIME = 10000L;
    @Deprecated
    private Integer myExitCode;
    @Deprecated
    private static final int LAST_OUTPUT_SIZE = 5;
    @Deprecated
    private final List<VcsException> myErrors;

    protected GitHandler(@Nullable Project project, @NotNull File directory, @NotNull GitCommand command, @NotNull List<String> configParameters) {
        if (directory == null) {
            GitHandler.$$$reportNull$$$0(0);
        }
        if (command == null) {
            GitHandler.$$$reportNull$$$0(1);
        }
        if (configParameters == null) {
            GitHandler.$$$reportNull$$$0(2);
        }
        this(project, directory, GitExecutableManager.getInstance().getExecutable(project, directory.toPath()), command, configParameters);
    }

    protected GitHandler(@Nullable Project project, @NotNull VirtualFile vcsRoot, @NotNull GitCommand command, @NotNull List<String> configParameters) {
        if (vcsRoot == null) {
            GitHandler.$$$reportNull$$$0(3);
        }
        if (command == null) {
            GitHandler.$$$reportNull$$$0(4);
        }
        if (configParameters == null) {
            GitHandler.$$$reportNull$$$0(5);
        }
        this(project, VfsUtilCore.virtualToIoFile((VirtualFile)vcsRoot), command, configParameters);
    }

    protected GitHandler(@Nullable Project project, @NotNull File directory, @NotNull GitExecutable executable, @NotNull GitCommand command, @NotNull List<String> configParameters) {
        if (directory == null) {
            GitHandler.$$$reportNull$$$0(6);
        }
        if (executable == null) {
            GitHandler.$$$reportNull$$$0(7);
        }
        if (command == null) {
            GitHandler.$$$reportNull$$$0(8);
        }
        if (configParameters == null) {
            GitHandler.$$$reportNull$$$0(9);
        }
        this.myPreValidateExecutable = true;
        this.myEnableInteractiveCallbacks = true;
        this.myCustomEnv = new HashMap<String, String>();
        this.myListeners = EventDispatcher.create(ProcessEventListener.class);
        this.myErrors = Collections.synchronizedList(new ArrayList());
        this.myProject = project;
        this.myExecutable = executable;
        this.myCommand = command;
        this.myCommandLine = new GeneralCommandLine().withWorkDirectory(directory).withExePath(executable.getExePath()).withCharset(StandardCharsets.UTF_8);
        for (String parameter : GitHandler.getConfigParameters(project, configParameters)) {
            this.myCommandLine.addParameters(new String[]{"-c", parameter});
        }
        this.myCommandLine.addParameter(command.name());
        this.myStdoutSuppressed = true;
        this.mySilent = this.myCommand.lockingPolicy() != GitCommand.LockingPolicy.WRITE;
        GitVcs gitVcs = this.myProject != null ? GitVcs.getInstance(this.myProject) : null;
        VirtualFile root = VfsUtil.findFileByIoFile((File)directory, (boolean)true);
        VcsEnvCustomizer.ExecutableType executableType = this.myExecutable instanceof GitExecutable.Wsl ? VcsEnvCustomizer.ExecutableType.WSL : VcsEnvCustomizer.ExecutableType.LOCAL;
        this.myExecutableContext = new GitExecutableContext(gitVcs, root, executableType);
    }

    private static @NotNull List<@NonNls String> getConfigParameters(@Nullable Project project, @NotNull List<@NonNls String> requestedConfigParameters) {
        if (requestedConfigParameters == null) {
            GitHandler.$$$reportNull$$$0(10);
        }
        if (project == null || !GitVersionSpecialty.CAN_OVERRIDE_GIT_CONFIG_FOR_COMMAND.existsIn(project)) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                GitHandler.$$$reportNull$$$0(11);
            }
            return list;
        }
        ArrayList<@NonNls String> toPass = new ArrayList<String>();
        toPass.add("core.quotepath=false");
        toPass.add("log.showSignature=false");
        toPass.addAll(requestedConfigParameters);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            toPass.add("protocol.file.allow=always");
        }
        ArrayList<String> arrayList = toPass;
        if (arrayList == null) {
            GitHandler.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @NotNull
    protected ProcessEventListener listeners() {
        ProcessEventListener processEventListener = (ProcessEventListener)this.myListeners.getMulticaster();
        if (processEventListener == null) {
            GitHandler.$$$reportNull$$$0(13);
        }
        return processEventListener;
    }

    @Nullable
    public Project project() {
        return this.myProject;
    }

    @NotNull
    File getWorkingDirectory() {
        File file = this.myCommandLine.getWorkDirectory();
        if (file == null) {
            GitHandler.$$$reportNull$$$0(14);
        }
        return file;
    }

    public VcsEnvCustomizer.VcsExecutableContext getExecutableContext() {
        return this.myExecutableContext;
    }

    @NotNull
    public GitExecutable getExecutable() {
        GitExecutable gitExecutable = this.myExecutable;
        if (gitExecutable == null) {
            GitHandler.$$$reportNull$$$0(15);
        }
        return gitExecutable;
    }

    @NotNull
    GitCommand getCommand() {
        GitCommand gitCommand = this.myCommand;
        if (gitCommand == null) {
            GitHandler.$$$reportNull$$$0(16);
        }
        return gitCommand;
    }

    protected void addListener(@NotNull ProcessEventListener listener2) {
        if (listener2 == null) {
            GitHandler.$$$reportNull$$$0(17);
        }
        this.myListeners.addListener((EventListener)listener2);
    }

    public void withLowPriority() {
        this.myExecutableContext.withLowPriority(true);
    }

    public void withNoTty() {
        this.myExecutableContext.withNoTty(true);
    }

    public void addParameters(String ... parameters) {
        if (parameters == null) {
            GitHandler.$$$reportNull$$$0(18);
        }
        this.addParameters(Arrays.asList(parameters));
    }

    public void addParameters(@NotNull List<@NonNls String> parameters) {
        if (parameters == null) {
            GitHandler.$$$reportNull$$$0(19);
        }
        for (String parameter : parameters) {
            this.myCommandLine.addParameter(this.escapeParameterIfNeeded(parameter));
        }
    }

    @NotNull
    private String escapeParameterIfNeeded(@NotNull @NonNls String parameter) {
        if (parameter == null) {
            GitHandler.$$$reportNull$$$0(20);
        }
        if (this.escapeNeeded(parameter)) {
            String string = parameter.replaceAll("\\^", "^^^^");
            if (string == null) {
                GitHandler.$$$reportNull$$$0(21);
            }
            return string;
        }
        String string = parameter;
        if (string == null) {
            GitHandler.$$$reportNull$$$0(22);
        }
        return string;
    }

    private boolean escapeNeeded(@NotNull @NonNls String parameter) {
        if (parameter == null) {
            GitHandler.$$$reportNull$$$0(23);
        }
        return SystemInfo.isWindows && this.isCmd() && parameter.contains("^");
    }

    private boolean isCmd() {
        return StringUtil.toLowerCase((String)this.myCommandLine.getExePath()).endsWith("cmd");
    }

    public void addRelativePaths(FilePath ... parameters) {
        if (parameters == null) {
            GitHandler.$$$reportNull$$$0(24);
        }
        this.addRelativePaths(Arrays.asList(parameters));
    }

    public void addRelativePaths(@NotNull Collection<? extends FilePath> filePaths) {
        if (filePaths == null) {
            GitHandler.$$$reportNull$$$0(25);
        }
        for (FilePath filePath : filePaths) {
            this.myCommandLine.addParameter(VcsFileUtil.relativePath((File)this.getWorkingDirectory(), (FilePath)filePath));
        }
    }

    public void addRelativeFiles(@NotNull Collection<? extends VirtualFile> files) {
        if (files == null) {
            GitHandler.$$$reportNull$$$0(26);
        }
        for (VirtualFile virtualFile : files) {
            this.myCommandLine.addParameter(VcsFileUtil.relativePath((File)this.getWorkingDirectory(), (VirtualFile)virtualFile));
        }
    }

    public void addAbsoluteFile(@NotNull File file) {
        if (file == null) {
            GitHandler.$$$reportNull$$$0(27);
        }
        this.myCommandLine.addParameter(this.myExecutable.convertFilePath(file.toPath()));
    }

    public void endOptions() {
        this.myCommandLine.addParameter("--");
    }

    private boolean isStarted() {
        return this.myProcess != null;
    }

    public boolean isLargeCommandLine() {
        return this.myCommandLine.getCommandLineString().length() > 7600;
    }

    @NlsSafe
    public String printableCommandLine() {
        if (this.getExecutable().isLocal()) {
            return this.unescapeCommandLine(this.myCommandLine.getCommandLineString("git"));
        }
        return this.unescapeCommandLine(this.myCommandLine.getCommandLineString(null));
    }

    @NotNull
    private String unescapeCommandLine(@NotNull String commandLine) {
        if (commandLine == null) {
            GitHandler.$$$reportNull$$$0(28);
        }
        if (this.escapeNeeded(commandLine)) {
            String string = commandLine.replaceAll("\\^\\^\\^\\^", "^");
            if (string == null) {
                GitHandler.$$$reportNull$$$0(29);
            }
            return string;
        }
        String string = commandLine;
        if (string == null) {
            GitHandler.$$$reportNull$$$0(30);
        }
        return string;
    }

    @NotNull
    public Charset getCharset() {
        Charset charset = this.myCommandLine.getCharset();
        if (charset == null) {
            GitHandler.$$$reportNull$$$0(31);
        }
        return charset;
    }

    public void setCharset(@NotNull Charset charset) {
        if (charset == null) {
            GitHandler.$$$reportNull$$$0(32);
        }
        this.myCommandLine.setCharset(charset);
    }

    public void setSilent(boolean silent) {
        this.mySilent = silent;
        if (silent) {
            this.setStderrSuppressed(true);
            this.setStdoutSuppressed(true);
        }
    }

    boolean isSilent() {
        return this.mySilent;
    }

    boolean isStdoutSuppressed() {
        return this.myStdoutSuppressed;
    }

    public void setStdoutSuppressed(boolean stdoutSuppressed) {
        this.myStdoutSuppressed = stdoutSuppressed;
    }

    boolean isStderrSuppressed() {
        return this.myStderrSuppressed;
    }

    public void setStderrSuppressed(boolean stderrSuppressed) {
        this.myStderrSuppressed = stderrSuppressed;
    }

    public void setInputProcessor(@Nullable ThrowableConsumer<? super OutputStream, IOException> inputProcessor) {
        this.myInputProcessor = inputProcessor;
    }

    public void addCustomEnvironmentVariable(@NotNull @NonNls String name, @Nullable @NonNls String value) {
        if (name == null) {
            GitHandler.$$$reportNull$$$0(33);
        }
        this.myCustomEnv.put(name, value);
    }

    public boolean containsCustomEnvironmentVariable(@NotNull @NonNls String key) {
        if (key == null) {
            GitHandler.$$$reportNull$$$0(34);
        }
        return this.myCustomEnv.containsKey(key);
    }

    public void setPreValidateExecutable(boolean preValidateExecutable) {
        this.myPreValidateExecutable = preValidateExecutable;
    }

    boolean isPreValidateExecutable() {
        return this.myPreValidateExecutable;
    }

    public boolean isEnableInteractiveCallbacks() {
        return this.myEnableInteractiveCallbacks;
    }

    public void setEnableInteractiveCallbacks(boolean enableInteractiveCallbacks) {
        this.myEnableInteractiveCallbacks = enableInteractiveCallbacks;
    }

    void runInCurrentThread() throws IOException {
        block7: {
            try {
                this.start();
                if (!this.isStarted()) break block7;
                try {
                    if (this.myInputProcessor != null) {
                        this.myInputProcessor.consume((Object)this.myProcess.getOutputStream());
                    }
                }
                finally {
                    this.waitForProcess();
                }
            }
            finally {
                this.logTime();
            }
        }
    }

    private void logTime() {
        if (this.myStartTime > 0L) {
            long time = System.currentTimeMillis() - this.myStartTime;
            if (!TIME_LOG.isDebugEnabled() && time > 10000L) {
                LOG.info(this.formatDurationMessage(time));
            } else {
                TIME_LOG.debug(this.formatDurationMessage(time));
            }
        } else {
            LOG.debug(String.format("git %s finished.", this.myCommand));
        }
    }

    @NotNull
    private String formatDurationMessage(long time) {
        String string = String.format("git %s took %s ms. Command parameters: %n%s", this.myCommand, time, this.myCommandLine.getCommandLineString());
        if (string == null) {
            GitHandler.$$$reportNull$$$0(35);
        }
        return string;
    }

    private void start() {
        if (this.myProject != null && !this.myProject.isDefault() && !TrustedProjects.isProjectTrusted((Project)this.myProject)) {
            throw new IllegalStateException("Shouldn't be possible to run a Git command in the safe mode");
        }
        if (this.isStarted()) {
            throw new IllegalStateException("The process has been already started");
        }
        try {
            String logDirectoryPath;
            this.myStartTime = System.currentTimeMillis();
            String string = logDirectoryPath = this.myProject != null ? GitImplBase.stringifyWorkingDir(this.myProject.getBasePath(), this.myCommandLine.getWorkDirectory()) : this.myCommandLine.getWorkDirectory().getPath();
            if (!this.mySilent) {
                LOG.info("[" + logDirectoryPath + "] " + this.printableCommandLine());
            } else {
                LOG.debug("[" + logDirectoryPath + "] " + this.printableCommandLine());
            }
            if (CALL_TRACE_LOG.isDebugEnabled()) {
                CALL_TRACE_LOG.debug(new Throwable("[" + logDirectoryPath + "] " + this.printableCommandLine()));
            }
            this.prepareEnvironment();
            this.myExecutable.patchCommandLine(this, this.myCommandLine, this.myExecutableContext);
            OUTPUT_LOG.debug(String.format("%s %% %s started: %s", this.getCommand(), this.hashCode(), this.myCommandLine));
            this.myProcess = this.startProcess();
            this.startHandlingStreams();
        }
        catch (ProcessCanceledException pce) {
            throw pce;
        }
        catch (Throwable t) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.warn(t);
            }
            ((ProcessEventListener)this.myListeners.getMulticaster()).startFailed(t);
        }
    }

    private void prepareEnvironment() {
        Map executionEnvironment = this.myCommandLine.getEnvironment();
        executionEnvironment.clear();
        if (this.myExecutable.isLocal()) {
            executionEnvironment.putAll(EnvironmentUtil.getEnvironmentMap());
        }
        executionEnvironment.putAll(this.myExecutable.getLocaleEnv());
        executionEnvironment.putAll(this.myCustomEnv);
        executionEnvironment.put("INTELLIJ_GIT_EXECUTABLE", "true");
        if (!GitHandler.shouldSuppressReadLocks() && Registry.is((String)"git.use.env.from.project.context")) {
            VcsEnvCustomizer.EP_NAME.forEachExtensionSafe(customizer -> customizer.customizeCommandAndEnvironment(this.myProject, executionEnvironment, (VcsEnvCustomizer.VcsExecutableContext)this.myExecutableContext));
            executionEnvironment.remove("PS1");
        }
    }

    protected static boolean shouldSuppressReadLocks() {
        if (ProgressManager.getInstance().getProgressIndicator() instanceof PotemkinProgress) {
            return !ApplicationManager.getApplication().isDispatchThread();
        }
        return false;
    }

    protected abstract Process startProcess() throws ExecutionException;

    protected abstract void startHandlingStreams();

    protected abstract void waitForProcess();

    public String toString() {
        return this.myCommandLine.toString();
    }

    @Deprecated(forRemoval=true)
    public int getExitCode() {
        if (this.myExitCode == null) {
            return -1;
        }
        return this.myExitCode;
    }

    @Deprecated
    protected void setExitCode(int exitCode) {
        if (this.myExitCode == null) {
            this.myExitCode = exitCode;
        } else {
            LOG.info("Not setting exit code " + exitCode + ", because it was already set to " + this.myExitCode);
        }
    }

    @Deprecated
    void runInCurrentThread(@Nullable Runnable postStartAction) {
        try {
            this.start();
            if (this.isStarted()) {
                if (postStartAction != null) {
                    postStartAction.run();
                }
                this.waitForProcess();
            }
        }
        finally {
            this.logTime();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 12, 13, 14, 15, 16, 21, 22, 29, 30, 31, 35 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configParameters";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsRoot";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executable";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestedConfigParameters";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 21: 
            case 22: 
            case 29: 
            case 30: 
            case 31: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/commands/GitHandler";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 18: 
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePaths";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/commands/GitHandler";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigParameters";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "listeners";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkingDirectory";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutable";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommand";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeParameterIfNeeded";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeCommandLine";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharset";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "formatDurationMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getConfigParameters";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 21: 
            case 22: 
            case 29: 
            case 30: 
            case 31: 
            case 35: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addParameters";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "escapeParameterIfNeeded";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "escapeNeeded";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addRelativePaths";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addRelativeFiles";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addAbsoluteFile";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "unescapeCommandLine";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "setCharset";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "addCustomEnvironmentVariable";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "containsCustomEnvironmentVariable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 12, 13, 14, 15, 16, 21, 22, 29, 30, 31, 35 -> new IllegalStateException(string);
        };
    }
}

