/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.runtime.repository.serialization.impl;

import com.intellij.platform.runtime.repository.serialization.RawRuntimeModuleDescriptor;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

final class CachedClasspathComputation {
    CachedClasspathComputation() {
    }

    @NotNull
    static Collection<String> computeClasspath(Collection<RawRuntimeModuleDescriptor> descriptors, String moduleName) {
        LinkedHashSet<String> classpath = new LinkedHashSet<String>();
        HashMap<String, RawRuntimeModuleDescriptor> descriptorMap = new HashMap<String, RawRuntimeModuleDescriptor>();
        for (RawRuntimeModuleDescriptor descriptor : descriptors) {
            descriptorMap.put(descriptor.getId(), descriptor);
        }
        CachedClasspathComputation.collectClasspathEntries(moduleName, descriptorMap, new HashSet<String>(), classpath);
        LinkedHashSet<String> linkedHashSet = classpath;
        if (linkedHashSet == null) {
            CachedClasspathComputation.$$$reportNull$$$0(0);
        }
        return linkedHashSet;
    }

    private static void collectClasspathEntries(String moduleName, Map<String, RawRuntimeModuleDescriptor> descriptorMap, Set<String> processedModules, Set<String> classpath) {
        if (!processedModules.add(moduleName)) {
            return;
        }
        RawRuntimeModuleDescriptor descriptor = descriptorMap.get(moduleName);
        if (descriptor == null) {
            return;
        }
        classpath.addAll(descriptor.getResourcePaths());
        for (String dependency : descriptor.getDependencies()) {
            CachedClasspathComputation.collectClasspathEntries(dependency, descriptorMap, processedModules, classpath);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/runtime/repository/serialization/impl/CachedClasspathComputation", "computeClasspath"));
    }
}

