/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.embedder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.server.ParallelRunnerForServer;
import org.jetbrains.idea.maven.server.embedder.ArtifactRequestData;
import org.jetbrains.idea.maven.server.embedder.ArtifactResultData;
import org.jetbrains.idea.maven.server.embedder.Resetable;

public class CustomMaven36ArtifactResolver
implements ArtifactResolver,
Resetable {
    private final ArtifactResolver myWrapee;
    private final Map<ArtifactRequestData, ArtifactResultData> artifactCache = new ConcurrentHashMap<ArtifactRequestData, ArtifactResultData>();

    public CustomMaven36ArtifactResolver(ArtifactResolver wrapee) {
        this.myWrapee = wrapee;
    }

    protected ArtifactResultData doResolveArtifactAndWrapException(RepositorySystemSession session, ArtifactRequest request) {
        try {
            return new ArtifactResultData(this.myWrapee.resolveArtifact(session, request), null);
        }
        catch (ArtifactResolutionException e) {
            return new ArtifactResultData(e.getResult(), e);
        }
    }

    @NotNull
    private static ArtifactResult getResult(ArtifactRequest request, ArtifactResultData resultData) {
        ArtifactResult result = new ArtifactResult(request);
        result.setArtifact(resultData.getArtifact());
        result.setRepository(resultData.getRepository());
        List<Exception> exceptions = resultData.getExceptions();
        if (null != exceptions) {
            for (Exception exception : exceptions) {
                result.addException(exception);
            }
        }
        ArtifactResult artifactResult = result;
        if (artifactResult == null) {
            CustomMaven36ArtifactResolver.$$$reportNull$$$0(0);
        }
        return artifactResult;
    }

    public ArtifactResult resolveArtifact(RepositorySystemSession session, ArtifactRequest request) throws ArtifactResolutionException {
        if (null == request) {
            return null;
        }
        ArtifactRequestData requestData = new ArtifactRequestData(request);
        ArtifactResultData resultData = this.artifactCache.computeIfAbsent(requestData, rd -> this.doResolveArtifactAndWrapException(session, request));
        if (null != resultData.getResolutionException()) {
            throw resultData.getResolutionException();
        }
        return CustomMaven36ArtifactResolver.getResult(request, resultData);
    }

    public List<ArtifactResult> resolveArtifacts(RepositorySystemSession session, Collection<? extends ArtifactRequest> requests) throws ArtifactResolutionException {
        if (null == requests) {
            return null;
        }
        ArrayList<? extends ArtifactRequest> requestList = new ArrayList<ArtifactRequest>(requests);
        List resultDataList = ParallelRunnerForServer.execute((boolean)true, requests, request -> this.doResolveArtifactAndWrapException(session, (ArtifactRequest)request));
        ArrayList<ArtifactResult> results = new ArrayList<ArtifactResult>(requests.size());
        boolean error = false;
        for (int i = 0; i < requests.size(); ++i) {
            ArtifactResultData resultData = (ArtifactResultData)resultDataList.get(i);
            if (null != resultData.getResolutionException()) {
                error = true;
            }
            results.add(CustomMaven36ArtifactResolver.getResult((ArtifactRequest)requestList.get(i), resultData));
        }
        if (error) {
            throw new ArtifactResolutionException(results);
        }
        return results;
    }

    @Override
    public void reset() {
        this.artifactCache.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/embedder/CustomMaven36ArtifactResolver", "getResult"));
    }
}

