/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.collect;

import java.util.NoSuchElementException;
import org.jetbrains.kotlin.com.google.common.annotations.GwtCompatible;
import org.jetbrains.kotlin.com.google.common.collect.UnmodifiableIterator;

@GwtCompatible
public abstract class AbstractSequentialIterator<T>
extends UnmodifiableIterator<T> {
    private T nextOrNull;

    protected AbstractSequentialIterator(T firstOrNull) {
        this.nextOrNull = firstOrNull;
    }

    protected abstract T computeNext(T var1);

    @Override
    public final boolean hasNext() {
        return this.nextOrNull != null;
    }

    @Override
    public final T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            T t = this.nextOrNull;
            return t;
        }
        finally {
            this.nextOrNull = this.computeNext(this.nextOrNull);
        }
    }
}

