/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.ObjectLongAssociativeContainer;
import com.carrotsearch.hppc.ObjectLongHashMap;

public class ObjectLongIdentityHashMap<KType>
extends ObjectLongHashMap<KType> {
    public ObjectLongIdentityHashMap() {
        this(4);
    }

    public ObjectLongIdentityHashMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ObjectLongIdentityHashMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor);
    }

    public ObjectLongIdentityHashMap(ObjectLongAssociativeContainer<? extends KType> container) {
        this(container.size());
        this.putAll(container);
    }

    @Override
    public int hashKey(KType key) {
        assert (key != null);
        return BitMixer.mixPhi(System.identityHashCode(key));
    }

    @Override
    public boolean equals(Object v1, Object v2) {
        return v1 == v2;
    }

    public static <KType> ObjectLongIdentityHashMap<KType> from(KType[] keys, long[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ObjectLongIdentityHashMap<KType> map = new ObjectLongIdentityHashMap<KType>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

