/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.jansi.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.fusesource.jansi.AnsiColors;
import org.fusesource.jansi.io.AnsiProcessor;
import org.fusesource.jansi.io.Colors;

public class ColorsAnsiProcessor
extends AnsiProcessor {
    private final AnsiColors colors;

    public ColorsAnsiProcessor(OutputStream os, AnsiColors colors) {
        super(os);
        this.colors = colors;
    }

    @Override
    protected boolean processEscapeCommand(ArrayList<Object> options, int command) throws IOException {
        if (command == 109 && (this.colors == AnsiColors.Colors256 || this.colors == AnsiColors.Colors16)) {
            boolean has38or48 = false;
            for (Object next : options) {
                if (next != null && next.getClass() != Integer.class) {
                    throw new IllegalArgumentException();
                }
                Integer value2 = (Integer)next;
                has38or48 |= value2 == 38 || value2 == 48;
            }
            if (!has38or48) {
                return false;
            }
            StringBuilder sb = new StringBuilder(32);
            sb.append('\u001b').append('[');
            boolean first = true;
            Iterator<Object> optionsIterator = options.iterator();
            while (optionsIterator.hasNext()) {
                Object next = optionsIterator.next();
                if (next == null) continue;
                int value3 = (Integer)next;
                if (value3 == 38 || value3 == 48) {
                    int arg2or5 = this.getNextOptionInt(optionsIterator);
                    if (arg2or5 == 2) {
                        int col;
                        int r2 = this.getNextOptionInt(optionsIterator);
                        int g2 = this.getNextOptionInt(optionsIterator);
                        int b2 = this.getNextOptionInt(optionsIterator);
                        if (this.colors == AnsiColors.Colors256) {
                            col = Colors.roundRgbColor(r2, g2, b2, 256);
                            if (!first) {
                                sb.append(';');
                            }
                            first = false;
                            sb.append(value3);
                            sb.append(';');
                            sb.append(5);
                            sb.append(';');
                            sb.append(col);
                            continue;
                        }
                        col = Colors.roundRgbColor(r2, g2, b2, 16);
                        if (!first) {
                            sb.append(';');
                        }
                        first = false;
                        sb.append(value3 == 38 ? (col >= 8 ? 90 + col - 8 : 30 + col) : (col >= 8 ? 100 + col - 8 : 40 + col));
                        continue;
                    }
                    if (arg2or5 == 5) {
                        int paletteIndex = this.getNextOptionInt(optionsIterator);
                        if (this.colors == AnsiColors.Colors256) {
                            if (!first) {
                                sb.append(';');
                            }
                            first = false;
                            sb.append(value3);
                            sb.append(';');
                            sb.append(5);
                            sb.append(';');
                            sb.append(paletteIndex);
                            continue;
                        }
                        int col = Colors.roundColor(paletteIndex, 16);
                        if (!first) {
                            sb.append(';');
                        }
                        first = false;
                        sb.append(value3 == 38 ? (col >= 8 ? 90 + col - 8 : 30 + col) : (col >= 8 ? 100 + col - 8 : 40 + col));
                        continue;
                    }
                    throw new IllegalArgumentException();
                }
                if (!first) {
                    sb.append(';');
                }
                first = false;
                sb.append(value3);
            }
            sb.append('m');
            this.os.write(sb.toString().getBytes());
            return true;
        }
        return false;
    }

    @Override
    protected boolean processOperatingSystemCommand(ArrayList<Object> options) {
        return false;
    }

    @Override
    protected boolean processCharsetSelect(ArrayList<Object> options) {
        return false;
    }
}

