/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import java.util.Map;
import java.util.stream.Collectors;
import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.StandardComparisonStrategy;

public class ShouldContainSubsequenceOfCharSequence
extends BasicErrorMessageFactory {
    public static ErrorMessageFactory shouldContainSubsequence(CharSequence actual, CharSequence[] strings, int firstBadOrderIndex) {
        return ShouldContainSubsequenceOfCharSequence.shouldContainSubsequence(actual, strings, firstBadOrderIndex, (ComparisonStrategy)StandardComparisonStrategy.instance());
    }

    public static ErrorMessageFactory shouldContainSubsequence(CharSequence actual, CharSequence[] strings, int badOrderIndex, ComparisonStrategy comparisonStrategy) {
        return new ShouldContainSubsequenceOfCharSequence("%nExpecting actual:%n  %s%nto contain the following CharSequences in this order (possibly with other values between them):%n  %s%nbut %s was found before %s%n%s", actual, strings, strings[badOrderIndex + 1], strings[badOrderIndex], comparisonStrategy);
    }

    public static ErrorMessageFactory shouldContainSubsequence(CharSequence actual, CharSequence[] strings, Map<CharSequence, Integer> notFoundRepeatedSubsequence, ComparisonStrategy comparisonStrategy) {
        String detailedErrorMessage;
        if (notFoundRepeatedSubsequence.size() == 1) {
            Map.Entry<CharSequence, Integer> singleEntry = notFoundRepeatedSubsequence.entrySet().iterator().next();
            detailedErrorMessage = String.format("But the %s occurrence of \"%s\" was not found", ShouldContainSubsequenceOfCharSequence.ordinal(singleEntry.getValue() + 1), singleEntry.getKey());
        } else {
            detailedErrorMessage = notFoundRepeatedSubsequence.entrySet().stream().map(entry -> String.format("- the %s occurrence of \"%s\" was not found", ShouldContainSubsequenceOfCharSequence.ordinal((Integer)entry.getValue() + 1), entry.getKey())).collect(Collectors.joining("%n"));
            detailedErrorMessage = "But:%n" + detailedErrorMessage;
        }
        return new ShouldContainSubsequenceOfCharSequence("%nExpecting actual:%n  %s%nto contain the following CharSequences in this order (possibly with other values between them):%n  %s%n" + detailedErrorMessage + "%n%s", actual, strings, comparisonStrategy);
    }

    private static String ordinal(int i) {
        int mod100 = i % 100;
        int mod10 = i % 10;
        if (mod10 == 1 && mod100 != 11) {
            return i + "st";
        }
        if (mod10 == 2 && mod100 != 12) {
            return i + "nd";
        }
        if (mod10 == 3 && mod100 != 13) {
            return i + "rd";
        }
        return i + "th";
    }

    private ShouldContainSubsequenceOfCharSequence(String format, CharSequence actual, CharSequence[] strings, CharSequence foundButBadOrder, CharSequence foundButBadOrder2, ComparisonStrategy comparisonStrategy) {
        super(format, actual, strings, foundButBadOrder, foundButBadOrder2, comparisonStrategy);
    }

    private ShouldContainSubsequenceOfCharSequence(String format, CharSequence actual, CharSequence[] strings, ComparisonStrategy comparisonStrategy) {
        super(format, actual, strings, comparisonStrategy);
    }
}

