/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.iterators;

import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.structuralsearch.impl.matcher.MatchUtils;
import com.intellij.util.SmartList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class HierarchyNodeIterator
extends NodeIterator {
    private int index;
    private final List<PsiElement> remaining = new SmartList();
    private boolean objectTaken;
    private boolean firstElementTaken;
    private final boolean acceptClasses;
    private final boolean acceptInterfaces;
    private final boolean acceptFirstElement;

    private void build(PsiElement current, @NotNull Set<PsiElement> visited) {
        PsiElement element;
        String text;
        if (visited == null) {
            HierarchyNodeIterator.$$$reportNull$$$0(0);
        }
        if (current == null) {
            return;
        }
        String string = text = current instanceof PsiClass ? ((PsiClass)current).getName() : current.getText();
        if (MatchUtils.compareWithNoDifferenceToPackage((String)text, (String)"Object")) {
            if (this.objectTaken) {
                return;
            }
            this.objectTaken = true;
        }
        PsiElement psiElement = element = current instanceof PsiReference ? ((PsiReference)current).resolve() : current;
        if (element instanceof PsiClass) {
            PsiClass clazz = (PsiClass)element;
            if (visited.contains(element)) {
                return;
            }
            if (this.acceptInterfaces || !clazz.isInterface()) {
                visited.add(element);
            }
            if (this.firstElementTaken || this.acceptFirstElement) {
                this.remaining.add((PsiElement)clazz);
            }
            this.firstElementTaken = true;
            if (clazz instanceof PsiAnonymousClass) {
                this.build((PsiElement)((PsiAnonymousClass)clazz).getBaseClassReference(), visited);
                return;
            }
            if (this.acceptClasses) {
                this.processClasses(clazz.getExtendsList(), visited);
                if (!this.objectTaken) {
                    this.build((PsiElement)PsiClassImplUtil.getSuperClass((PsiClass)clazz), visited);
                }
            }
            if (this.acceptInterfaces) {
                this.processClasses(clazz.getImplementsList(), visited);
                if (!this.acceptClasses) {
                    this.processClasses(clazz.getExtendsList(), visited);
                }
            }
        } else {
            this.remaining.add(current);
        }
    }

    private void processClasses(PsiReferenceList referenceList, @NotNull Set<PsiElement> visited) {
        if (visited == null) {
            HierarchyNodeIterator.$$$reportNull$$$0(1);
        }
        if (referenceList == null) {
            return;
        }
        for (PsiJavaCodeReferenceElement referenceElement : referenceList.getReferenceElements()) {
            this.build((PsiElement)referenceElement, visited);
        }
    }

    public HierarchyNodeIterator(PsiElement reference, boolean acceptClasses, boolean acceptInterfaces) {
        this(reference, acceptClasses, acceptInterfaces, true);
    }

    private HierarchyNodeIterator(PsiElement reference, boolean acceptClasses, boolean acceptInterfaces, boolean acceptFirstElement) {
        this.acceptClasses = acceptClasses;
        this.acceptInterfaces = acceptInterfaces;
        this.acceptFirstElement = acceptFirstElement;
        this.build(reference, new HashSet<PsiElement>());
    }

    public boolean hasNext() {
        return this.index < this.remaining.size();
    }

    public PsiElement current() {
        return this.remaining.get(this.index);
    }

    public void advance() {
        if (this.index != this.remaining.size()) {
            ++this.index;
        }
    }

    public void rewind() {
        if (this.index > 0) {
            --this.index;
        }
    }

    public void reset() {
        this.index = 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "visited";
        objectArray2[1] = "com/intellij/structuralsearch/impl/matcher/iterators/HierarchyNodeIterator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "build";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "processClasses";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

