/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.scopes.CallableCopyTypeCalculator;
import org.jetbrains.kotlin.fir.scopes.FirScopeKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirAbstractImportingScopeKt;
import org.jetbrains.kotlin.fir.scopes.impl.ImportedFromObjectOrStaticData;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFileSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a-\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0002R\u00020\u0002R\u00020\u0004j\u0006\u0010\u0003\u001a\u00020\u0002j\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\b\u001aE\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002R\u00020\u0002R\u00020\u0004j\u0006\u0010\u0003\u001a\u00020\u0002j\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0010\u001a5\u0010\u0011\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002R\u00020\u0002R\u00020\u0004j\u0006\u0010\u0003\u001a\u00020\u0002j\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0013"}, d2={"checkFieldAccess", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;)V", "checkClashWithInvisibleProperty", "fieldSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFieldSymbol;", "containingFileSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFileSymbol;", "dispatchReceiver", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/symbols/impl/FirFieldSymbol;Lorg/jetbrains/kotlin/fir/symbols/impl/FirFileSymbol;Lorg/jetbrains/kotlin/fir/expressions/FirExpression;Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;)V", "checkClashWithCompanionProperty", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/symbols/impl/FirFieldSymbol;Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;)V", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirFieldAccessShadowedByInvisibleKotlinProperty.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirFieldAccessShadowedByInvisibleKotlinProperty.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirFieldAccessShadowedByInvisibleKotlinPropertyKt\n+ 2 declarationUtils.kt\norg/jetbrains/kotlin/fir/declarations/DeclarationUtilsKt\n*L\n1#1,107:1\n250#2:108\n241#2,11:109\n*S KotlinDebug\n*F\n+ 1 FirFieldAccessShadowedByInvisibleKotlinProperty.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirFieldAccessShadowedByInvisibleKotlinPropertyKt\n*L\n51#1:108\n51#1:109,11\n*E\n"})
public final class FirFieldAccessShadowedByInvisibleKotlinPropertyKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void checkFieldAccess(CheckerContext context, DiagnosticReporter reporter, FirQualifiedAccessExpression expression) {
        if (context.getLanguageVersionSettings().supportsFeature(LanguageFeature.ProperFieldAccessGenerationForFieldAccessShadowedByKotlinProperty)) {
            return;
        }
        FirCallableSymbol<?> firCallableSymbol = ReferenceUtilsKt.toResolvedCallableSymbol(expression);
        if (!(firCallableSymbol instanceof FirFieldSymbol)) return;
        FirFieldSymbol firFieldSymbol = (FirFieldSymbol)firCallableSymbol;
        if (firFieldSymbol == null) {
            return;
        }
        FirFieldSymbol fieldSymbol = firFieldSymbol;
        FirBasedSymbol $this$isJavaOrEnhancement$iv = fieldSymbol;
        boolean $i$f$isJavaOrEnhancement = false;
        FirDeclarationOrigin $this$isJavaOrEnhancement$iv$iv = $this$isJavaOrEnhancement$iv.getOrigin();
        boolean $i$f$isJavaOrEnhancement2 = false;
        if (!($this$isJavaOrEnhancement$iv$iv instanceof FirDeclarationOrigin.Java || Intrinsics.areEqual((Object)$this$isJavaOrEnhancement$iv$iv, (Object)FirDeclarationOrigin.Enhancement.INSTANCE))) {
            Object e = $this$isJavaOrEnhancement$iv.getFir();
            if (!(e instanceof FirCallableDeclaration)) return;
            FirCallableDeclaration firCallableDeclaration = (FirCallableDeclaration)e;
            Object object = firCallableDeclaration;
            if (firCallableDeclaration == null) return;
            ImportedFromObjectOrStaticData<FirCallableDeclaration> importedFromObjectOrStaticData = FirAbstractImportingScopeKt.getImportedFromObjectOrStaticData(object);
            object = importedFromObjectOrStaticData;
            if (importedFromObjectOrStaticData == null) return;
            Object d = ((ImportedFromObjectOrStaticData)object).getOriginal();
            object = d;
            if (d == null) return;
            if (!DeclarationUtilsKt.isJavaOrEnhancement((FirDeclaration)object)) return;
            boolean bl = true;
            if (!bl) return;
        }
        boolean bl = true;
        if (!bl) {
            return;
        }
        FirFileSymbol firFileSymbol = context.getContainingFileSymbol();
        if (firFileSymbol == null) {
            return;
        }
        FirFileSymbol containingFile = firFileSymbol;
        FirExpression firExpression = expression.getDispatchReceiver();
        if (firExpression == null) {
            return;
        }
        FirExpression dispatchReceiver = firExpression;
        FirFieldAccessShadowedByInvisibleKotlinPropertyKt.checkClashWithInvisibleProperty(context, reporter, fieldSymbol, containingFile, dispatchReceiver, expression);
        FirFieldAccessShadowedByInvisibleKotlinPropertyKt.checkClashWithCompanionProperty(context, reporter, fieldSymbol, expression);
    }

    private static final void checkClashWithInvisibleProperty(CheckerContext context, DiagnosticReporter reporter, FirFieldSymbol fieldSymbol, FirFileSymbol containingFileSymbol, FirExpression dispatchReceiver, FirQualifiedAccessExpression expression) {
        FirTypeScope firTypeScope = ScopeUtilsKt.scope(FirTypeUtilsKt.getResolvedType(dispatchReceiver), context.getSession(), context.getScopeSession(), CallableCopyTypeCalculator.CalculateDeferredForceLazyResolution.INSTANCE, null);
        if (firTypeScope == null) {
            return;
        }
        FirTypeScope scope = firTypeScope;
        List<FirVariableSymbol<?>> properties = FirScopeKt.getProperties(scope, fieldSymbol.getName());
        for (FirVariableSymbol<?> property : properties) {
            boolean isVisible;
            if (!(property instanceof FirPropertySymbol) || !DeclarationAttributesKt.getHasBackingField((FirPropertySymbol)property) || (isVisible = FirVisibilityCheckerKt.isVisible$default(FirVisibilityCheckerKt.getVisibilityChecker(context.getSession()), property, context.getSession(), containingFileSymbol, context.getContainingDeclarations(), dispatchReceiver, false, 32, null))) continue;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)expression.getSource()), FirJvmErrors.INSTANCE.getJAVA_FIELD_SHADOWED_BY_KOTLIN_PROPERTY(), property, null, (int)16, null);
            break;
        }
    }

    private static final void checkClashWithCompanionProperty(CheckerContext context, DiagnosticReporter reporter, FirFieldSymbol fieldSymbol, FirQualifiedAccessExpression expression) {
        Object object = expression.getDispatchReceiver();
        if (object == null || (object = FirTypeUtilsKt.getResolvedType((FirExpression)object)) == null || (object = ToSymbolUtilsKt.toRegularClassSymbol((ConeKotlinType)object, context.getSession())) == null) {
            return;
        }
        Object dispatchReceiverClass = object;
        FirRegularClassSymbol firRegularClassSymbol = ((FirRegularClassSymbol)dispatchReceiverClass).getResolvedCompanionObjectSymbol();
        if (firRegularClassSymbol == null) {
            return;
        }
        FirRegularClassSymbol companionClass = firRegularClassSymbol;
        FirTypeScope companionScope = FirHelpersKt.unsubstitutedScope(context, companionClass);
        List<FirVariableSymbol<?>> properties = FirScopeKt.getProperties(companionScope, fieldSymbol.getName());
        for (FirVariableSymbol<?> property : properties) {
            if (!(property instanceof FirPropertySymbol) || !DeclarationAttributesKt.getHasBackingField((FirPropertySymbol)property)) continue;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)expression.getSource()), FirJvmErrors.INSTANCE.getJAVA_FIELD_SHADOWED_BY_KOTLIN_PROPERTY(), property, null, (int)16, null);
            break;
        }
    }

    public static final /* synthetic */ void access$checkFieldAccess(CheckerContext context, DiagnosticReporter reporter, FirQualifiedAccessExpression expression) {
        FirFieldAccessShadowedByInvisibleKotlinPropertyKt.checkFieldAccess(context, reporter, expression);
    }
}

