/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.scripting.k2;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ImportModuleAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.newProjectWizard.AbstractProjectWizard;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.project.wizard.AbstractExternalProjectImportProvider;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectImportProvider;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.HyperlinkLabel;
import java.io.File;
import java.util.function.Function;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.script.experimental.api.ErrorHandlingKt;
import kotlin.script.experimental.api.ResultWithDiagnostics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.scripting.k2.GradleScriptNotificationProvider;
import org.jetbrains.kotlin.gradle.scripting.shared.GradleImportHelperKt;
import org.jetbrains.kotlin.gradle.scripting.shared.GradleStandaloneScriptActions;
import org.jetbrains.kotlin.gradle.scripting.shared.GradleStandaloneScriptActionsManager;
import org.jetbrains.kotlin.gradle.scripting.shared.UtilsKt;
import org.jetbrains.kotlin.gradle.scripting.shared.roots.GradleBuildRoot;
import org.jetbrains.kotlin.gradle.scripting.shared.roots.GradleBuildRootsLocator;
import org.jetbrains.kotlin.gradle.scripting.shared.roots.Imported;
import org.jetbrains.kotlin.gradle.scripting.shared.roots.StandaloneScriptsUpdater;
import org.jetbrains.kotlin.idea.base.scripting.KotlinBaseScriptingBundle;
import org.jetbrains.kotlin.idea.core.script.ScriptConfigurationWithSdk;
import org.jetbrains.kotlin.idea.core.script.k2.configurations.ScriptConfigurationsProviderImpl;
import org.jetbrains.kotlin.idea.util.FileUtils;
import org.jetbrains.kotlin.scripting.resolve.ScriptCompilationConfigurationWrapper;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u0016\u0012\u0006\b\u0000\u0012\u00020\u0006\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u001c\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\n\u0010\u0011\u001a\u00060\u0012R\u00020\u0013H\u0002J\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\u0010\u0011\u001a\u00060\u0012R\u00020\u0013H\u0002J\u0016\u0010\u0016\u001a\u00020\u0010*\u00020\u00172\b\b\u0001\u0010\u0018\u001a\u00020\u0019H\u0002\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/gradle/scripting/k2/GradleScriptNotificationProvider;", "Lcom/intellij/ui/EditorNotificationProvider;", "<init>", "()V", "collectNotificationData", "Ljava/util/function/Function;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isImported", "", "virtualFile", "linkProject", "", "scriptUnderRoot", "Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/GradleBuildRootsLocator$ScriptUnderRoot;", "Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/GradleBuildRootsLocator;", "tryFindGradleSettings", "Ljava/io/File;", "contextHelp", "Lcom/intellij/ui/EditorNotificationPanel;", "text", "", "kotlin.gradle.scripting.k2"})
@SourceDebugExtension(value={"SMAP\nGradleScriptNotificationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleScriptNotificationProvider.kt\norg/jetbrains/kotlin/gradle/scripting/k2/GradleScriptNotificationProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,225:1\n1869#2,2:226\n*S KotlinDebug\n*F\n+ 1 GradleScriptNotificationProvider.kt\norg/jetbrains/kotlin/gradle/scripting/k2/GradleScriptNotificationProvider\n*L\n202#1:226,2\n*E\n"})
public final class GradleScriptNotificationProvider
implements EditorNotificationProvider {
    @Nullable
    public Function<? super FileEditor, ? extends JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!UtilsKt.isGradleKotlinScript(file) || !FileUtils.isKotlinFileType(file)) {
            return null;
        }
        GradleStandaloneScriptActionsManager standaloneScriptActions = GradleStandaloneScriptActionsManager.Companion.getInstance(project);
        GradleBuildRootsLocator rootsManager = GradleBuildRootsLocator.Companion.getInstance(project);
        GradleBuildRootsLocator.ScriptUnderRoot scriptUnderRoot = rootsManager.findScriptBuildRoot(file);
        if (scriptUnderRoot == null) {
            return null;
        }
        GradleBuildRootsLocator.ScriptUnderRoot scriptUnderRoot2 = scriptUnderRoot;
        return arg_0 -> GradleScriptNotificationProvider.collectNotificationData$lambda$15(this, file, project, scriptUnderRoot2, standaloneScriptActions, rootsManager, arg_0);
    }

    private final boolean isImported(VirtualFile virtualFile, Project project) {
        ResultWithDiagnostics<ScriptCompilationConfigurationWrapper> resultWithDiagnostics;
        ScriptConfigurationWithSdk scriptConfigurationWithSdk;
        ScriptConfigurationsProviderImpl scriptConfigurationsProviderImpl = ScriptConfigurationsProviderImpl.Companion.getInstanceIfCreated(project);
        return (scriptConfigurationsProviderImpl != null && (scriptConfigurationWithSdk = scriptConfigurationsProviderImpl.getConfigurationWithSdk(virtualFile)) != null && (resultWithDiagnostics = scriptConfigurationWithSdk.getScriptConfiguration()) != null ? ErrorHandlingKt.valueOrNull(resultWithDiagnostics) : null) != null;
    }

    private final void linkProject(Project project, GradleBuildRootsLocator.ScriptUnderRoot scriptUnderRoot) {
        Object v1;
        ExternalSystemManager manager;
        File settingsFile;
        block4: {
            settingsFile = this.tryFindGradleSettings(scriptUnderRoot);
            ExternalSystemManager externalSystemManager = ExternalSystemApiUtil.getManager((ProjectSystemId)GradleConstants.SYSTEM_ID);
            if (externalSystemManager == null) {
                return;
            }
            manager = externalSystemManager;
            Iterable iterable = ProjectImportProvider.PROJECT_IMPORT_PROVIDER.getExtensionList();
            for (Object t : iterable) {
                ProjectImportProvider it = (ProjectImportProvider)t;
                boolean bl = false;
                if (!(it instanceof AbstractExternalProjectImportProvider && Intrinsics.areEqual((Object)GradleConstants.SYSTEM_ID, (Object)((AbstractExternalProjectImportProvider)it).getExternalSystemId()))) continue;
                v1 = t;
                break block4;
            }
            v1 = null;
        }
        ProjectImportProvider projectImportProvider = v1;
        if (projectImportProvider == null) {
            return;
        }
        ProjectImportProvider provider = projectImportProvider;
        ProjectImportProvider[] projectImportProviderArray = new ProjectImportProvider[]{provider};
        ProjectImportProvider[] projectImportProviders = projectImportProviderArray;
        if (settingsFile != null) {
            PropertiesComponent.getInstance().setValue("last.imported.location", settingsFile.getCanonicalPath());
        }
        ImportModuleAction.Companion.doImport(project, () -> GradleScriptNotificationProvider.linkProject$lambda$17(project, manager, projectImportProviders));
    }

    private final File tryFindGradleSettings(GradleBuildRootsLocator.ScriptUnderRoot scriptUnderRoot) {
        try {
            File parent2 = null;
            parent2 = new File(scriptUnderRoot.getFilePath()).getCanonicalFile().getParentFile();
            while (parent2.isDirectory()) {
                Object[] objectArray = new String[]{"settings.gradle", "settings.gradle.kts"};
                Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    File file = parent2;
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"element");
                    File settings2 = FilesKt.resolve((File)file, (String)it);
                    if (!settings2.isFile()) continue;
                    return settings2;
                }
                parent2 = parent2.getParentFile();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private final void contextHelp(EditorNotificationPanel $this$contextHelp, @Nls String text) {
        HyperlinkLabel hyperlinkLabel = $this$contextHelp.createActionLabel("", GradleScriptNotificationProvider::contextHelp$lambda$19);
        Intrinsics.checkNotNullExpressionValue((Object)hyperlinkLabel, (String)"createActionLabel(...)");
        HyperlinkLabel helpIcon = hyperlinkLabel;
        helpIcon.setIcon(AllIcons.General.ContextHelp);
        helpIcon.setUseIconAsLink(true);
        helpIcon.setToolTipText(text);
    }

    private static final Unit collectNotificationData$showActionsToFixNotEvaluated$lambda$1$lambda$0(Project $project, Imported $build, StandaloneScriptsUpdater $this$updateStandaloneScripts) {
        Intrinsics.checkNotNullParameter((Object)$this$updateStandaloneScripts, (String)"$this$updateStandaloneScripts");
        GradleImportHelperKt.runPartialGradleImport($project, $build);
        return Unit.INSTANCE;
    }

    private static final void collectNotificationData$showActionsToFixNotEvaluated$lambda$1(GradleBuildRootsLocator $rootsManager, Project $project, Imported $build) {
        $rootsManager.updateStandaloneScripts((Function1<? super StandaloneScriptsUpdater, Unit>)((Function1)arg_0 -> GradleScriptNotificationProvider.collectNotificationData$showActionsToFixNotEvaluated$lambda$1$lambda$0($project, $build, arg_0)));
    }

    private static final void collectNotificationData$showActionsToFixNotEvaluated$lambda$2(GradleScriptNotificationProvider this$0, Project $project, GradleBuildRootsLocator.ScriptUnderRoot $scriptUnderRoot) {
        this$0.linkProject($project, $scriptUnderRoot);
    }

    private static final void collectNotificationData$showActionsToFixNotEvaluated(EditorNotificationPanel $this$collectNotificationData_u24showActionsToFixNotEvaluated, GradleBuildRootsLocator.ScriptUnderRoot scriptUnderRoot, VirtualFile $file, GradleBuildRootsLocator rootsManager, Project $project, GradleScriptNotificationProvider this$0) {
        GradleBuildRoot gradleBuildRoot = scriptUnderRoot.getNearest();
        Imported imported = gradleBuildRoot instanceof Imported ? (Imported)gradleBuildRoot : null;
        if (imported == null) {
            return;
        }
        Imported build2 = imported;
        long importTs = build2.getData().getImportTs();
        if (!build2.areRelatedFilesChangedBefore($file, importTs)) {
            $this$collectNotificationData_u24showActionsToFixNotEvaluated.createActionLabel(KotlinGradleScriptingBundle.message("action.LoadKtGradleConfiguration.text", new Object[0]), () -> GradleScriptNotificationProvider.collectNotificationData$showActionsToFixNotEvaluated$lambda$1(rootsManager, $project, build2));
        }
        $this$collectNotificationData_u24showActionsToFixNotEvaluated.createActionLabel(KotlinGradleScriptingBundle.message("notification.outsideAnything.linkAction", new Object[0]), () -> GradleScriptNotificationProvider.collectNotificationData$showActionsToFixNotEvaluated$lambda$2(this$0, $project, scriptUnderRoot));
    }

    private static final Unit collectNotificationData$lambda$15$lambda$5$lambda$4$lambda$3(VirtualFile $file, StandaloneScriptsUpdater $this$updateStandaloneScripts) {
        Intrinsics.checkNotNullParameter((Object)$this$updateStandaloneScripts, (String)"$this$updateStandaloneScripts");
        String string = $file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        $this$updateStandaloneScripts.addStandaloneScript(string);
        return Unit.INSTANCE;
    }

    private static final void collectNotificationData$lambda$15$lambda$5$lambda$4(GradleBuildRootsLocator $rootsManager, VirtualFile $file) {
        $rootsManager.updateStandaloneScripts((Function1<? super StandaloneScriptsUpdater, Unit>)((Function1)arg_0 -> GradleScriptNotificationProvider.collectNotificationData$lambda$15$lambda$5$lambda$4$lambda$3($file, arg_0)));
    }

    private static final void collectNotificationData$lambda$15$lambda$7$lambda$6(GradleScriptNotificationProvider this$0, Project $project, GradleBuildRootsLocator.ScriptUnderRoot $scriptUnderRoot) {
        this$0.linkProject($project, $scriptUnderRoot);
    }

    private static final void collectNotificationData$lambda$15$lambda$9$lambda$8(GradleBuildRootsLocator.ScriptUnderRoot $scriptUnderRoot, Project $project) {
        GradleBuildRoot root = $scriptUnderRoot.getNearest();
        if (root != null) {
            GradleImportHelperKt.runPartialGradleImport($project, root);
        }
    }

    private static final void collectNotificationData$lambda$15$lambda$14$lambda$10(GradleStandaloneScriptActions $actions) {
        $actions.reload();
    }

    private static final void collectNotificationData$lambda$15$lambda$14$lambda$11(GradleStandaloneScriptActions $actions) {
        $actions.enableAutoReload();
    }

    private static final Unit collectNotificationData$lambda$15$lambda$14$lambda$13$lambda$12(VirtualFile $file, StandaloneScriptsUpdater $this$updateStandaloneScripts) {
        Intrinsics.checkNotNullParameter((Object)$this$updateStandaloneScripts, (String)"$this$updateStandaloneScripts");
        String string = $file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        $this$updateStandaloneScripts.removeStandaloneScript(string);
        return Unit.INSTANCE;
    }

    private static final void collectNotificationData$lambda$15$lambda$14$lambda$13(GradleBuildRootsLocator $rootsManager, VirtualFile $file) {
        $rootsManager.updateStandaloneScripts((Function1<? super StandaloneScriptsUpdater, Unit>)((Function1)arg_0 -> GradleScriptNotificationProvider.collectNotificationData$lambda$15$lambda$14$lambda$13$lambda$12($file, arg_0)));
    }

    private static final EditorNotificationPanel collectNotificationData$lambda$15(GradleScriptNotificationProvider this$0, VirtualFile $file, Project $project, GradleBuildRootsLocator.ScriptUnderRoot $scriptUnderRoot, GradleStandaloneScriptActionsManager $standaloneScriptActions, GradleBuildRootsLocator $rootsManager, FileEditor fileEditor) {
        Intrinsics.checkNotNullParameter((Object)fileEditor, (String)"fileEditor");
        if (this$0.isImported($file, $project)) {
            return null;
        }
        return switch (WhenMappings.$EnumSwitchMapping$0[$scriptUnderRoot.getNotificationKind().ordinal()]) {
            case 1, 2 -> null;
            case 3 -> {
                EditorNotificationPanel v1;
                GradleStandaloneScriptActions actions = $standaloneScriptActions.get($file);
                if (actions != null) {
                    EditorNotificationPanel.Status var8_12 = EditorNotificationPanel.Status.Info;
                    v1 = new EditorNotificationPanel(actions, this$0, fileEditor, var8_12){
                        private final String contextHelp;
                        {
                            this.contextHelp = KotlinGradleScriptingBundle.message("notification.gradle.legacy.firstLoad.info", new Object[0]);
                            if ($actions.isFirstLoad()) {
                                this.text(KotlinGradleScriptingBundle.message("notification.gradle.legacy.firstLoad", new Object[0]));
                                this.setToolTipText(this.contextHelp);
                            } else {
                                this.text(KotlinGradleScriptingBundle.message("notification.text.script.configuration.has.been.changed", new Object[0]));
                            }
                            this.createActionLabel(KotlinGradleScriptingBundle.message("notification.action.text.load.script.configuration", new Object[0]), () -> collectNotificationData.1.1._init_$lambda$0($actions));
                            this.createActionLabel(KotlinBaseScriptingBundle.message("notification.action.text.enable.auto.reload", new Object[0]), () -> collectNotificationData.1.1._init_$lambda$1($actions));
                            if ($actions.isFirstLoad()) {
                                GradleScriptNotificationProvider.access$contextHelp($receiver, this, this.contextHelp);
                            }
                        }

                        public final String getContextHelp() {
                            return this.contextHelp;
                        }

                        private static final void _init_$lambda$0(GradleStandaloneScriptActions $actions) {
                            $actions.reload();
                        }

                        private static final void _init_$lambda$1(GradleStandaloneScriptActions $actions) {
                            $actions.enableAutoReload();
                        }
                    };
                } else {
                    v1 = null;
                }
                yield v1;
            }
            case 4 -> {
                EditorNotificationPanel var7_8;
                EditorNotificationPanel $this$collectNotificationData_u24lambda_u2415_u24lambda_u245 = var7_8 = new EditorNotificationPanel(fileEditor, EditorNotificationPanel.Status.Warning);
                boolean $i$a$-apply-GradleScriptNotificationProvider$collectNotificationData$1$2 = false;
                $this$collectNotificationData_u24lambda_u2415_u24lambda_u245.text(KotlinGradleScriptingBundle.message("notification.gradle.legacy.outsideProject", new Object[0]));
                $this$collectNotificationData_u24lambda_u2415_u24lambda_u245.createActionLabel(KotlinGradleScriptingBundle.message("notification.notEvaluatedInLastImport.addAsStandaloneAction", new Object[0]), () -> GradleScriptNotificationProvider.collectNotificationData$lambda$15$lambda$5$lambda$4($rootsManager, $file));
                this$0.contextHelp($this$collectNotificationData_u24lambda_u2415_u24lambda_u245, KotlinGradleScriptingBundle.message("notification.gradle.legacy.outsideProject.addToStandaloneHelp", new Object[0]));
                yield var7_8;
            }
            case 5 -> {
                EditorNotificationPanel var7_9;
                EditorNotificationPanel $this$collectNotificationData_u24lambda_u2415_u24lambda_u247 = var7_9 = new EditorNotificationPanel(fileEditor, EditorNotificationPanel.Status.Warning);
                boolean $i$a$-apply-GradleScriptNotificationProvider$collectNotificationData$1$3 = false;
                $this$collectNotificationData_u24lambda_u2415_u24lambda_u247.text(KotlinGradleScriptingBundle.message("notification.outsideAnything.text", new Object[0]));
                $this$collectNotificationData_u24lambda_u2415_u24lambda_u247.createActionLabel(KotlinGradleScriptingBundle.message("notification.outsideAnything.linkAction", new Object[0]), () -> GradleScriptNotificationProvider.collectNotificationData$lambda$15$lambda$7$lambda$6(this$0, $project, $scriptUnderRoot));
                yield var7_9;
            }
            case 6 -> {
                EditorNotificationPanel var7_10;
                EditorNotificationPanel $this$collectNotificationData_u24lambda_u2415_u24lambda_u249 = var7_10 = new EditorNotificationPanel(fileEditor, EditorNotificationPanel.Status.Warning);
                boolean $i$a$-apply-GradleScriptNotificationProvider$collectNotificationData$1$4 = false;
                $this$collectNotificationData_u24lambda_u2415_u24lambda_u249.text(KotlinGradleScriptingBundle.message("notification.wasNotImportedAfterCreation.text", new Object[0]));
                $this$collectNotificationData_u24lambda_u2415_u24lambda_u249.createActionLabel(KotlinGradleScriptingBundle.message("action.LoadKtGradleConfiguration.text", new Object[0]), () -> GradleScriptNotificationProvider.collectNotificationData$lambda$15$lambda$9$lambda$8($scriptUnderRoot, $project));
                this$0.contextHelp($this$collectNotificationData_u24lambda_u2415_u24lambda_u249, KotlinGradleScriptingBundle.message("notification.wasNotImportedAfterCreation.help", new Object[0]));
                yield var7_10;
            }
            case 7, 8 -> {
                EditorNotificationPanel var7_11;
                EditorNotificationPanel $this$collectNotificationData_u24lambda_u2415_u24lambda_u2414 = var7_11 = new EditorNotificationPanel(fileEditor, EditorNotificationPanel.Status.Info);
                boolean $i$a$-apply-GradleScriptNotificationProvider$collectNotificationData$1$5 = false;
                GradleStandaloneScriptActions actions = $standaloneScriptActions.get($file);
                if (actions != null) {
                    $this$collectNotificationData_u24lambda_u2415_u24lambda_u2414.text(KotlinGradleScriptingBundle.message("notification.standalone.text", new Object[0]) + ". " + KotlinGradleScriptingBundle.message("notification.text.script.configuration.has.been.changed", new Object[0]));
                    $this$collectNotificationData_u24lambda_u2415_u24lambda_u2414.createActionLabel(KotlinGradleScriptingBundle.message("notification.action.text.load.script.configuration", new Object[0]), () -> GradleScriptNotificationProvider.collectNotificationData$lambda$15$lambda$14$lambda$10(actions));
                    v2 = $this$collectNotificationData_u24lambda_u2415_u24lambda_u2414.createActionLabel(KotlinBaseScriptingBundle.message("notification.action.text.enable.auto.reload", new Object[0]), () -> GradleScriptNotificationProvider.collectNotificationData$lambda$15$lambda$14$lambda$11(actions));
                } else {
                    v2 = $this$collectNotificationData_u24lambda_u2415_u24lambda_u2414.text(KotlinGradleScriptingBundle.message("notification.standalone.text", new Object[0]));
                }
                $this$collectNotificationData_u24lambda_u2415_u24lambda_u2414.createActionLabel(KotlinGradleScriptingBundle.message("notification.standalone.disableScriptAction", new Object[0]), () -> GradleScriptNotificationProvider.collectNotificationData$lambda$15$lambda$14$lambda$13($rootsManager, $file));
                if ($scriptUnderRoot.getNotificationKind() == GradleBuildRootsLocator.NotificationKind.standaloneLegacy) {
                    this$0.contextHelp($this$collectNotificationData_u24lambda_u2415_u24lambda_u2414, KotlinGradleScriptingBundle.message("notification.gradle.legacy.standalone.info", new Object[0]));
                } else {
                    this$0.contextHelp($this$collectNotificationData_u24lambda_u2415_u24lambda_u2414, KotlinGradleScriptingBundle.message("notification.standalone.info", new Object[0]));
                }
                yield var7_11;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final AbstractProjectWizard linkProject$lambda$17(Project $project, ExternalSystemManager $manager, ProjectImportProvider[] $projectImportProviders) {
        FileChooserDescriptor fileChooserDescriptor = $manager.getExternalProjectDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)fileChooserDescriptor, (String)"getExternalProjectDescriptor(...)");
        return (AbstractProjectWizard)ImportModuleAction.Companion.selectFileAndCreateWizard($project, null, fileChooserDescriptor, $projectImportProviders);
    }

    private static final void contextHelp$lambda$19() {
    }

    public static final /* synthetic */ void access$contextHelp(GradleScriptNotificationProvider $this, EditorNotificationPanel $receiver, String text) {
        $this.contextHelp($receiver, text);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GradleBuildRootsLocator.NotificationKind.values().length];
            try {
                nArray[GradleBuildRootsLocator.NotificationKind.dontCare.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GradleBuildRootsLocator.NotificationKind.notEvaluatedInLastImport.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GradleBuildRootsLocator.NotificationKind.legacy.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GradleBuildRootsLocator.NotificationKind.legacyOutside.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GradleBuildRootsLocator.NotificationKind.outsideAnything.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GradleBuildRootsLocator.NotificationKind.wasNotImportedAfterCreation.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GradleBuildRootsLocator.NotificationKind.standalone.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GradleBuildRootsLocator.NotificationKind.standaloneLegacy.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

