/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.analysisApiPlatform;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.platform.caches.NullValue;
import org.jetbrains.kotlin.analysis.api.platform.caches.NullableConcurrentCache;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinCodeFragmentContextModificationEvent;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinGlobalModuleStateModificationEvent;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinGlobalScriptModuleStateModificationEvent;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinGlobalSourceModuleStateModificationEvent;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinGlobalSourceOutOfBlockModificationEvent;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinModificationEvent;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinModificationEventListener;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinModuleOutOfBlockModificationEvent;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinModuleStateModificationEvent;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaBuiltinsModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaLibraryFallbackDependenciesModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaLibraryModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaLibrarySourceModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaSourceModule;
import org.jetbrains.kotlin.idea.base.analysisApiPlatform.IdeKotlinModulePackageNamesProvider;
import org.jetbrains.kotlin.idea.base.analysisApiPlatform.KotlinModulePackageNamesProvider;
import org.jetbrains.kotlin.idea.base.indices.names.KotlinBinaryRootToPackageIndex;
import org.jetbrains.kotlin.idea.base.indices.names.KotlinBinaryRootToPackageIndexKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000K\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b*\u0001\u0017\b\u0000\u0018\u0000 #2\u00020\u00012\u00020\u0002:\u0002\"#B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\tH\u0016J\u0018\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\u0011H\u0002J\u001e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u001a\u001a\u00020\u0015H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\tH\u0002J\b\u0010\u001d\u001a\u00020\u001cH\u0002J\b\u0010!\u001a\u00020\u001cH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0007\u001a\u0016\u0012\u0004\u0012\u00020\t\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\"\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0010\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0018R \u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/idea/base/analysisApiPlatform/IdeKotlinModulePackageNamesProvider;", "Lcom/intellij/openapi/Disposable;", "Lorg/jetbrains/kotlin/idea/base/analysisApiPlatform/KotlinModulePackageNamesProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "cache", "Lorg/jetbrains/kotlin/analysis/api/platform/caches/NullableConcurrentCache;", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "", "", "Ljava/util/concurrent/ConcurrentMap;", "binaryRootsCache", "computePackageNames", "module", "computeSourceModulePackageSet", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaSourceModule;", "computePackageSetFromBinaryRoots", "binaryRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "binaryRootSearchScope", "org/jetbrains/kotlin/idea/base/analysisApiPlatform/IdeKotlinModulePackageNamesProvider$binaryRootSearchScope$1", "Lorg/jetbrains/kotlin/idea/base/analysisApiPlatform/IdeKotlinModulePackageNamesProvider$binaryRootSearchScope$1;", "computePackageSetFromBinaryRoot", "binaryRoot", "invalidate", "", "invalidateAll", "binaryRootFiles", "getBinaryRootFiles", "(Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;)Ljava/util/Collection;", "dispose", "ModificationEventListener", "Companion", "kotlin.base.analysis-api-platform"})
@SourceDebugExtension(value={"SMAP\nIdeKotlinModulePackageNamesProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeKotlinModulePackageNamesProvider.kt\norg/jetbrains/kotlin/idea/base/analysisApiPlatform/IdeKotlinModulePackageNamesProvider\n+ 2 NullableConcurrentCache.kt\norg/jetbrains/kotlin/analysis/api/platform/caches/NullableConcurrentCache\n+ 3 NullValue.kt\norg/jetbrains/kotlin/analysis/api/platform/caches/NullValueKt\n+ 4 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,171:1\n26#2:172\n26#2:193\n32#3:173\n33#3:178\n20#3,4:179\n32#3:194\n33#3:198\n20#3,4:199\n72#4,2:174\n72#4,2:195\n1#5:176\n1#5:177\n1#5:197\n1634#6,3:183\n1761#6,3:186\n1563#6:189\n1634#6,3:190\n1869#6,2:203\n*S KotlinDebug\n*F\n+ 1 IdeKotlinModulePackageNamesProvider.kt\norg/jetbrains/kotlin/idea/base/analysisApiPlatform/IdeKotlinModulePackageNamesProvider\n*L\n88#1:172\n132#1:193\n88#1:173\n88#1:178\n88#1:179,4\n132#1:194\n132#1:198\n132#1:199,4\n88#1:174,2\n132#1:195,2\n88#1:177\n132#1:197\n97#1:183,3\n104#1:186,3\n108#1:189\n108#1:190,3\n150#1:203,2\n*E\n"})
public final class IdeKotlinModulePackageNamesProvider
implements Disposable,
KotlinModulePackageNamesProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ConcurrentMap<K, Object> cache;
    @NotNull
    private final ConcurrentMap<K, Object> binaryRootsCache;
    @NotNull
    private final binaryRootSearchScope.1 binaryRootSearchScope;

    public IdeKotlinModulePackageNamesProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.cache = NullableConcurrentCache.constructor-impl$default(null, 1, null);
        this.binaryRootsCache = NullableConcurrentCache.constructor-impl$default(null, 1, null);
        LowMemoryWatcher.register(this::invalidateAll, (Disposable)this);
        Project project2 = this.project;
        this.binaryRootSearchScope = new GlobalSearchScope(project2){

            public boolean contains(VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                return true;
            }

            public boolean isSearchInModuleContent(Module aModule) {
                Intrinsics.checkNotNullParameter((Object)aModule, (String)"aModule");
                return true;
            }

            public boolean isSearchInLibraries() {
                return true;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Set<String> computePackageNames(@NotNull KaModule module) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        KaModule kaModule = module;
        if (kaModule instanceof KaSourceModule) {
            set = this.computeSourceModulePackageSet((KaSourceModule)module);
        } else if (kaModule instanceof KaLibraryModule) {
            Object value$iv$iv;
            void $this$getOrPut$iv$iv$iv;
            void $this$getOrPutWithNullableValue$iv$iv;
            void iterable;
            ConcurrentMap concurrentMap = this.cache;
            KaModule key$iv = module;
            boolean bl = false;
            void var6_9 = iterable;
            KaModule key$iv$iv = key$iv;
            boolean $i$f$getOrPutWithNullableValue = false;
            void var9_15 = $this$getOrPutWithNullableValue$iv$iv;
            KaModule key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object object = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (object == null) {
                Object object2;
                Object object3;
                boolean bl2 = false;
                KaModule it$iv = key$iv$iv;
                boolean bl3 = false;
                KaModule module2 = key$iv;
                boolean bl4 = false;
                Collection collection = this.getBinaryRootFiles(module2);
                if (collection != null) {
                    Collection it = collection;
                    boolean bl5 = false;
                    object3 = this.computePackageSetFromBinaryRoots(it);
                } else {
                    object3 = object2 = null;
                }
                if (object3 == null) {
                    object2 = NullValue.INSTANCE;
                }
                Set default$iv$iv$iv = object2;
                boolean bl6 = false;
                object = $this$getOrPut$iv$iv$iv.putIfAbsent(key$iv$iv$iv, default$iv$iv$iv);
                if (object == null) {
                    object = default$iv$iv$iv;
                }
            }
            Object $this$nullValueToNull$iv$iv$iv = value$iv$iv = object;
            boolean $i$f$nullValueToNull = false;
            set = Intrinsics.areEqual($this$nullValueToNull$iv$iv$iv, (Object)NullValue.INSTANCE) ? null : $this$nullValueToNull$iv$iv$iv;
        } else if (kaModule instanceof KaLibrarySourceModule) {
            set = this.computePackageNames(((KaLibrarySourceModule)module).getBinaryLibrary());
        } else if (kaModule instanceof KaLibraryFallbackDependenciesModule) {
            set = null;
        } else if (kaModule instanceof KaBuiltinsModule) {
            void destination$iv;
            void $this$mapTo$iv;
            Iterable iterable = StandardClassIds.INSTANCE.getBuiltInsPackages();
            Collection key$iv = new LinkedHashSet();
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                FqName $i$f$getOrPutWithNullableValue = (FqName)item$iv;
                void var22_30 = destination$iv;
                boolean bl = false;
                var22_30.add(it.asString());
            }
            set = (Set)destination$iv;
        } else {
            set = null;
        }
        return set;
    }

    private final Set<String> computeSourceModulePackageSet(KaSourceModule module) {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> computePackageSetFromBinaryRoots(Collection<? extends VirtualFile> binaryRoots) {
        void $this$mapTo$iv$iv;
        Object element$iv2;
        boolean bl;
        block9: {
            Iterable $this$any$iv = binaryRoots;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv2 : $this$any$iv) {
                    VirtualFile it = (VirtualFile)element$iv2;
                    boolean bl2 = false;
                    if (!(!KotlinBinaryRootToPackageIndexKt.isSupportedByBinaryRootToPackageIndex(it))) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        if (bl) {
            return null;
        }
        Iterable $this$map$iv = binaryRoots;
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            VirtualFile virtualFile = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(this.computePackageSetFromBinaryRoot((VirtualFile)p0));
        }
        List packageNameSets = (List)destination$iv$iv;
        return switch (packageNameSets.size()) {
            case 0 -> SetsKt.emptySet();
            case 1 -> (Set)CollectionsKt.single((List)packageNameSets);
            default -> (Set)AddToStdlibKt.flattenTo((Iterable)packageNameSets, (Collection)new LinkedHashSet());
        };
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> computePackageSetFromBinaryRoot(VirtualFile binaryRoot) {
        Object value$iv$iv;
        void $this$getOrPut$iv$iv$iv;
        void $this$getOrPutWithNullableValue$iv$iv;
        void $v$c$org-jetbrains-kotlin-analysis-api-platform-caches-NullableConcurrentCache$-this$0$iv;
        ConcurrentMap concurrentMap = this.binaryRootsCache;
        String string = binaryRoot.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String key$iv = string;
        boolean bl = false;
        void var5_5 = $v$c$org-jetbrains-kotlin-analysis-api-platform-caches-NullableConcurrentCache$-this$0$iv;
        String key$iv$iv = key$iv;
        boolean $i$f$getOrPutWithNullableValue = false;
        void var8_8 = $this$getOrPutWithNullableValue$iv$iv;
        String key$iv$iv$iv = key$iv$iv;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
        if (object == null) {
            Set set;
            boolean bl2 = false;
            String it$iv = key$iv$iv;
            boolean bl3 = false;
            String binaryRootName = key$iv;
            boolean bl4 = false;
            Set $this$computePackageSetFromBinaryRoot_u24lambda_u245_u24lambda_u244 = set = SetsKt.createSetBuilder();
            boolean bl5 = false;
            FileBasedIndex.getInstance().processValues(KotlinBinaryRootToPackageIndex.Companion.getNAME(), (Object)binaryRootName, null, new FileBasedIndex.ValueProcessor($this$computePackageSetFromBinaryRoot_u24lambda_u245_u24lambda_u244){
                final /* synthetic */ Set<String> $this_buildSet;
                {
                    this.$this_buildSet = $receiver;
                }

                public final boolean process(VirtualFile virtualFile, String packageName) {
                    Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"<unused var>");
                    ProgressManager.checkCanceled();
                    Intrinsics.checkNotNull((Object)packageName);
                    this.$this_buildSet.add(packageName);
                    return true;
                }
            }, (GlobalSearchScope)this.binaryRootSearchScope);
            Set set2 = SetsKt.build((Set)set);
            Object object2 = set2;
            if (set2 == null) {
                object2 = NullValue.INSTANCE;
            }
            Set default$iv$iv$iv = object2;
            boolean bl6 = false;
            object = $this$getOrPut$iv$iv$iv.putIfAbsent(key$iv$iv$iv, default$iv$iv$iv);
            if (object == null) {
                object = default$iv$iv$iv;
            }
        }
        Object $this$nullValueToNull$iv$iv$iv = value$iv$iv = object;
        boolean $i$f$nullValueToNull = false;
        return Intrinsics.areEqual($this$nullValueToNull$iv$iv$iv, (Object)NullValue.INSTANCE) ? null : $this$nullValueToNull$iv$iv$iv;
    }

    private final void invalidate(KaModule module) {
        block1: {
            this.cache.remove(module);
            Collection<VirtualFile> collection = this.getBinaryRootFiles(module);
            if (collection == null) break block1;
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VirtualFile binaryRoot = (VirtualFile)element$iv;
                boolean bl = false;
                this.binaryRootsCache.remove(binaryRoot.getName());
            }
        }
    }

    private final void invalidateAll() {
        this.cache.clear();
        this.binaryRootsCache.clear();
    }

    private final Collection<VirtualFile> getBinaryRootFiles(KaModule $this$binaryRootFiles) {
        return $this$binaryRootFiles instanceof KaLibraryModule ? ((KaLibraryModule)$this$binaryRootFiles).getBinaryVirtualFiles() : null;
    }

    public void dispose() {
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/base/analysisApiPlatform/IdeKotlinModulePackageNamesProvider$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/kotlin/idea/base/analysisApiPlatform/IdeKotlinModulePackageNamesProvider;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.base.analysis-api-platform"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IdeKotlinModulePackageNamesProvider getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            KotlinModulePackageNamesProvider kotlinModulePackageNamesProvider = KotlinModulePackageNamesProvider.Companion.getInstance(project);
            Intrinsics.checkNotNull((Object)kotlinModulePackageNamesProvider, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.idea.base.analysisApiPlatform.IdeKotlinModulePackageNamesProvider");
            return (IdeKotlinModulePackageNamesProvider)kotlinModulePackageNamesProvider;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/base/analysisApiPlatform/IdeKotlinModulePackageNamesProvider$ModificationEventListener;", "Lorg/jetbrains/kotlin/analysis/api/platform/modification/KotlinModificationEventListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "onModification", "", "event", "Lorg/jetbrains/kotlin/analysis/api/platform/modification/KotlinModificationEvent;", "kotlin.base.analysis-api-platform"})
    public static final class ModificationEventListener
    implements KotlinModificationEventListener {
        @NotNull
        private final Project project;

        public ModificationEventListener(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @Override
        public void onModification(@NotNull KotlinModificationEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            KotlinModificationEvent kotlinModificationEvent = event;
            if (kotlinModificationEvent instanceof KotlinModuleStateModificationEvent) {
                Companion.getInstance(this.project).invalidate(((KotlinModuleStateModificationEvent)event).getModule());
            } else if (kotlinModificationEvent instanceof KotlinGlobalModuleStateModificationEvent) {
                Companion.getInstance(this.project).invalidateAll();
            } else if (!(kotlinModificationEvent instanceof KotlinModuleOutOfBlockModificationEvent || Intrinsics.areEqual((Object)kotlinModificationEvent, (Object)KotlinGlobalSourceModuleStateModificationEvent.INSTANCE) || Intrinsics.areEqual((Object)kotlinModificationEvent, (Object)KotlinGlobalScriptModuleStateModificationEvent.INSTANCE) || Intrinsics.areEqual((Object)kotlinModificationEvent, (Object)KotlinGlobalSourceOutOfBlockModificationEvent.INSTANCE) || kotlinModificationEvent instanceof KotlinCodeFragmentContextModificationEvent)) {
                throw new NoWhenBranchMatchedException();
            }
        }
    }
}

