/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.inspections.shared;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.codeinsight.utils.KotlinPsiUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0002\f\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\f\u0010\n\u001a\u00020\t*\u00020\u000bH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/WrapUnaryOperatorInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "isUnaryMinusOrPlus", "Lcom/intellij/psi/tree/IElementType;", "Holder", "WrapUnaryOperatorQuickfix", "kotlin.code-insight.inspections.shared"})
public final class WrapUnaryOperatorInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        return (PsiElementVisitor)VisitorWrappersKt.prefixExpressionVisitor(arg_0 -> WrapUnaryOperatorInspection.buildVisitor$lambda$0(this, holder2, arg_0));
    }

    private final boolean isUnaryMinusOrPlus(IElementType $this$isUnaryMinusOrPlus) {
        return Intrinsics.areEqual((Object)$this$isUnaryMinusOrPlus, (Object)KtTokens.MINUS) || Intrinsics.areEqual((Object)$this$isUnaryMinusOrPlus, (Object)KtTokens.PLUS);
    }

    private static final Unit buildVisitor$lambda$0(WrapUnaryOperatorInspection this$0, ProblemsHolder $holder, KtPrefixExpression expression) {
        KtExpression receiverExpression;
        KtExpression baseExpression;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        IElementType iElementType = expression.getOperationToken();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getOperationToken(...)");
        if (this$0.isUnaryMinusOrPlus(iElementType) && (baseExpression = expression.getBaseExpression()) instanceof KtDotQualifiedExpression && (receiverExpression = ((KtDotQualifiedExpression)baseExpression).getReceiverExpression()) instanceof KtConstantExpression && Holder.INSTANCE.getNumberTypes().contains(((KtConstantExpression)receiverExpression).getNode().getElementType())) {
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new WrapUnaryOperatorQuickfix()};
            $holder.registerProblem((PsiElement)expression, KotlinBundle.message((String)"wrap.unary.operator.quickfix.text", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, localQuickFixArray);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/WrapUnaryOperatorInspection$Holder;", "", "<init>", "()V", "numberTypes", "", "Lcom/intellij/psi/tree/IElementType;", "getNumberTypes", "()Ljava/util/List;", "kotlin.code-insight.inspections.shared"})
    private static final class Holder {
        @NotNull
        public static final Holder INSTANCE = new Holder();
        @NotNull
        private static final List<IElementType> numberTypes;

        private Holder() {
        }

        @NotNull
        public final List<IElementType> getNumberTypes() {
            return numberTypes;
        }

        static {
            Object[] objectArray = new IElementType[]{KtNodeTypes.INTEGER_CONSTANT, KtNodeTypes.FLOAT_CONSTANT};
            numberTypes = CollectionsKt.listOf((Object[])objectArray);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/WrapUnaryOperatorInspection$WrapUnaryOperatorQuickfix;", "Lcom/intellij/modcommand/PsiUpdateModCommandQuickFix;", "<init>", "()V", "getFamilyName", "", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lcom/intellij/psi/PsiElement;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "kotlin.code-insight.inspections.shared"})
    private static final class WrapUnaryOperatorQuickfix
    extends PsiUpdateModCommandQuickFix {
        @NotNull
        public String getFamilyName() {
            return KotlinBundle.message((String)"wrap.unary.operator.quickfix.text", (Object[])new Object[0]);
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
            KtPrefixExpression ktPrefixExpression = element instanceof KtPrefixExpression ? (KtPrefixExpression)element : null;
            if (ktPrefixExpression == null) {
                return;
            }
            KtPrefixExpression expression = ktPrefixExpression;
            KtExpression ktExpression = expression.getBaseExpression();
            KtDotQualifiedExpression ktDotQualifiedExpression = ktExpression instanceof KtDotQualifiedExpression ? (KtDotQualifiedExpression)ktExpression : null;
            if (ktDotQualifiedExpression == null) {
                return;
            }
            KtDotQualifiedExpression dotQualifiedExpression = ktDotQualifiedExpression;
            KtPsiFactory factory2 = new KtPsiFactory(project, false, 2, null);
            Object[] objectArray = new Object[2];
            Intrinsics.checkNotNullExpressionValue((Object)expression.getOperationReference().getText(), (String)"getText(...)");
            objectArray[1] = KotlinPsiUtilsKt.getLeftMostReceiverExpression((KtQualifiedExpression)dotQualifiedExpression);
            KtExpression newReceiver = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)factory2, (String)"($0$1)", (Object[])objectArray, (boolean)false, (int)4, null);
            KtExpression newExpression = KotlinPsiUtilsKt.replaceFirstReceiver$default(dotQualifiedExpression, factory2, newReceiver, false, 4, null);
            expression.replace((PsiElement)newExpression);
        }
    }
}

