/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.inspections.shared.coroutines;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.components.KaTypeRelationChecker;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallableMemberCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaExplicitReceiverValue;
import org.jetbrains.kotlin.analysis.api.resolution.KaReceiverValue;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaReceiverParameterSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaValueParameterSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.idea.codeinsight.utils.ConvertLambdaToReferenceUtils;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.resolve.ImportPath;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u001a\u0016\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u001c\u0010\u0005\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u001a\u0014\u0010\u000e\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u0014\u0010\u0011\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\u0014\u0010\u0014\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u0014\u0010\u0015\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\"\u0014\u0010\u0016\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0014\u0010\u0019\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018\u00a8\u0006\u001b"}, d2={"singleReturnedExpressionOrNull", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "lambdaExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "isLambdaWithSingleReturnedCallOnSingleParameter", "", "callableId", "Lorg/jetbrains/kotlin/name/CallableId;", "isPackageImportedByStarImport", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "isIterableForEachFunctionCall", "element", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "isIterableForEachFunction", "symbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaFunctionSymbol;", "isIterableMapFunctionCall", "isIterableMapFunction", "KOTLIN_COLLECTIONS_FOR_EACH_ID", "getKOTLIN_COLLECTIONS_FOR_EACH_ID", "()Lorg/jetbrains/kotlin/name/CallableId;", "KOTLIN_COLLECTIONS_MAP_ID", "getKOTLIN_COLLECTIONS_MAP_ID", "kotlin.code-insight.inspections.shared"})
@SourceDebugExtension(value={"SMAP\ncoroutinesUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 coroutinesUtils.kt\norg/jetbrains/kotlin/idea/codeInsight/inspections/shared/coroutines/CoroutinesUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n1761#2,3:93\n*S KotlinDebug\n*F\n+ 1 coroutinesUtils.kt\norg/jetbrains/kotlin/idea/codeInsight/inspections/shared/coroutines/CoroutinesUtilsKt\n*L\n58#1:93,3\n*E\n"})
public final class CoroutinesUtilsKt {
    @NotNull
    private static final CallableId KOTLIN_COLLECTIONS_FOR_EACH_ID;
    @NotNull
    private static final CallableId KOTLIN_COLLECTIONS_MAP_ID;

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public static final KtExpression singleReturnedExpressionOrNull(@NotNull KaSession $this$singleReturnedExpressionOrNull, @NotNull KtLambdaExpression lambdaExpression) {
        KtExpression ktExpression;
        Intrinsics.checkNotNullParameter((Object)$this$singleReturnedExpressionOrNull, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)lambdaExpression, (String)"lambdaExpression");
        KtExpression ktExpression2 = ConvertLambdaToReferenceUtils.INSTANCE.singleStatementOrNull(lambdaExpression);
        if (ktExpression2 == null) {
            return null;
        }
        KtExpression singleStatement = ktExpression2;
        if (singleStatement instanceof KtReturnExpression) {
            KaCallableSymbol kaCallableSymbol = $this$singleReturnedExpressionOrNull.getTargetSymbol((KtReturnExpression)singleStatement);
            KtFunctionLiteral ktFunctionLiteral = lambdaExpression.getFunctionLiteral();
            Intrinsics.checkNotNullExpressionValue((Object)ktFunctionLiteral, (String)"getFunctionLiteral(...)");
            if (Intrinsics.areEqual((Object)kaCallableSymbol, (Object)$this$singleReturnedExpressionOrNull.getSymbol(ktFunctionLiteral))) {
                ktExpression = ((KtReturnExpression)singleStatement).getReturnedExpression();
                return ktExpression;
            }
        }
        ktExpression = singleStatement;
        return ktExpression;
    }

    public static final boolean isLambdaWithSingleReturnedCallOnSingleParameter(@NotNull KaSession $this$isLambdaWithSingleReturnedCallOnSingleParameter, @NotNull KtLambdaExpression lambdaExpression, @NotNull CallableId callableId) {
        Intrinsics.checkNotNullParameter((Object)$this$isLambdaWithSingleReturnedCallOnSingleParameter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)lambdaExpression, (String)"lambdaExpression");
        Intrinsics.checkNotNullParameter((Object)callableId, (String)"callableId");
        KtFunctionLiteral ktFunctionLiteral = lambdaExpression.getFunctionLiteral();
        Intrinsics.checkNotNullExpressionValue((Object)ktFunctionLiteral, (String)"getFunctionLiteral(...)");
        KaValueParameterSymbol kaValueParameterSymbol = (KaValueParameterSymbol)CollectionsKt.singleOrNull($this$isLambdaWithSingleReturnedCallOnSingleParameter.getSymbol(ktFunctionLiteral).getValueParameters());
        if (kaValueParameterSymbol == null) {
            return false;
        }
        KaValueParameterSymbol singleLambdaParameterSymbol = kaValueParameterSymbol;
        KtExpression ktExpression = CoroutinesUtilsKt.singleReturnedExpressionOrNull($this$isLambdaWithSingleReturnedCallOnSingleParameter, lambdaExpression);
        KtDotQualifiedExpression ktDotQualifiedExpression = ktExpression instanceof KtDotQualifiedExpression ? (KtDotQualifiedExpression)ktExpression : null;
        if (ktDotQualifiedExpression == null) {
            return false;
        }
        KtDotQualifiedExpression singleReturnedExpression = ktDotQualifiedExpression;
        KaLifetimeOwner kaLifetimeOwner = $this$isLambdaWithSingleReturnedCallOnSingleParameter.resolveToCall((KtElement)singleReturnedExpression);
        if (kaLifetimeOwner == null || (kaLifetimeOwner = KaCallInfoKt.successfulFunctionCallOrNull((KaCallInfo)kaLifetimeOwner)) == null) {
            return false;
        }
        KaLifetimeOwner methodCall = kaLifetimeOwner;
        KaReceiverValue kaReceiverValue = methodCall.getPartiallyAppliedSymbol().getDispatchReceiver();
        KaExplicitReceiverValue kaExplicitReceiverValue = kaReceiverValue instanceof KaExplicitReceiverValue ? (KaExplicitReceiverValue)kaReceiverValue : null;
        if (kaExplicitReceiverValue == null) {
            return false;
        }
        KaExplicitReceiverValue explicitReceiverValue = kaExplicitReceiverValue;
        KaLifetimeOwner kaLifetimeOwner2 = $this$isLambdaWithSingleReturnedCallOnSingleParameter.resolveToCall((KtElement)explicitReceiverValue.getExpression());
        if (kaLifetimeOwner2 == null || (kaLifetimeOwner2 = KaCallInfoKt.successfulVariableAccessCall(kaLifetimeOwner2)) == null) {
            return false;
        }
        KaLifetimeOwner explicitReceiverAccessCall = kaLifetimeOwner2;
        return Intrinsics.areEqual((Object)((KaCallableSymbol)KaCallKt.getSymbol((KaCallableMemberCall)methodCall)).getCallableId(), (Object)callableId) && Intrinsics.areEqual(KaCallKt.getSymbol((KaCallableMemberCall)explicitReceiverAccessCall), (Object)singleLambdaParameterSymbol);
    }

    public static final boolean isPackageImportedByStarImport(@NotNull KtFile file, @NotNull FqName packageFqName) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
            Iterable $this$any$iv = file.getImportDirectives();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KtImportDirective it = (KtImportDirective)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getImportPath(), (Object)new ImportPath(packageFqName, true, null, 4, null))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean isIterableForEachFunctionCall(@NotNull KaSession $this$isIterableForEachFunctionCall, @NotNull KtCallExpression element) {
        Intrinsics.checkNotNullParameter((Object)$this$isIterableForEachFunctionCall, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KaLifetimeOwner kaLifetimeOwner = $this$isIterableForEachFunctionCall.resolveToCall((KtElement)element);
        if (kaLifetimeOwner == null || (kaLifetimeOwner = KaCallInfoKt.successfulFunctionCallOrNull((KaCallInfo)kaLifetimeOwner)) == null) {
            return false;
        }
        KaLifetimeOwner functionCall = kaLifetimeOwner;
        KaLifetimeOwner kaLifetimeOwner2 = functionCall.getPartiallyAppliedSymbol().getExtensionReceiver();
        if (kaLifetimeOwner2 == null || (kaLifetimeOwner2 = kaLifetimeOwner2.getType()) == null) {
            return false;
        }
        KaLifetimeOwner actualReceiverType = kaLifetimeOwner2;
        return CoroutinesUtilsKt.isIterableForEachFunction($this$isIterableForEachFunctionCall, (KaFunctionSymbol)KaCallKt.getSymbol((KaCallableMemberCall)functionCall)) && KaTypeRelationChecker.isSubtypeOf$default((KaTypeRelationChecker)$this$isIterableForEachFunctionCall, (KaType)actualReceiverType, StandardClassIds.INSTANCE.getCollection(), null, 2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isIterableForEachFunction(KaSession $this$isIterableForEachFunction, KaFunctionSymbol symbol) {
        if (!Intrinsics.areEqual((Object)symbol.getCallableId(), (Object)KOTLIN_COLLECTIONS_FOR_EACH_ID)) return false;
        KaReceiverParameterSymbol kaReceiverParameterSymbol = symbol.getReceiverParameter();
        if (kaReceiverParameterSymbol == null) return false;
        KaType kaType = kaReceiverParameterSymbol.getReturnType();
        if (kaType == null) return false;
        if (!KaTypeRelationChecker.isSubtypeOf$default((KaTypeRelationChecker)$this$isIterableForEachFunction, kaType, StandardClassIds.INSTANCE.getIterable(), null, 2, null)) return false;
        return true;
    }

    public static final boolean isIterableMapFunctionCall(@NotNull KaSession $this$isIterableMapFunctionCall, @NotNull KtCallExpression element) {
        Intrinsics.checkNotNullParameter((Object)$this$isIterableMapFunctionCall, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KaLifetimeOwner kaLifetimeOwner = $this$isIterableMapFunctionCall.resolveToCall((KtElement)element);
        if (kaLifetimeOwner == null || (kaLifetimeOwner = KaCallInfoKt.successfulFunctionCallOrNull((KaCallInfo)kaLifetimeOwner)) == null) {
            return false;
        }
        KaLifetimeOwner functionCall = kaLifetimeOwner;
        KaLifetimeOwner kaLifetimeOwner2 = functionCall.getPartiallyAppliedSymbol().getExtensionReceiver();
        if (kaLifetimeOwner2 == null || (kaLifetimeOwner2 = kaLifetimeOwner2.getType()) == null) {
            return false;
        }
        KaLifetimeOwner actualReceiverType = kaLifetimeOwner2;
        return CoroutinesUtilsKt.isIterableMapFunction($this$isIterableMapFunctionCall, (KaFunctionSymbol)KaCallKt.getSymbol((KaCallableMemberCall)functionCall)) && KaTypeRelationChecker.isSubtypeOf$default((KaTypeRelationChecker)$this$isIterableMapFunctionCall, (KaType)actualReceiverType, StandardClassIds.INSTANCE.getCollection(), null, 2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isIterableMapFunction(KaSession $this$isIterableMapFunction, KaFunctionSymbol symbol) {
        if (!Intrinsics.areEqual((Object)symbol.getCallableId(), (Object)KOTLIN_COLLECTIONS_MAP_ID)) return false;
        KaReceiverParameterSymbol kaReceiverParameterSymbol = symbol.getReceiverParameter();
        if (kaReceiverParameterSymbol == null) return false;
        KaType kaType = kaReceiverParameterSymbol.getReturnType();
        if (kaType == null) return false;
        if (!KaTypeRelationChecker.isSubtypeOf$default((KaTypeRelationChecker)$this$isIterableMapFunction, kaType, StandardClassIds.INSTANCE.getIterable(), null, 2, null)) return false;
        return true;
    }

    @NotNull
    public static final CallableId getKOTLIN_COLLECTIONS_FOR_EACH_ID() {
        return KOTLIN_COLLECTIONS_FOR_EACH_ID;
    }

    @NotNull
    public static final CallableId getKOTLIN_COLLECTIONS_MAP_ID() {
        return KOTLIN_COLLECTIONS_MAP_ID;
    }

    static {
        FqName fqName2 = new FqName("kotlin.collections");
        Name name2 = Name.identifier((String)"forEach");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        KOTLIN_COLLECTIONS_FOR_EACH_ID = new CallableId(fqName2, name2);
        FqName fqName3 = new FqName("kotlin.collections");
        Name name3 = Name.identifier((String)"map");
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
        KOTLIN_COLLECTIONS_MAP_ID = new CallableId(fqName3, name3);
    }
}

