/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.compiler.configuration;

import com.intellij.openapi.roots.libraries.JarVersionDetectionUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.FsRoot;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.jar.Attributes;
import kotlin.KotlinVersion;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinPluginLayout;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u0000 42\b\u0012\u0004\u0012\u00020\u00000\u0001:\u000245BC\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0006\u0010*\u001a\u00020\u0000J\u0013\u0010+\u001a\u00020\t2\b\u0010,\u001a\u0004\u0018\u00010-H\u0096\u0002J\b\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u00020\u0003H\u0016J\u0011\u00101\u001a\u00020/2\u0006\u0010,\u001a\u00020\u0000H\u0096\u0002J\u000e\u00102\u001a\u00020/2\u0006\u00103\u001a\u00020\u0003J\u000e\u00102\u001a\u00020/2\u0006\u0010,\u001a\u00020\u0000R\u0013\u0010\u0002\u001a\u00020\u00038G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\n\u001a\u0004\u0018\u00010\u00038G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0012R\u0011\u0010 \u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0012R\u0011\u0010\"\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001dR\u0011\u0010#\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u001dR\u0011\u0010$\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u001dR\u0011\u0010%\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u001dR\u0011\u0010&\u001a\u00020'8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u00066"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion;", "", "rawVersion", "", "kotlinVersion", "Lkotlin/KotlinVersion;", "kind", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind;", "requireBuildNumberForArtifact", "", "buildNumber", "languageVersion", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "apiVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "<init>", "(Ljava/lang/String;Lkotlin/KotlinVersion;Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind;ZLjava/lang/String;Lorg/jetbrains/kotlin/config/LanguageVersion;Lorg/jetbrains/kotlin/config/ApiVersion;)V", "getRawVersion", "()Ljava/lang/String;", "getKotlinVersion", "()Lkotlin/KotlinVersion;", "getKind", "()Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind;", "getBuildNumber", "getLanguageVersion", "()Lorg/jetbrains/kotlin/config/LanguageVersion;", "getApiVersion", "()Lorg/jetbrains/kotlin/config/ApiVersion;", "isStandaloneCompilerVersion", "()Z", "baseVersion", "getBaseVersion", "artifactVersion", "getArtifactVersion", "isRelease", "isPreRelease", "isDev", "isSnapshot", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "withoutBuildNumber", "equals", "other", "", "hashCode", "", "toString", "compareTo", "compare", "otherRawVersion", "Companion", "Kind", "kotlin.base.plugin"})
public final class IdeKotlinVersion
implements Comparable<IdeKotlinVersion> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String rawVersion;
    @NotNull
    private final KotlinVersion kotlinVersion;
    @NotNull
    private final Kind kind;
    private final boolean requireBuildNumberForArtifact;
    @Nullable
    private final String buildNumber;
    @NotNull
    private final LanguageVersion languageVersion;
    @NotNull
    private final ApiVersion apiVersion;
    @NotNull
    private static final Regex KOTLIN_COMPILER_VERSION_PATTERN = new Regex("^(\\d+)\\.(\\d+)\\.(\\d+)(?:-([A-Za-z]\\w+(?:\\.\\d+)?(?:-release)?))?(?:-(\\d+)?)?$", RegexOption.IGNORE_CASE);

    private IdeKotlinVersion(String rawVersion, KotlinVersion kotlinVersion, Kind kind2, boolean requireBuildNumberForArtifact, String buildNumber, LanguageVersion languageVersion, ApiVersion apiVersion) {
        this.rawVersion = rawVersion;
        this.kotlinVersion = kotlinVersion;
        this.kind = kind2;
        this.requireBuildNumberForArtifact = requireBuildNumberForArtifact;
        this.buildNumber = buildNumber;
        this.languageVersion = languageVersion;
        this.apiVersion = apiVersion;
    }

    @NlsSafe
    @NotNull
    public final String getRawVersion() {
        return this.rawVersion;
    }

    @NotNull
    public final KotlinVersion getKotlinVersion() {
        return this.kotlinVersion;
    }

    @NotNull
    public final Kind getKind() {
        return this.kind;
    }

    @NlsSafe
    @Nullable
    public final String getBuildNumber() {
        return this.buildNumber;
    }

    @NotNull
    public final LanguageVersion getLanguageVersion() {
        return this.languageVersion;
    }

    @NotNull
    public final ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public final boolean isStandaloneCompilerVersion() {
        return Intrinsics.areEqual((Object)this, (Object)KotlinPluginLayout.getStandaloneCompilerVersion());
    }

    @NotNull
    public final String getBaseVersion() {
        return this.kotlinVersion.toString();
    }

    @NotNull
    public final String getArtifactVersion() {
        StringBuilder stringBuilder;
        StringBuilder $this$_get_artifactVersion__u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$_get_artifactVersion__u24lambda_u240.append(this.getBaseVersion());
        if (this.kind.getArtifactSuffix() != null) {
            $this$_get_artifactVersion__u24lambda_u240.append('-').append(this.kind.getArtifactSuffix());
        }
        if (this.requireBuildNumberForArtifact && this.buildNumber != null) {
            $this$_get_artifactVersion__u24lambda_u240.append('-').append(this.buildNumber);
        }
        return stringBuilder.toString();
    }

    public final boolean isRelease() {
        return Intrinsics.areEqual((Object)this.kind, (Object)Kind.Release.INSTANCE);
    }

    public final boolean isPreRelease() {
        return !this.isRelease();
    }

    public final boolean isDev() {
        return Intrinsics.areEqual((Object)this.kind, (Object)Kind.Dev.INSTANCE);
    }

    public final boolean isSnapshot() {
        return Intrinsics.areEqual((Object)this.kind, (Object)Kind.Snapshot.INSTANCE);
    }

    @NotNull
    public final LanguageVersionSettings getLanguageVersionSettings() {
        return (LanguageVersionSettings)new LanguageVersionSettingsImpl(this.languageVersion, this.apiVersion, null, null, 12, null);
    }

    @NotNull
    public final IdeKotlinVersion withoutBuildNumber() {
        Object object;
        return this.buildNumber != null ? (IdeKotlinVersion)(Result.isFailure-impl((Object)(object = Companion.parse-IoAF18A(StringsKt.substringBeforeLast$default((String)this.rawVersion, (char)'-', null, (int)2, null)))) ? this : object) : this;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        IdeKotlinVersion ideKotlinVersion = other instanceof IdeKotlinVersion ? (IdeKotlinVersion)other : null;
        if (ideKotlinVersion == null) {
            return false;
        }
        IdeKotlinVersion otherVersion = ideKotlinVersion;
        return Intrinsics.areEqual((Object)this.rawVersion, (Object)otherVersion.rawVersion);
    }

    public int hashCode() {
        return this.rawVersion.hashCode();
    }

    @NotNull
    public String toString() {
        return this.rawVersion;
    }

    @Override
    public int compareTo(@NotNull IdeKotlinVersion other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return VersionComparatorUtil.compare((String)this.rawVersion, (String)other.rawVersion);
    }

    public final int compare(@NotNull String otherRawVersion) {
        Intrinsics.checkNotNullParameter((Object)otherRawVersion, (String)"otherRawVersion");
        return VersionComparatorUtil.compare((String)this.rawVersion, (String)otherRawVersion);
    }

    public final int compare(@NotNull IdeKotlinVersion other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return VersionComparatorUtil.compare((String)this.rawVersion, (String)other.rawVersion);
    }

    @JvmStatic
    @NotNull
    public static final IdeKotlinVersion get(@NlsSafe @NotNull String rawVersion) {
        return Companion.get(rawVersion);
    }

    @JvmStatic
    @Nullable
    public static final IdeKotlinVersion opt(@NlsSafe @NotNull String rawVersion) {
        return Companion.opt(rawVersion);
    }

    @JvmStatic
    @NotNull
    public static final IdeKotlinVersion fromLanguageVersion(@NotNull LanguageVersion languageVersion) {
        return Companion.fromLanguageVersion(languageVersion);
    }

    @JvmStatic
    @Nullable
    public static final IdeKotlinVersion fromManifest(@NotNull VirtualFile jarFile) {
        return Companion.fromManifest(jarFile);
    }

    @JvmStatic
    @Nullable
    public static final IdeKotlinVersion fromKLibManifest(@NotNull VirtualFile jarFile) {
        return Companion.fromKLibManifest(jarFile);
    }

    public /* synthetic */ IdeKotlinVersion(String rawVersion, KotlinVersion kotlinVersion, Kind kind2, boolean requireBuildNumberForArtifact, String buildNumber, LanguageVersion languageVersion, ApiVersion apiVersion, DefaultConstructorMarker $constructor_marker) {
        this(rawVersion, kotlinVersion, kind2, requireBuildNumberForArtifact, buildNumber, languageVersion, apiVersion);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\tH\u0007J\u0014\u0010\n\u001a\u0004\u0018\u00010\u00072\b\b\u0001\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0007J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0010J0\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\t2\u0014\u0010\u0019\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u001b\u0012\u0004\u0012\u00020\u00160\u001aH\u0002J\u001b\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\u001d2\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Companion;", "", "<init>", "()V", "KOTLIN_COMPILER_VERSION_PATTERN", "Lkotlin/text/Regex;", "get", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion;", "rawVersion", "", "opt", "fromLanguageVersion", "languageVersion", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "fromManifest", "jarFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "fromKLibManifest", "klibManifestProperties", "Ljava/util/Properties;", "componentFile", "parseKind", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind;", "kindSuffix", "prefix", "factory", "Lkotlin/Function1;", "", "parse", "Lkotlin/Result;", "parse-IoAF18A", "(Ljava/lang/String;)Ljava/lang/Object;", "kotlin.base.plugin"})
    @SourceDebugExtension(value={"SMAP\nIdeKotlinVersion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeKotlinVersion.kt\norg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,225:1\n1#2:226\n1310#3,2:227\n*S KotlinDebug\n*F\n+ 1 IdeKotlinVersion.kt\norg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Companion\n*L\n138#1:227,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final IdeKotlinVersion get(@NlsSafe @NotNull String rawVersion) {
            Intrinsics.checkNotNullParameter((Object)rawVersion, (String)"rawVersion");
            Object object = this.parse-IoAF18A(rawVersion);
            ResultKt.throwOnFailure((Object)object);
            return (IdeKotlinVersion)object;
        }

        @JvmStatic
        @Nullable
        public final IdeKotlinVersion opt(@NlsSafe @NotNull String rawVersion) {
            Intrinsics.checkNotNullParameter((Object)rawVersion, (String)"rawVersion");
            Object object = this.parse-IoAF18A(rawVersion);
            return (IdeKotlinVersion)(Result.isFailure-impl((Object)object) ? null : object);
        }

        @JvmStatic
        @NotNull
        public final IdeKotlinVersion fromLanguageVersion(@NotNull LanguageVersion languageVersion) {
            Intrinsics.checkNotNullParameter((Object)languageVersion, (String)"languageVersion");
            return new IdeKotlinVersion(languageVersion.getMajor() + "." + languageVersion.getMinor() + ".0", new KotlinVersion(languageVersion.getMajor(), languageVersion.getMinor(), 0), Kind.Release.INSTANCE, false, null, languageVersion, ApiVersion.Companion.createByLanguageVersion(languageVersion), null);
        }

        @JvmStatic
        @Nullable
        public final IdeKotlinVersion fromManifest(@NotNull VirtualFile jarFile) {
            VirtualFile virtualFile;
            Intrinsics.checkNotNullParameter((Object)jarFile, (String)"jarFile");
            if (jarFile instanceof FsRoot) {
                virtualFile = jarFile;
            } else {
                virtualFile = JarFileSystem.getInstance().getJarRootForLocalFile(jarFile);
                if (virtualFile == null) {
                    return null;
                }
            }
            VirtualFile jarRoot = virtualFile;
            String string = JarVersionDetectionUtil.getMainAttribute((VirtualFile)jarRoot, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION);
            if (string == null) {
                return null;
            }
            String unprocessedVersion = string;
            String rawVersion = ((Object)StringsKt.trim((CharSequence)StringsKt.substringBefore$default((String)unprocessedVersion, (char)'(', null, (int)2, null))).toString();
            return this.opt(rawVersion);
        }

        @JvmStatic
        @Nullable
        public final IdeKotlinVersion fromKLibManifest(@NotNull VirtualFile jarFile) {
            IdeKotlinVersion ideKotlinVersion;
            Properties properties;
            Object object;
            block8: {
                VirtualFile virtualFile;
                Intrinsics.checkNotNullParameter((Object)jarFile, (String)"jarFile");
                if (jarFile instanceof FsRoot) {
                    virtualFile = jarFile;
                } else {
                    virtualFile = JarFileSystem.getInstance().getJarRootForLocalFile(jarFile);
                    if (virtualFile == null) {
                        return null;
                    }
                }
                VirtualFile root = virtualFile;
                VirtualFile[] virtualFileArray = root.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
                object = virtualFileArray;
                int n = ((Object[])object).length;
                for (int j = 0; j < n; ++j) {
                    VirtualFile it = (VirtualFile)object[j];
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    properties = Companion.klibManifestProperties(it);
                    if (properties == null) {
                        continue;
                    }
                    break block8;
                }
                properties = null;
            }
            if (properties == null) {
                return null;
            }
            Properties properties2 = properties;
            object = properties2.get("compiler_version");
            String string = object instanceof String ? (String)object : null;
            if (string != null) {
                String p0 = string;
                boolean bl = false;
                ideKotlinVersion = this.opt(p0);
            } else {
                ideKotlinVersion = null;
            }
            return ideKotlinVersion;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final Properties klibManifestProperties(@NotNull VirtualFile componentFile) {
            Closeable closeable;
            Object object;
            Object object2;
            block11: {
                block10: {
                    Intrinsics.checkNotNullParameter((Object)componentFile, (String)"componentFile");
                    object2 = componentFile.findChild("manifest");
                    if (object2 == null) break block10;
                    VirtualFile it = object = object2;
                    boolean bl = false;
                    object2 = !it.isDirectory() ? object : null;
                    if (object2 != null) break block11;
                }
                return null;
            }
            VirtualFile manifestFile = object2;
            try {
                closeable = manifestFile.getInputStream();
                Throwable throwable = null;
                try {
                    Properties properties;
                    InputStream it = (InputStream)closeable;
                    boolean bl = false;
                    Properties $this$klibManifestProperties_u24lambda_u243_u24lambda_u242 = properties = new Properties();
                    boolean bl2 = false;
                    $this$klibManifestProperties_u24lambda_u243_u24lambda_u242.load(it);
                    object = properties;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                closeable = object;
            }
            catch (IOException iOException) {
                return null;
            }
            return closeable;
        }

        private final Kind parseKind(String kindSuffix, String prefix2, Function1<? super Integer, ? extends Kind> factory2) {
            if (!StringsKt.startsWith$default((String)kindSuffix, (String)prefix2, (boolean)false, (int)2, null)) {
                boolean $i$a$-check-IdeKotlinVersion$Companion$parseKind$22 = false;
                String $i$a$-check-IdeKotlinVersion$Companion$parseKind$22 = "Prefix \"" + prefix2 + "\" not found in kind suffix \"" + kindSuffix + "\"";
                throw new IllegalStateException($i$a$-check-IdeKotlinVersion$Companion$parseKind$22.toString());
            }
            String numberString = StringsKt.removeSuffix((String)StringsKt.drop((String)kindSuffix, (int)prefix2.length()), (CharSequence)"-release");
            if (((CharSequence)numberString).length() == 0) {
                return (Kind)factory2.invoke(null);
            }
            Integer n = StringsKt.toIntOrNull((String)numberString);
            if (n == null) {
                return null;
            }
            int number = n;
            return (Kind)factory2.invoke((Object)number);
        }

        @NotNull
        public final Object parse-IoAF18A(@NotNull String rawVersion) {
            LanguageVersion languageVersion;
            LanguageVersion languageVersion2;
            boolean requireBuildNumberForArtifact;
            String buildNumber;
            Kind kind2;
            KotlinVersion kotlinVersion;
            block7: {
                Object object;
                Intrinsics.checkNotNullParameter((Object)rawVersion, (String)"rawVersion");
                MatchResult matchResult = KOTLIN_COMPILER_VERSION_PATTERN.matchEntire((CharSequence)rawVersion);
                if (matchResult == null) {
                    return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new IllegalArgumentException("Unsupported compiler version: " + rawVersion)));
                }
                MatchResult matchResult2 = matchResult;
                Integer n = StringsKt.toIntOrNull((String)((String)matchResult2.getGroupValues().get(1)));
                if (n == null) {
                    return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new IllegalArgumentException("Invalid major version component: " + rawVersion)));
                }
                int majorValue = n;
                Integer n2 = StringsKt.toIntOrNull((String)((String)matchResult2.getGroupValues().get(2)));
                if (n2 == null) {
                    return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new IllegalArgumentException("Invalid minor version component: " + rawVersion)));
                }
                int minorValue = n2;
                Integer n3 = StringsKt.toIntOrNull((String)((String)matchResult2.getGroupValues().get(3)));
                if (n3 == null) {
                    return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new IllegalArgumentException("Invalid patch version component: " + rawVersion)));
                }
                int patchValue = n3;
                kotlinVersion = new KotlinVersion(majorValue, minorValue, patchValue);
                String kindSuffix = CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly((String)((String)matchResult2.getGroupValues().get(4)));
                Kind kind3 = Intrinsics.areEqual((Object)kindSuffix, (Object)"release") || Intrinsics.areEqual((Object)kindSuffix, (Object)"") ? (Kind)Kind.Release.INSTANCE : (Intrinsics.areEqual((Object)kindSuffix, (Object)"dev") ? (Kind)Kind.Dev.INSTANCE : (Intrinsics.areEqual((Object)kindSuffix, (Object)"snapshot") || Intrinsics.areEqual((Object)kindSuffix, (Object)"local") ? (Kind)Kind.Snapshot.INSTANCE : (StringsKt.startsWith$default((String)kindSuffix, (String)"rc", (boolean)false, (int)2, null) ? this.parseKind(kindSuffix, "rc", (Function1<? super Integer, ? extends Kind>)((Function1)Companion::parse_IoAF18A$lambda$5)) : (StringsKt.startsWith$default((String)kindSuffix, (String)"beta", (boolean)false, (int)2, null) ? this.parseKind(kindSuffix, "beta", (Function1<? super Integer, ? extends Kind>)((Function1)Companion::parse_IoAF18A$lambda$6)) : (StringsKt.startsWith$default((String)kindSuffix, (String)"m", (boolean)false, (int)2, null) ? this.parseKind(kindSuffix, "m", (Function1<? super Integer, ? extends Kind>)((Function1)Companion::parse_IoAF18A$lambda$7)) : (StringsKt.startsWith$default((String)kindSuffix, (String)"eap", (boolean)false, (int)2, null) ? this.parseKind(kindSuffix, "eap", (Function1<? super Integer, ? extends Kind>)((Function1)Companion::parse_IoAF18A$lambda$8)) : (new Regex("ij\\d+(?:\\.\\d+)?").matches(object = (CharSequence)kindSuffix) ? (Kind)new Kind.ForIde(kindSuffix) : null)))))));
                if (kind3 == null) {
                    return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new IllegalArgumentException("Unsupported version kind suffix: \"" + kindSuffix + "\" (" + rawVersion + ")")));
                }
                kind2 = kind3;
                object = matchResult2.getGroupValues().get(5);
                String it = (String)object;
                boolean bl = false;
                buildNumber = (String)(((CharSequence)it).length() > 0 ? object : null);
                requireBuildNumberForArtifact = !StringsKt.contains$default((CharSequence)kindSuffix, (CharSequence)"release", (boolean)false, (int)2, null) && buildNumber != null;
                LanguageVersion[] $this$firstOrNull$iv = LanguageVersion.values();
                boolean $i$f$firstOrNull = false;
                int n4 = $this$firstOrNull$iv.length;
                for (int j = 0; j < n4; ++j) {
                    LanguageVersion element$iv;
                    LanguageVersion it2 = element$iv = $this$firstOrNull$iv[j];
                    boolean bl2 = false;
                    if (!(it2.getMajor() == majorValue && it2.getMinor() == minorValue)) continue;
                    languageVersion2 = element$iv;
                    break block7;
                }
                languageVersion2 = languageVersion = null;
            }
            if (languageVersion2 == null) {
                languageVersion = LanguageVersion.FIRST_SUPPORTED;
            }
            LanguageVersion languageVersion3 = languageVersion;
            ApiVersion apiVersion = ApiVersion.Companion.createByLanguageVersion(languageVersion3);
            IdeKotlinVersion ideKotlinVersion = new IdeKotlinVersion(rawVersion, kotlinVersion, kind2, requireBuildNumberForArtifact, buildNumber, languageVersion3, apiVersion, null);
            return Result.constructor-impl((Object)ideKotlinVersion);
        }

        private static final Kind parse_IoAF18A$lambda$5(Integer it) {
            return new Kind.ReleaseCandidate(it);
        }

        private static final Kind parse_IoAF18A$lambda$6(Integer it) {
            return new Kind.Beta(it);
        }

        private static final Kind parse_IoAF18A$lambda$7(Integer it) {
            return new Kind.Milestone(it);
        }

        private static final Kind parse_IoAF18A$lambda$8(Integer it) {
            return new Kind.Eap(it);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\b\t\n\u000b\f\r\u000e\u000f\u0010B\u0013\b\u0004\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\u0003H\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\b\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind;", "", "artifactSuffix", "", "<init>", "(Ljava/lang/String;)V", "getArtifactSuffix", "()Ljava/lang/String;", "toString", "Release", "ReleaseCandidate", "Beta", "Milestone", "Eap", "ForIde", "Dev", "Snapshot", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind$Beta;", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind$Dev;", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind$Eap;", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind$ForIde;", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind$Milestone;", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind$Release;", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind$ReleaseCandidate;", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind$Snapshot;", "kotlin.base.plugin"})
    public static abstract class Kind {
        @Nullable
        private final String artifactSuffix;

        private Kind(String artifactSuffix) {
            this.artifactSuffix = artifactSuffix;
        }

        @Nullable
        public final String getArtifactSuffix() {
            return this.artifactSuffix;
        }

        @NotNull
        public String toString() {
            String string = this.getClass().getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
            return string;
        }

        public /* synthetic */ Kind(String artifactSuffix, DefaultConstructorMarker $constructor_marker) {
            this(artifactSuffix);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\n\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind$Beta;", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind;", "number", "", "<init>", "(Ljava/lang/Integer;)V", "getNumber", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "component1", "copy", "(Ljava/lang/Integer;)Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind$Beta;", "equals", "", "other", "", "hashCode", "toString", "", "kotlin.base.plugin"})
        public static final class Beta
        extends Kind {
            @Nullable
            private final Integer number;

            public Beta(@Nullable Integer number) {
                Integer n = number;
                super((String)(n == null ? "Beta" : "Beta" + n), null);
                this.number = number;
            }

            @Nullable
            public final Integer getNumber() {
                return this.number;
            }

            @Nullable
            public final Integer component1() {
                return this.number;
            }

            @NotNull
            public final Beta copy(@Nullable Integer number) {
                return new Beta(number);
            }

            public static /* synthetic */ Beta copy$default(Beta beta, Integer n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = beta.number;
                }
                return beta.copy(n);
            }

            @Override
            @NotNull
            public String toString() {
                return "Beta(number=" + this.number + ")";
            }

            public int hashCode() {
                return this.number == null ? 0 : ((Object)this.number).hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Beta)) {
                    return false;
                }
                Beta beta = (Beta)other;
                return Intrinsics.areEqual((Object)this.number, (Object)beta.number);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind$Dev;", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind;", "<init>", "()V", "kotlin.base.plugin"})
        public static final class Dev
        extends Kind {
            @NotNull
            public static final Dev INSTANCE = new Dev();

            private Dev() {
                super("dev", null);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\n\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind$Eap;", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind;", "number", "", "<init>", "(Ljava/lang/Integer;)V", "getNumber", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "component1", "copy", "(Ljava/lang/Integer;)Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind$Eap;", "equals", "", "other", "", "hashCode", "toString", "", "kotlin.base.plugin"})
        public static final class Eap
        extends Kind {
            @Nullable
            private final Integer number;

            public Eap(@Nullable Integer number) {
                Integer n = number;
                super((String)(n == null ? "eap" : "eap" + n), null);
                this.number = number;
            }

            @Nullable
            public final Integer getNumber() {
                return this.number;
            }

            @Nullable
            public final Integer component1() {
                return this.number;
            }

            @NotNull
            public final Eap copy(@Nullable Integer number) {
                return new Eap(number);
            }

            public static /* synthetic */ Eap copy$default(Eap eap, Integer n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = eap.number;
                }
                return eap.copy(n);
            }

            @Override
            @NotNull
            public String toString() {
                return "Eap(number=" + this.number + ")";
            }

            public int hashCode() {
                return this.number == null ? 0 : ((Object)this.number).hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Eap)) {
                    return false;
                }
                Eap eap = (Eap)other;
                return Intrinsics.areEqual((Object)this.number, (Object)eap.number);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind$ForIde;", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind;", "platform", "", "<init>", "(Ljava/lang/String;)V", "getPlatform", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "kotlin.base.plugin"})
        public static final class ForIde
        extends Kind {
            @NotNull
            private final String platform;

            public ForIde(@NotNull String platform) {
                Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
                super(platform, null);
                this.platform = platform;
            }

            @NotNull
            public final String getPlatform() {
                return this.platform;
            }

            @NotNull
            public final String component1() {
                return this.platform;
            }

            @NotNull
            public final ForIde copy(@NotNull String platform) {
                Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
                return new ForIde(platform);
            }

            public static /* synthetic */ ForIde copy$default(ForIde forIde, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = forIde.platform;
                }
                return forIde.copy(string);
            }

            @Override
            @NotNull
            public String toString() {
                return "ForIde(platform=" + this.platform + ")";
            }

            public int hashCode() {
                return this.platform.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ForIde)) {
                    return false;
                }
                ForIde forIde = (ForIde)other;
                return Intrinsics.areEqual((Object)this.platform, (Object)forIde.platform);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\n\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind$Milestone;", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind;", "number", "", "<init>", "(Ljava/lang/Integer;)V", "getNumber", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "component1", "copy", "(Ljava/lang/Integer;)Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind$Milestone;", "equals", "", "other", "", "hashCode", "toString", "", "kotlin.base.plugin"})
        public static final class Milestone
        extends Kind {
            @Nullable
            private final Integer number;

            public Milestone(@Nullable Integer number) {
                Integer n = number;
                super((String)(n == null ? "M1" : "M" + n), null);
                this.number = number;
            }

            @Nullable
            public final Integer getNumber() {
                return this.number;
            }

            @Nullable
            public final Integer component1() {
                return this.number;
            }

            @NotNull
            public final Milestone copy(@Nullable Integer number) {
                return new Milestone(number);
            }

            public static /* synthetic */ Milestone copy$default(Milestone milestone, Integer n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = milestone.number;
                }
                return milestone.copy(n);
            }

            @Override
            @NotNull
            public String toString() {
                return "Milestone(number=" + this.number + ")";
            }

            public int hashCode() {
                return this.number == null ? 0 : ((Object)this.number).hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Milestone)) {
                    return false;
                }
                Milestone milestone = (Milestone)other;
                return Intrinsics.areEqual((Object)this.number, (Object)milestone.number);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind$Release;", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind;", "<init>", "()V", "kotlin.base.plugin"})
        public static final class Release
        extends Kind {
            @NotNull
            public static final Release INSTANCE = new Release();

            private Release() {
                super(null, null);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\n\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind$ReleaseCandidate;", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind;", "number", "", "<init>", "(Ljava/lang/Integer;)V", "getNumber", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "component1", "copy", "(Ljava/lang/Integer;)Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind$ReleaseCandidate;", "equals", "", "other", "", "hashCode", "toString", "", "kotlin.base.plugin"})
        public static final class ReleaseCandidate
        extends Kind {
            @Nullable
            private final Integer number;

            public ReleaseCandidate(@Nullable Integer number) {
                Integer n = number;
                super((String)(n == null ? "RC" : "RC" + n), null);
                this.number = number;
            }

            @Nullable
            public final Integer getNumber() {
                return this.number;
            }

            @Nullable
            public final Integer component1() {
                return this.number;
            }

            @NotNull
            public final ReleaseCandidate copy(@Nullable Integer number) {
                return new ReleaseCandidate(number);
            }

            public static /* synthetic */ ReleaseCandidate copy$default(ReleaseCandidate releaseCandidate, Integer n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = releaseCandidate.number;
                }
                return releaseCandidate.copy(n);
            }

            @Override
            @NotNull
            public String toString() {
                return "ReleaseCandidate(number=" + this.number + ")";
            }

            public int hashCode() {
                return this.number == null ? 0 : ((Object)this.number).hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ReleaseCandidate)) {
                    return false;
                }
                ReleaseCandidate releaseCandidate = (ReleaseCandidate)other;
                return Intrinsics.areEqual((Object)this.number, (Object)releaseCandidate.number);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind$Snapshot;", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion$Kind;", "<init>", "()V", "kotlin.base.plugin"})
        public static final class Snapshot
        extends Kind {
            @NotNull
            public static final Snapshot INSTANCE = new Snapshot();

            private Snapshot() {
                super("SNAPSHOT", null);
            }
        }
    }
}

