/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate.classLoading;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.base.util.evaluate.BaseExecutionContext;
import org.jetbrains.kotlin.idea.debugger.base.util.evaluate.ExecutionContext;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.AndroidDexer;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.ClassLoadingAdapter;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.ClassToLoad;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0004J$\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0004\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/AbstractAndroidClassLoadingAdapter;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/ClassLoadingAdapter;", "<init>", "()V", "dex", "", "context", "Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/ExecutionContext;", "classes", "", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/ClassToLoad;", "wrapToByteBuffer", "Lcom/sun/jdi/ObjectReference;", "bytes", "Lcom/sun/jdi/ArrayReference;", "tryLoadClass", "Lcom/sun/jdi/ReferenceType;", "fqName", "", "classLoader", "Lcom/sun/jdi/ClassLoaderReference;", "kotlin.jvm-debugger.evaluation"})
public abstract class AbstractAndroidClassLoadingAdapter
implements ClassLoadingAdapter {
    @Nullable
    protected final byte[] dex(@NotNull ExecutionContext context, @NotNull Collection<ClassToLoad> classes) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(classes, (String)"classes");
        return ((AndroidDexer)CollectionsKt.single((List)AndroidDexer.Companion.getInstances(context.getProject()))).dex(classes);
    }

    @NotNull
    protected final ObjectReference wrapToByteBuffer(@NotNull ArrayReference bytes, @NotNull ExecutionContext context) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ClassLoaderReference classLoader = context.getClassLoader();
        ReferenceType referenceType = context.findClass("java.nio.ByteBuffer", classLoader);
        Intrinsics.checkNotNull((Object)referenceType, (String)"null cannot be cast to non-null type com.sun.jdi.ClassType");
        ClassType byteBufferClass = (ClassType)referenceType;
        Method method = byteBufferClass.concreteMethodByName("wrap", "([B)Ljava/nio/ByteBuffer;");
        if (method == null) {
            throw new IllegalStateException("'wrap' method not found".toString());
        }
        Method wrapMethod = method;
        Value value = BaseExecutionContext.invokeMethod$default(context, byteBufferClass, wrapMethod, CollectionsKt.listOf((Object)bytes), false, 8, null);
        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.sun.jdi.ObjectReference");
        return (ObjectReference)value;
    }

    @Nullable
    protected final ReferenceType tryLoadClass(@NotNull ExecutionContext context, @NotNull String fqName2, @Nullable ClassLoaderReference classLoader) {
        ReferenceType referenceType;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        try {
            referenceType = context.getDebugProcess().loadClass(context.getEvaluationContext(), fqName2, classLoader);
        }
        catch (Throwable e) {
            referenceType = null;
        }
        return referenceType;
    }
}

