/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractApplicabilityBasedInspection;
import org.jetbrains.kotlin.idea.util.ExpectActualUtilKt;
import org.jetbrains.kotlin.idea.util.ExpressionExtKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.util.OperatorChecks;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016R\u0014\u0010\n\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/AddOperatorModifierInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractApplicabilityBasedInspection;", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "<init>", "()V", "inspectionHighlightRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "element", "inspectionText", "", "defaultFixText", "getDefaultFixText", "()Ljava/lang/String;", "isApplicable", "", "applyTo", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "kotlin.idea"})
public final class AddOperatorModifierInspection
extends AbstractApplicabilityBasedInspection<KtNamedFunction> {
    public AddOperatorModifierInspection() {
        super(KtNamedFunction.class);
    }

    @Override
    @Nullable
    public TextRange inspectionHighlightRangeInElement(@NotNull KtNamedFunction element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return ExpressionExtKt.nameIdentifierTextRangeInThis((KtNamedDeclaration)element);
    }

    @Override
    @NotNull
    public String inspectionText(@NotNull KtNamedFunction element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return KotlinBundle.message((String)"function.should.have.operator.modifier", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public String getDefaultFixText() {
        return KotlinBundle.message((String)"add.operator.modifier", (Object[])new Object[0]);
    }

    @Override
    public boolean isApplicable(@NotNull KtNamedFunction element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element.getNameIdentifier() == null || element.hasModifier(KtTokens.OPERATOR_KEYWORD)) {
            return false;
        }
        FunctionDescriptor functionDescriptor = ResolutionUtils.resolveToDescriptorIfAny$default(element, null, 1, null);
        if (functionDescriptor == null) {
            return false;
        }
        FunctionDescriptor functionDescriptor2 = functionDescriptor;
        return !functionDescriptor2.isOperator() && OperatorChecks.INSTANCE.check(functionDescriptor2).isSuccess();
    }

    @Override
    public void applyTo(@NotNull KtNamedFunction element, @NotNull Project project, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        List<KtDeclaration> declarations2 = ExpectActualUtilKt.withExpectedActuals((KtDeclaration)element);
        ActionsKt.runWriteAction(() -> AddOperatorModifierInspection.applyTo$lambda$0(declarations2));
    }

    private static final Unit applyTo$lambda$0(List $declarations) {
        for (KtDeclaration declaration : $declarations) {
            declaration.addModifier(KtTokens.OPERATOR_KEYWORD);
        }
        return Unit.INSTANCE;
    }
}

