/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.junit;

import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitConfigurationProducer;
import com.intellij.execution.junit.JUnitConfigurationType;
import com.intellij.execution.junit.PatternConfigurationProducer;
import com.intellij.execution.junit.TestObject;
import com.intellij.execution.junit.UniqueIdConfigurationProducer;
import com.intellij.execution.testframework.AbstractInClassConfigurationProducer;
import com.intellij.execution.testframework.AbstractPatternBasedConfigurationProducer;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.facet.KotlinFacetUtils;
import org.jetbrains.kotlin.idea.base.facet.platform.TargetPlatformDetectorUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.RootKindFilter;
import org.jetbrains.kotlin.idea.base.projectStructure.SourceKindFilterUtils;
import org.jetbrains.kotlin.idea.extensions.KotlinTestFrameworkProvider;
import org.jetbrains.kotlin.idea.junit.JunitKotlinTestFrameworkProvider;
import org.jetbrains.kotlin.idea.junit.KotlinJUnitBundle;
import org.jetbrains.kotlin.idea.run.KotlinRunConfigurationMultiplatformUtils;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0002J&\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/junit/KotlinJUnitRunConfigurationProducer;", "Lcom/intellij/execution/actions/LazyRunConfigurationProducer;", "Lcom/intellij/execution/junit/JUnitConfiguration;", "<init>", "()V", "getConfigurationFactory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "shouldReplace", "", "self", "Lcom/intellij/execution/actions/ConfigurationFromContext;", "other", "isAvailableInMpp", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "isConfigurationFromContext", "configuration", "settingsMatchTemplate", "setupConfigurationFromContext", "sourceElement", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/psi/PsiElement;", "onFirstRun", "", "fromContext", "performRunnable", "Ljava/lang/Runnable;", "createDelegatingContextWithLightElement", "lightElement", "Lcom/intellij/psi/PsiMember;", "kotlin.run-configurations.junit"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nKotlinJUnitRunConfigurationProducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinJUnitRunConfigurationProducer.kt\norg/jetbrains/kotlin/idea/junit/KotlinJUnitRunConfigurationProducer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,163:1\n1#2:164\n*E\n"})
public final class KotlinJUnitRunConfigurationProducer
extends LazyRunConfigurationProducer<JUnitConfiguration> {
    private KotlinJUnitRunConfigurationProducer() {
    }

    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        ConfigurationFactory configurationFactory = JUnitConfigurationType.getInstance().getConfigurationFactories()[0];
        Intrinsics.checkNotNullExpressionValue((Object)configurationFactory, (String)"get(...)");
        return configurationFactory;
    }

    public boolean shouldReplace(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return other.isProducedBy(JUnitConfigurationProducer.class) || other.isProducedBy(AbstractPatternBasedConfigurationProducer.class);
    }

    private final boolean isAvailableInMpp(ConfigurationContext context) {
        Module module = context.getModule();
        return module == null || !KotlinFacetUtils.isNewMultiPlatformModule(module) || !KotlinRunConfigurationMultiplatformUtils.forceGradleRunnerInMPP();
    }

    public boolean isConfigurationFromContext(@NotNull JUnitConfiguration configuration2, @NotNull ConfigurationContext context) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (((PatternConfigurationProducer)RunConfigurationProducer.getInstance(PatternConfigurationProducer.class)).isMultipleElementsSelected(context) || !this.isAvailableInMpp(context)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)"class", (Object)configuration2.getTestType()) && !Intrinsics.areEqual((Object)"method", (Object)configuration2.getTestType())) {
            return false;
        }
        Location location = context.getLocation();
        if (location == null || (location = location.getPsiElement()) == null) {
            return false;
        }
        Location element = location;
        KotlinTestFrameworkProvider.JavaEntity javaEntity = JunitKotlinTestFrameworkProvider.Companion.getInstance().getJavaEntity((PsiElement)element);
        if (javaEntity == null) {
            return false;
        }
        KotlinTestFrameworkProvider.JavaEntity javaEntity2 = javaEntity;
        TestObject testObject = configuration2.getTestObject();
        if (!testObject.isConfiguredByElement(configuration2, javaEntity2.getTestClass(), javaEntity2.getMethod(), null, null)) {
            return false;
        }
        String[] nodeIds = UniqueIdConfigurationProducer.getNodeIds((ConfigurationContext)context);
        String[] stringArray = nodeIds;
        if (!(stringArray == null || stringArray.length == 0)) {
            return false;
        }
        return this.settingsMatchTemplate(configuration2, context);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean settingsMatchTemplate(JUnitConfiguration configuration2, ConfigurationContext context) {
        Object object;
        Module configurationModule;
        String vmParameters;
        RunConfiguration predefinedConfiguration = context.getOriginalConfiguration((ConfigurationType)JUnitConfigurationType.getInstance());
        CommonJavaRunConfigurationParameters commonJavaRunConfigurationParameters = predefinedConfiguration instanceof CommonJavaRunConfigurationParameters ? (CommonJavaRunConfigurationParameters)predefinedConfiguration : null;
        String string = vmParameters = commonJavaRunConfigurationParameters != null ? commonJavaRunConfigurationParameters.getVMParameters() : null;
        if (vmParameters != null && !Intrinsics.areEqual((Object)configuration2.getVMParameters(), (Object)vmParameters)) {
            return false;
        }
        Project project = configuration2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        RunnerAndConfigurationSettings template2 = RunManager.Companion.getInstance(project).getConfigurationTemplate(this.getConfigurationFactory());
        RunConfiguration runConfiguration = template2.getConfiguration();
        Intrinsics.checkNotNull((Object)runConfiguration, (String)"null cannot be cast to non-null type com.intellij.execution.configurations.ModuleBasedConfiguration<*, *>");
        Module predefinedModule = ((ModuleBasedConfiguration)runConfiguration).getConfigurationModule().getModule();
        Module module = configurationModule = ((JavaRunConfigurationModule)configuration2.getConfigurationModule()).getModule();
        Location location = context.getLocation();
        if (location != null && (location = location.getModule()) != null) {
            void it;
            Location location2;
            Location location3 = location2 = location;
            Module module2 = module;
            boolean bl = false;
            boolean bl2 = JvmPlatformKt.isJvm((TargetPlatform)TargetPlatformDetectorUtils.getPlatform((Module)it));
            module = module2;
            object = bl2 ? location2 : null;
        } else {
            object = null;
        }
        return Intrinsics.areEqual((Object)module, object) || Intrinsics.areEqual((Object)configurationModule, (Object)predefinedModule);
    }

    public boolean setupConfigurationFromContext(@NotNull JUnitConfiguration configuration2, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        PsiElement element;
        Location location;
        block12: {
            block11: {
                Module module;
                Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter(sourceElement, (String)"sourceElement");
                Project project = context.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                if (DumbService.Companion.getInstance(project).isDumb()) {
                    return false;
                }
                if (((PatternConfigurationProducer)RunConfigurationProducer.getInstance(PatternConfigurationProducer.class)).isMultipleElementsSelected(context) || !this.isAvailableInMpp(context)) {
                    return false;
                }
                Location location2 = context.getLocation();
                if (location2 == null) {
                    return false;
                }
                location = location2;
                PsiElement psiElement = location.getPsiElement();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsiElement(...)");
                element = psiElement;
                Object object = context.getModule();
                if (object == null) break block11;
                Module it = module = object;
                boolean bl = false;
                object = JvmPlatformKt.isJvm((TargetPlatform)TargetPlatformDetectorUtils.getPlatform(it)) ? module : null;
                if (object != null) break block12;
            }
            return false;
        }
        if (!SourceKindFilterUtils.matches(RootKindFilter.projectAndLibrarySources, element) || !(element.getContainingFile() instanceof KtFile)) {
            return false;
        }
        String[] nodeIds = UniqueIdConfigurationProducer.getNodeIds((ConfigurationContext)context);
        String[] stringArray = nodeIds;
        if (!(stringArray == null || stringArray.length == 0)) {
            return false;
        }
        KotlinTestFrameworkProvider.JavaTestEntity javaTestEntity = JunitKotlinTestFrameworkProvider.Companion.getInstance().getJavaTestEntity(element, true);
        if (javaTestEntity == null) {
            return false;
        }
        KotlinTestFrameworkProvider.JavaTestEntity testEntity = javaTestEntity;
        Module originalModule = ((JavaRunConfigurationModule)configuration2.getConfigurationModule()).getModule();
        PsiMethod testMethod = testEntity.getTestMethod();
        if (testMethod != null) {
            configuration2.beMethodConfiguration(PsiLocation.fromPsiElement((PsiElement)((PsiElement)testMethod)));
        } else {
            configuration2.beClassConfiguration(testEntity.getTestClass());
        }
        configuration2.restoreOriginalModule(originalModule);
        JavaRunConfigurationExtensionManager.Companion.getInstance().extendCreatedConfiguration((RunConfigurationBase)configuration2, location);
        return true;
    }

    public void onFirstRun(@NotNull ConfigurationFromContext fromContext, @NotNull ConfigurationContext context, @NotNull Runnable performRunnable) {
        Intrinsics.checkNotNullParameter((Object)fromContext, (String)"fromContext");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)performRunnable, (String)"performRunnable");
        KotlinTestFrameworkProvider.JavaTestEntity javaTestEntity = (KotlinTestFrameworkProvider.JavaTestEntity)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> KotlinJUnitRunConfigurationProducer.onFirstRun$lambda$3(fromContext), KotlinJUnitBundle.message("progress.text.detect.test.framework", new Object[0]), true, context.getProject());
        if (javaTestEntity == null) {
            super.onFirstRun(fromContext, context, performRunnable);
            return;
        }
        KotlinTestFrameworkProvider.JavaTestEntity testEntity = javaTestEntity;
        PsiMethod psiMethod = testEntity.getTestMethod();
        if (psiMethod == null) {
            psiMethod = testEntity.getTestClass();
        }
        PsiMethod sourceElement = psiMethod;
        ConfigurationFromContext contextWithLightElement = this.createDelegatingContextWithLightElement(fromContext, (PsiMember)sourceElement);
        new AbstractInClassConfigurationProducer<JUnitConfiguration>(){

            public ConfigurationFactory getConfigurationFactory() {
                ConfigurationFactory configurationFactory = JUnitConfigurationType.getInstance().getFactory();
                Intrinsics.checkNotNullExpressionValue((Object)configurationFactory, (String)"getFactory(...)");
                return configurationFactory;
            }
        }.onFirstRun(contextWithLightElement, context, performRunnable);
    }

    private final ConfigurationFromContext createDelegatingContextWithLightElement(ConfigurationFromContext fromContext, PsiMember lightElement) {
        return new ConfigurationFromContext(fromContext, lightElement){
            final /* synthetic */ ConfigurationFromContext $fromContext;
            final /* synthetic */ PsiMember $lightElement;
            {
                this.$fromContext = $fromContext;
                this.$lightElement = $lightElement;
            }

            public RunnerAndConfigurationSettings getConfigurationSettings() {
                RunnerAndConfigurationSettings runnerAndConfigurationSettings = this.$fromContext.getConfigurationSettings();
                Intrinsics.checkNotNullExpressionValue((Object)runnerAndConfigurationSettings, (String)"getConfigurationSettings(...)");
                return runnerAndConfigurationSettings;
            }

            public void setConfigurationSettings(RunnerAndConfigurationSettings configurationSettings) {
                Intrinsics.checkNotNullParameter((Object)configurationSettings, (String)"configurationSettings");
                this.$fromContext.setConfigurationSettings(configurationSettings);
            }

            public PsiMember getSourceElement() {
                return this.$lightElement;
            }
        };
    }

    private static final KotlinTestFrameworkProvider.JavaTestEntity onFirstRun$lambda$3$lambda$2(ConfigurationFromContext $fromContext) {
        JunitKotlinTestFrameworkProvider junitKotlinTestFrameworkProvider = JunitKotlinTestFrameworkProvider.Companion.getInstance();
        PsiElement psiElement = $fromContext.getSourceElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getSourceElement(...)");
        return junitKotlinTestFrameworkProvider.getJavaTestEntity(psiElement, true);
    }

    private static final KotlinTestFrameworkProvider.JavaTestEntity onFirstRun$lambda$3(ConfigurationFromContext $fromContext) {
        return (KotlinTestFrameworkProvider.JavaTestEntity)ActionsKt.runReadAction(() -> KotlinJUnitRunConfigurationProducer.onFirstRun$lambda$3$lambda$2($fromContext));
    }
}

