/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.jvm.shared.scratch.ui;

import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\bH\u0016J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\r\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ui/ScratchEditorsState;", "Lcom/intellij/openapi/editor/ex/FocusChangeListener;", "sourceEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "previewEditor", "<init>", "(Lcom/intellij/openapi/editor/ex/EditorEx;Lcom/intellij/openapi/editor/ex/EditorEx;)V", "lastFocusedEditor", "Lcom/intellij/openapi/editor/Editor;", "sourceEditorCaretLine", "", "getSourceEditorCaretLine", "()Ljava/lang/Integer;", "previewEditorCaretLine", "getPreviewEditorCaretLine", "focusedEditor", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ui/ScratchEditorsState$FocusedEditor;", "getFocusedEditor", "()Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ui/ScratchEditorsState$FocusedEditor;", "focusLost", "", "editor", "focusGained", "FocusedEditor", "kotlin.jvm.shared"})
final class ScratchEditorsState
implements FocusChangeListener {
    @NotNull
    private final EditorEx sourceEditor;
    @NotNull
    private final EditorEx previewEditor;
    @NotNull
    private Editor lastFocusedEditor;

    public ScratchEditorsState(@NotNull EditorEx sourceEditor, @NotNull EditorEx previewEditor) {
        Intrinsics.checkNotNullParameter((Object)sourceEditor, (String)"sourceEditor");
        Intrinsics.checkNotNullParameter((Object)previewEditor, (String)"previewEditor");
        this.sourceEditor = sourceEditor;
        this.previewEditor = previewEditor;
        this.lastFocusedEditor = (Editor)this.sourceEditor;
        this.sourceEditor.addFocusListener((FocusChangeListener)this);
        this.previewEditor.addFocusListener((FocusChangeListener)this);
    }

    @Nullable
    public final Integer getSourceEditorCaretLine() {
        List list2 = this.sourceEditor.getCaretModel().getAllCarets();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAllCarets(...)");
        Caret caret = (Caret)CollectionsKt.singleOrNull((List)list2);
        return caret != null && (caret = caret.getLogicalPosition()) != null ? Integer.valueOf(caret.line) : null;
    }

    @Nullable
    public final Integer getPreviewEditorCaretLine() {
        List list2 = this.previewEditor.getCaretModel().getAllCarets();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAllCarets(...)");
        Caret caret = (Caret)CollectionsKt.singleOrNull((List)list2);
        return caret != null && (caret = caret.getLogicalPosition()) != null ? Integer.valueOf(caret.line) : null;
    }

    @NotNull
    public final FocusedEditor getFocusedEditor() {
        return this.lastFocusedEditor == this.sourceEditor ? FocusedEditor.SOURCE : FocusedEditor.PREVIEW;
    }

    public void focusLost(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
    }

    public void focusGained(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.lastFocusedEditor = editor;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ui/ScratchEditorsState$FocusedEditor;", "", "<init>", "(Ljava/lang/String;I)V", "SOURCE", "PREVIEW", "kotlin.jvm.shared"})
    public static final class FocusedEditor
    extends Enum<FocusedEditor> {
        public static final /* enum */ FocusedEditor SOURCE = new FocusedEditor();
        public static final /* enum */ FocusedEditor PREVIEW = new FocusedEditor();
        private static final /* synthetic */ FocusedEditor[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static FocusedEditor[] values() {
            return (FocusedEditor[])$VALUES.clone();
        }

        public static FocusedEditor valueOf(String value) {
            return Enum.valueOf(FocusedEditor.class, value);
        }

        @NotNull
        public static EnumEntries<FocusedEditor> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = focusedEditorArray = new FocusedEditor[]{FocusedEditor.SOURCE, FocusedEditor.PREVIEW};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

