/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinPluginLayout;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0012H\u0016J\r\u0010\u0013\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0014H\u0016J#\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0003\u001a\u00020\u0002H\u0094\u0002J\"\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0003\u001a\u00020\u0002H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\n\u001a\u0004\u0018\u00010\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddModuleOptInFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtFile;", "file", "module", "Lcom/intellij/openapi/module/Module;", "annotationFqName", "Lorg/jetbrains/kotlin/name/FqName;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtFile;Lcom/intellij/openapi/module/Module;Lorg/jetbrains/kotlin/name/FqName;)V", "configurator", "Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurator;", "getConfigurator", "()Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurator;", "configurator$delegate", "Lkotlin/Lazy;", "getText", "", "Lcom/intellij/codeInspection/util/IntentionName;", "getFamilyName", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isAvailable", "", "kotlin.fir.frontend-independent"})
@SourceDebugExtension(value={"SMAP\nAddModuleOptInFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddModuleOptInFix.kt\norg/jetbrains/kotlin/idea/quickfix/AddModuleOptInFix\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,67:1\n183#2,2:68\n*S KotlinDebug\n*F\n+ 1 AddModuleOptInFix.kt\norg/jetbrains/kotlin/idea/quickfix/AddModuleOptInFix\n*L\n29#1:68,2\n*E\n"})
public final class AddModuleOptInFix
extends KotlinQuickFixAction<KtFile> {
    @NotNull
    private final Module module;
    @NotNull
    private final FqName annotationFqName;
    @NotNull
    private final Lazy configurator$delegate;

    public AddModuleOptInFix(@NotNull KtFile file, @NotNull Module module, @NotNull FqName annotationFqName) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)annotationFqName, (String)"annotationFqName");
        super((PsiElement)file);
        this.module = module;
        this.annotationFqName = annotationFqName;
        this.configurator$delegate = LazyKt.lazy(() -> AddModuleOptInFix.configurator_delegate$lambda$2(this));
    }

    private final KotlinProjectConfigurator getConfigurator() {
        Lazy lazy = this.configurator$delegate;
        return (KotlinProjectConfigurator)lazy.getValue();
    }

    @NotNull
    public String getText() {
        Object[] objectArray = new Object[2];
        Intrinsics.checkNotNullExpressionValue((Object)this.annotationFqName.shortName().asString(), (String)"asString(...)");
        Object object = this.getConfigurator();
        if (object == null || (object = object.userVisibleNameFor(this.module)) == null) {
            String string = this.module.getName();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        }
        objectArray[1] = object;
        return KotlinBundle.message((String)"fix.opt_in.text.use.module", (Object[])objectArray);
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"add.an.opt.in.requirement.marker.compiler.argument", (Object[])new Object[0]);
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            String optInPrefix = KotlinPluginLayout.getStandaloneCompilerVersion().getKotlinVersion().isAtLeast(1, 6, 0) ? "" : "X";
            KotlinProjectConfigurator kotlinProjectConfigurator = this.getConfigurator();
            if (kotlinProjectConfigurator == null) break block0;
            kotlinProjectConfigurator.addModuleWideOptIn(this.module, this.annotationFqName, "-" + optInPrefix + "opt-in=" + this.annotationFqName);
        }
    }

    @Override
    protected boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.getConfigurator() != null;
    }

    private static final boolean configurator_delegate$lambda$2$lambda$0(KotlinProjectConfigurator it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getCanAddModuleWideOptIn();
    }

    private static final KotlinProjectConfigurator configurator_delegate$lambda$2(AddModuleOptInFix this$0) {
        Object v0;
        block1: {
            Sequence $this$firstOrNull$iv = SequencesKt.filter((Sequence)KotlinProjectConfigurator.Companion.getEP_NAME().lazySequence(), AddModuleOptInFix::configurator_delegate$lambda$2$lambda$0);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KotlinProjectConfigurator it = (KotlinProjectConfigurator)element$iv;
                boolean bl = false;
                if (!it.isApplicable(this$0.module)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }
}

