/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.search.ideaExtensions;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.util.Processor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.idea.search.KotlinSearchUsagesSupport;
import org.jetbrains.kotlin.psi.KtDeclaration;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a.\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0006\b\u0000\u0012\u00020\n0\t\u001a\u001a\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a8\u0006\r"}, d2={"findOverridingMethodsInKotlin", "", "parentClass", "Lcom/intellij/psi/PsiClass;", "baseElement", "Lcom/intellij/psi/PsiNamedElement;", "parameters", "Lcom/intellij/psi/search/searches/OverridingMethodsSearch$SearchParameters;", "consumer", "Lcom/intellij/util/Processor;", "Lcom/intellij/psi/PsiMethod;", "findOverridingMethod", "inheritor", "kotlin.base.analysis"})
public final class InternalSearchUtilsKt {
    public static final boolean findOverridingMethodsInKotlin(@NotNull PsiClass parentClass, @NotNull PsiNamedElement baseElement, @NotNull OverridingMethodsSearch.SearchParameters parameters2, @NotNull Processor<? super PsiMethod> consumer) {
        Intrinsics.checkNotNullParameter((Object)parentClass, (String)"parentClass");
        Intrinsics.checkNotNullParameter((Object)baseElement, (String)"baseElement");
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        return ClassInheritorsSearch.search((PsiClass)parentClass, (SearchScope)parameters2.getScope(), (boolean)true).forEach(arg_0 -> InternalSearchUtilsKt.findOverridingMethodsInKotlin$lambda$1(consumer, parameters2, baseElement, arg_0));
    }

    private static final PsiMethod findOverridingMethod(PsiClass inheritor, PsiNamedElement baseElement) {
        if (!(inheritor instanceof KtLightClass)) {
            return null;
        }
        String name2 = baseElement.getName();
        PsiMethod[] psiMethodArray = inheritor.findMethodsByName(name2, false);
        Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"findMethodsByName(...)");
        for (PsiMethod lightMethodCandidate : psiMethodArray) {
            KtLightMethod ktLightMethod = lightMethodCandidate instanceof KtLightMethod ? (KtLightMethod)lightMethodCandidate : null;
            if (ktLightMethod == null || (ktLightMethod = (KtDeclaration)ktLightMethod.getKotlinOrigin()) == null) continue;
            KtLightMethod kotlinOrigin = ktLightMethod;
            Project project = ((KtLightClass)inheritor).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            if (!KotlinSearchUsagesSupport.Companion.getInstance(project).isCallableOverride((KtDeclaration)kotlinOrigin, baseElement)) continue;
            return lightMethodCandidate;
        }
        return null;
    }

    private static final PsiMethod findOverridingMethodsInKotlin$lambda$1$lambda$0(PsiClass $inheritor, PsiNamedElement $baseElement) {
        return InternalSearchUtilsKt.findOverridingMethod($inheritor, $baseElement);
    }

    private static final boolean findOverridingMethodsInKotlin$lambda$1(Processor $consumer, OverridingMethodsSearch.SearchParameters $parameters, PsiNamedElement $baseElement, PsiClass inheritor) {
        Intrinsics.checkNotNullParameter((Object)inheritor, (String)"inheritor");
        PsiMethod found = (PsiMethod)ActionsKt.runReadAction(() -> InternalSearchUtilsKt.findOverridingMethodsInKotlin$lambda$1$lambda$0(inheritor, $baseElement));
        return found == null || $consumer.process((Object)found) && $parameters.isCheckDeep();
    }
}

