/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.search.refIndex;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IntellijInternalApi;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.PersistentMapBuilder;
import com.intellij.util.io.externalizer.StringCollectionExternalizer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.search.refIndex.ClassOneToManyStorage;
import org.jetbrains.kotlin.name.FqName;

@IntellijInternalApi
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\f\u001a\u00020\rJ\u001c\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\nJ\u001f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u000f\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0086\u0002J\u001f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u00122\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0086\u0002R;\u0010\u0006\u001a/\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\b \t*\n\u0012\u0004\u0012\u00020\b\u0018\u00010\n0\n0\u0007\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/search/refIndex/ClassOneToManyStorage;", "", "storagePath", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "storage", "Lcom/intellij/util/io/PersistentHashMap;", "", "kotlin.jvm.PlatformType", "", "Lorg/jetbrains/annotations/NotNull;", "closeAndClean", "", "put", "key", "values", "get", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/name/FqName;", "deep", "", "Companion", "kotlin.compiler-reference-index"})
@SourceDebugExtension(value={"SMAP\nClassOneToManyStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassOneToManyStorage.kt\norg/jetbrains/kotlin/idea/search/refIndex/ClassOneToManyStorage\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,53:1\n195#2:54\n1869#3,2:55\n14#4:57\n*S KotlinDebug\n*F\n+ 1 ClassOneToManyStorage.kt\norg/jetbrains/kotlin/idea/search/refIndex/ClassOneToManyStorage\n*L\n21#1:54\n22#1:55,2\n51#1:57\n*E\n"})
public final class ClassOneToManyStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PersistentHashMap<String, Collection<String>> storage;
    @NotNull
    private static final StringCollectionExternalizer<Collection<String>> externalizer = new StringCollectionExternalizer(ArrayList::new);
    @NotNull
    private static final Logger LOG;

    public ClassOneToManyStorage(@NotNull Path storagePath) {
        Intrinsics.checkNotNullParameter((Object)storagePath, (String)"storagePath");
        String storageName = PathsKt.getName((Path)storagePath);
        Path path2 = storagePath.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getParent(...)");
        Collection $this$ifNotEmpty$iv = PathsKt.listDirectoryEntries((Path)path2, (String)(storageName + "*"));
        boolean $i$f$ifNotEmpty = false;
        if (!$this$ifNotEmpty$iv.isEmpty()) {
            List $this$_init__u24lambda_u241 = (List)$this$ifNotEmpty$iv;
            boolean bl = false;
            Iterable $this$forEach$iv = $this$_init__u24lambda_u241;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Path it = (Path)element$iv;
                boolean bl2 = false;
                Files.deleteIfExists(it);
            }
            LOG.warn("'" + storageName + "' was deleted");
        }
        PersistentHashMap persistentHashMap = PersistentMapBuilder.newBuilder((Path)storagePath, (KeyDescriptor)((KeyDescriptor)EnumeratorStringDescriptor.INSTANCE), (DataExternalizer)((DataExternalizer)externalizer)).build();
        Intrinsics.checkNotNullExpressionValue((Object)persistentHashMap, (String)"build(...)");
        this.storage = persistentHashMap;
    }

    public final void closeAndClean() {
        this.storage.closeAndClean();
    }

    public final void put(@NotNull String key, @NotNull Collection<String> values2) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(values2, (String)"values");
        this.storage.put((Object)key, values2);
    }

    @NotNull
    public final Sequence<FqName> get(@NotNull FqName key, boolean deep) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return SequencesKt.map(this.get(key.asString(), deep), (Function1)get.1.INSTANCE);
    }

    @NotNull
    public final Sequence<String> get(@NotNull String key, boolean deep) {
        Collection values2;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Collection collection = (Collection)this.storage.get((Object)key);
        if (collection == null || (collection = CollectionsKt.asSequence((Iterable)collection)) == null) {
            collection = values2 = SequencesKt.emptySequence();
        }
        if (!deep) {
            return values2;
        }
        return UtilKt.generateRecursiveSequence((Sequence)values2, arg_0 -> ClassOneToManyStorage.get$lambda$2(this, arg_0));
    }

    private static final Sequence get$lambda$2(ClassOneToManyStorage this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Collection collection = (Collection)this$0.storage.get((Object)it);
        if (collection == null || (collection = CollectionsKt.asSequence((Iterable)collection)) == null) {
            collection = SequencesKt.emptySequence();
        }
        return collection;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ClassOneToManyStorage.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/search/refIndex/ClassOneToManyStorage$Companion;", "", "<init>", "()V", "externalizer", "Lcom/intellij/util/io/externalizer/StringCollectionExternalizer;", "", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "kotlin.compiler-reference-index"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

