/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.stubindex;

import com.intellij.find.ngrams.TrigramIndex;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.util.ThreeState;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.hints.BaseFileTypeInputFilter;
import com.intellij.util.indexing.hints.BaseGlobalFileTypeInputFilter;
import com.intellij.util.indexing.hints.FileTypeSubstitutionStrategy;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.base.projectStructure.forwardDeclarations.KotlinForwardDeclarationsFileSystem;
import org.jetbrains.kotlin.idea.stubindex.KotlinNonSourceRootIndexFilter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tH\u0014J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00052\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/stubindex/KotlinNonSourceRootIndexFilter;", "Lcom/intellij/util/indexing/hints/BaseGlobalFileTypeInputFilter;", "<init>", "()V", "enabled", "", "getFileTypeHintForAffectedIndex", "Lcom/intellij/util/indexing/hints/BaseFileTypeInputFilter;", "indexId", "Lcom/intellij/util/indexing/IndexId;", "getVersion", "", "affectsIndex", "kotlin.core"})
public final class KotlinNonSourceRootIndexFilter
extends BaseGlobalFileTypeInputFilter {
    private final boolean enabled = !Boolean.parseBoolean(System.getProperty("kotlin.index.non.source.roots", "false"));

    public KotlinNonSourceRootIndexFilter() {
        super(false, 1, null);
    }

    @NotNull
    protected BaseFileTypeInputFilter getFileTypeHintForAffectedIndex(@NotNull IndexId<?, ?> indexId) {
        Intrinsics.checkNotNullParameter(indexId, (String)"indexId");
        FileTypeSubstitutionStrategy fileTypeSubstitutionStrategy = FileTypeSubstitutionStrategy.BEFORE_SUBSTITUTION;
        return new BaseFileTypeInputFilter(indexId, fileTypeSubstitutionStrategy){
            final /* synthetic */ IndexId<?, ?> $indexId;
            {
                this.$indexId = $indexId;
                super($super_call_param$1);
            }

            public ThreeState acceptFileType(FileType fileType) {
                Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
                return Intrinsics.areEqual((Object)fileType, (Object)KotlinFileType.INSTANCE) ? ThreeState.UNSURE : ThreeState.YES;
            }

            public boolean slowPathIfFileTypeHintUnsure(IndexedFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                VirtualFile virtualFile = file.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
                return !this.isExcludedFromIndex(virtualFile, this.$indexId, file.getProject());
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private final boolean isExcludedFromIndex(VirtualFile virtualFile, IndexId<?, ?> indexId, Project project) {
                if (project == null) return false;
                CharSequence charSequence = virtualFile.getNameSequence();
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNameSequence(...)");
                if (!StringsKt.endsWith$default((CharSequence)charSequence, (CharSequence)".kt", (boolean)false, (int)2, null)) return false;
                if ((Boolean)ActionsKt.runReadAction(() -> getFileTypeHintForAffectedIndex.1.isExcludedFromIndex$lambda$0(project, virtualFile, this)) == false) return false;
                return true;
            }

            private final boolean isUnderIndexablePath(VirtualFile virtualFile) {
                Path fileNormalizedPath;
                Path storageRoot = KotlinForwardDeclarationsFileSystem.Companion.getStorageRootPath();
                Path path2 = virtualFile.getFileSystem().getNioPath(virtualFile);
                Path path3 = fileNormalizedPath = path2 != null ? path2.normalize() : null;
                return path3 != null ? path3.startsWith(storageRoot) : false;
            }

            private static final boolean isExcludedFromIndex$lambda$0(Project $project, VirtualFile $virtualFile, getFileTypeHintForAffectedIndex.1 this$0) {
                return !ProjectFileIndex.getInstance((Project)$project).isInSource($virtualFile) && !this$0.isUnderIndexablePath($virtualFile);
            }
        };
    }

    public int getVersion() {
        return 0;
    }

    public boolean affectsIndex(@NotNull IndexId<?, ?> indexId) {
        Intrinsics.checkNotNullParameter(indexId, (String)"indexId");
        return this.enabled && indexId != TrigramIndex.INDEX_ID && indexId != FilenameIndex.NAME;
    }
}

